/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.sigar;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Memory;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarMemoryDto;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarRawData;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import io.dropwizard.util.SizeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.SystemUtils;

class SigarMemory
extends Memory<SigarRawData> {
    private SigarMemoryDto memoryDto;
    private RawDataFactory rawDataFactory;

    @Inject
    SigarMemory(@NonNull String memoryName, @Sim @NonNull MetricsService metricsService, @Sim @NonNull MachineProperties machineProperties, @NonNull Predicate<ToggleableReporter<SigarRawData>> isDisabledPredicate, @NonNull RawDataFactory rawDataFactory) {
        super(memoryName, metricsService, machineProperties, isDisabledPredicate, rawDataFactory);
        if (memoryName == null) {
            throw new NullPointerException("memoryName is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
        if (rawDataFactory == null) {
            throw new NullPointerException("rawDataFactory is marked non-null but is null");
        }
        this.rawDataFactory = rawDataFactory;
    }

    @Override
    public void update(SigarRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.memoryDto = rawData.getMemory();
    }

    @Override
    protected RawDataLong getSwapTotalMb() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return this.rawDataFactory.createLong("Unable to get swap metrics using Sigar");
        }
        return this.rawDataFactory.createLong(Long.valueOf(SizeUnit.BYTES.toMegabytes(this.memoryDto.getSwapTotalBytes())));
    }

    @Override
    protected RawDataLong getSwapFreeMb() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return this.rawDataFactory.createLong("Unable to get swap metrics using Sigar");
        }
        return this.rawDataFactory.createLong(Long.valueOf(SizeUnit.BYTES.toMegabytes(this.memoryDto.getSwapFreeBytes())));
    }

    @Override
    protected RawDataLong getPhysicalTotalMb() {
        return this.rawDataFactory.createLong(Long.valueOf(SizeUnit.BYTES.toMegabytes(this.memoryDto.getMemTotalBytes())));
    }

    @Override
    protected RawDataLong getPhysicalFreeMb() {
        return this.rawDataFactory.createLong(Long.valueOf(SizeUnit.BYTES.toMegabytes(this.memoryDto.getMemFreeBytes())));
    }

    @Generated
    public String toString() {
        return "SigarMemory(super=" + super.toString() + ", memoryDto=" + String.valueOf(this.memoryDto) + ", rawDataFactory=" + String.valueOf(this.rawDataFactory) + ")";
    }
}

