/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.sigar;

import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Load;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarLoadDto;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarRawData;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import lombok.Generated;
import lombok.NonNull;

class SigarLoad
extends Load<SigarRawData> {
    private static final String SIGAR_LOAD = ":sigarLoad";
    private final RawDataFactory rawDataFactory;
    private SigarLoadDto load;

    @Inject
    SigarLoad(@Sim @NonNull MetricsService metricsService, @NonNull Predicate<ToggleableReporter<SigarRawData>> isDisabledPredicate, RawDataFactory rawDataFactory) {
        super(SIGAR_LOAD, metricsService, isDisabledPredicate);
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
        this.rawDataFactory = rawDataFactory;
    }

    @Override
    public void update(SigarRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.load = rawData.getLoad();
    }

    @Override
    protected RawDataLong getLoadAverage1() {
        return this.rawDataFactory.createLong(Long.valueOf(this.load.getLoad1()));
    }

    @Override
    protected RawDataLong getLoadAverage5() {
        return this.rawDataFactory.createLong(Long.valueOf(this.load.getLoad5()));
    }

    @Override
    protected RawDataLong getLoadAverage15() {
        return this.rawDataFactory.createLong(Long.valueOf(this.load.getLoad15()));
    }

    @Override
    @Generated
    public String toString() {
        return "SigarLoad(super=" + super.toString() + ", rawDataFactory=" + String.valueOf(this.rawDataFactory) + ", load=" + String.valueOf(this.load) + ")";
    }
}

