/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.sigar;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentFactory;
import com.appdynamics.sim.agent.extensions.servers.model.Cpu;
import com.appdynamics.sim.agent.extensions.servers.model.Cpus;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.filter.Filters;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarCpuDto;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarRawData;
import com.appdynamics.sim.agent.extensions.servers.model.transformer.Transformer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.math.DoubleMath;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import lombok.NonNull;

class SigarCpus
extends Cpus<SigarRawData> {
    private static final long ONE_HUNDRED_PERCENT = 100L;
    private SigarCpuDto cpuData;
    private Optional<Long> percentStolen;
    private Optional<Long> percentUser;
    private Optional<Long> percentSystem;
    private Optional<Long> percentNice;
    private Optional<Long> percentWait;
    private Optional<Long> percentIrq;
    private Optional<Long> percentSoftIrq;
    private long percentIdle;
    private long percentBusy;

    @Inject
    @VisibleForTesting
    SigarCpus(@NonNull SimAgentRepetitiveLogger repetitiveLogger, @NonNull ComponentFactory<SigarRawData, Cpu<SigarRawData>> cpuFactory, @Sim @NonNull MetricsService metricsService, @Sim @NonNull MachineProperties machineProperties, @NonNull Filters<Cpu<SigarRawData>> filters, @NonNull Set<Transformer<Cpu<SigarRawData>>> metadataTransformers, @NonNull Predicate<ToggleableReporter<SigarRawData>> isDisabledPredicate) {
        super(repetitiveLogger, cpuFactory, metricsService, machineProperties, filters, metadataTransformers, isDisabledPredicate);
        if (repetitiveLogger == null) {
            throw new NullPointerException("repetitiveLogger is marked non-null but is null");
        }
        if (cpuFactory == null) {
            throw new NullPointerException("cpuFactory is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (metadataTransformers == null) {
            throw new NullPointerException("metadataTransformers is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
        this.percentStolen = Optional.absent();
        this.percentUser = Optional.absent();
        this.percentSystem = Optional.absent();
        this.percentNice = Optional.absent();
        this.percentWait = Optional.absent();
        this.percentIrq = Optional.absent();
        this.percentSoftIrq = Optional.absent();
    }

    @Override
    public void doAggregateUpdate(SigarRawData rawData) {
        this.cpuData = rawData.getCpu();
        this.percentStolen = this.average(this.cpuData.getCpuStolens());
        this.percentUser = this.average(this.cpuData.getCpuUsers());
        this.percentSystem = this.average(this.cpuData.getCpuSystems());
        this.percentNice = this.average(this.cpuData.getCpuNices());
        this.percentWait = this.average(this.cpuData.getCpuWaits());
        this.percentIrq = this.average(this.cpuData.getCpuIrqs());
        this.percentSoftIrq = this.average(this.cpuData.getCpuSoftIrqs());
        this.percentIdle = this.asPercent(DoubleMath.mean(this.cpuData.getCpuIdles()));
        this.percentBusy = 100L - this.percentIdle;
    }

    @Override
    protected long getPercentBusy() {
        return this.percentBusy;
    }

    @Override
    protected Optional<Long> getPercentStolen() {
        return this.percentStolen;
    }

    @Override
    protected long getPercentIdle() {
        return this.percentIdle;
    }

    @Override
    protected Optional<Long> getPercentUser() {
        return this.percentUser;
    }

    @Override
    protected Optional<Long> getPercentSystem() {
        return this.percentSystem;
    }

    @Override
    protected Optional<Long> getPercentNice() {
        return this.percentNice;
    }

    @Override
    protected Optional<Long> getPercentIRQ() {
        return this.percentIrq;
    }

    @Override
    protected Optional<Long> getPercentSoftIRQ() {
        return this.percentSoftIrq;
    }

    @Override
    protected Optional<Long> getPercentIoWait() {
        return this.percentWait;
    }

    @Override
    protected Set<String> extractIds(SigarRawData rawData) {
        return rawData.getCpu().getCpuInfos().keySet();
    }

    private Optional<Long> average(List<Double> cpuStolens) {
        if (cpuStolens.isEmpty()) {
            return Optional.absent();
        }
        long cpuStolen = this.asPercent(DoubleMath.mean(cpuStolens));
        return Optional.of((Object)cpuStolen);
    }

    private long asPercent(double fraction) {
        return Math.round(fraction * 100.0);
    }
}

