/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.sigar;

import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.IModule;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarProcessesDto;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarRawData;
import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.ProcCredName;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.Uptime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Processes
implements IModule<SigarProcessesDto> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Processes.class);
    private static final Optional<String> ABSENT_STRING_VALUE = Optional.absent();
    private static final Optional<Long> ABSENT_LONG_VALUE = Optional.absent();
    private static final String MAJOR_FAULTS_NOT_IMPLEMENTED = "Major faults metric is not implemented. ";
    private static final String MINOR_FAULTS_NOT_IMPLEMENTED = "Minor faults metric is not implemented. ";
    private final RawDataFactory factory;

    @Inject
    Processes(RawDataFactory factory) {
        this.factory = factory;
    }

    @Override
    public Optional<SigarProcessesDto> collectAndUpdate(SigarProxy sigar, SigarRawData result) {
        try {
            long[] processArray;
            Optional upTime;
            ImmutableMap.Builder pidToProcess = ImmutableMap.builder();
            Optional<Uptime> upTimeOpt = this.getUpTime(sigar);
            if (upTimeOpt.isPresent()) {
                Uptime uptime = (Uptime)upTimeOpt.get();
                upTime = Optional.of((Object)TimeUnit.SECONDS.toMillis((long)uptime.getUptime()));
            } else {
                upTime = ABSENT_LONG_VALUE;
            }
            for (long pid : processArray = sigar.getProcList()) {
                RawDataString group;
                RawDataString user;
                RawDataLong minorFault;
                RawDataLong majorFault;
                RawDataLong virtualMemorySizeBytes;
                RawDataLong rssSizeBytes;
                RawDataLong liveTimeMillis;
                RawDataLong cpuTimeMillis;
                RawDataString commandLine;
                RawDataLong nice;
                RawDataLong threadCount;
                RawDataString state;
                RawDataLong parentPid;
                RawDataString name;
                String pidStr = String.valueOf(pid);
                Optional<ProcState> procStateOpt = this.getProcState(sigar, pid);
                if (procStateOpt.isPresent()) {
                    ProcState procState = (ProcState)procStateOpt.get();
                    name = this.factory.createString(Optional.of((Object)procState.getName()));
                    parentPid = this.factory.createLong(Long.valueOf(procState.getPpid()));
                    state = this.factory.createString(Optional.of((Object)Character.toString(procState.getState())));
                    threadCount = this.factory.createLong(Long.valueOf(procState.getThreads()));
                    Integer niceIntValue = procState.getNice();
                    nice = this.factory.createLong(Long.valueOf(niceIntValue.intValue()));
                } else {
                    String errorMsg = "could not get proc state for process" + String.valueOf(pid);
                    name = this.factory.createString(ABSENT_STRING_VALUE, errorMsg);
                    parentPid = this.factory.createLong(errorMsg);
                    state = this.factory.createString(ABSENT_STRING_VALUE, errorMsg);
                    threadCount = this.factory.createLong(errorMsg);
                    nice = this.factory.createLong(errorMsg);
                }
                Optional<String[]> commandLineArrayOpt = this.getProcArgs(sigar, pid);
                if (commandLineArrayOpt.isPresent()) {
                    String[] commandLineArray = (String[])commandLineArrayOpt.get();
                    StringBuilder builder = new StringBuilder();
                    for (String s : commandLineArray) {
                        builder.append(s);
                        builder.append(" ");
                    }
                    String commandLineStr = builder.toString();
                    commandLineStr = commandLineStr.trim();
                    commandLine = this.factory.createString(Optional.of((Object)commandLineStr));
                } else {
                    String errorMsg = "could not get proc args for process" + String.valueOf(pid);
                    commandLine = this.factory.createString(ABSENT_STRING_VALUE, errorMsg);
                }
                Optional<ProcCpu> procCpuOpt = this.getProcCpu(sigar, pid);
                if (procCpuOpt.isPresent()) {
                    ProcCpu procCpu = (ProcCpu)procCpuOpt.get();
                    cpuTimeMillis = this.factory.createLong(Long.valueOf(procCpu.getTotal()));
                    long startTime = procCpu.getStartTime();
                    long lastTime = procCpu.getLastTime();
                    liveTimeMillis = this.factory.createLong(Long.valueOf(lastTime - startTime));
                } else {
                    String errorMsg = "could not get proc time for process" + String.valueOf(pid);
                    cpuTimeMillis = this.factory.createLong(errorMsg);
                    liveTimeMillis = this.factory.createLong(errorMsg);
                }
                Optional<ProcMem> procMemOpt = this.getProcMem(sigar, pid);
                if (procMemOpt.isPresent()) {
                    ProcMem procMem = (ProcMem)procMemOpt.get();
                    rssSizeBytes = this.factory.createLong(Long.valueOf(procMem.getResident()));
                    virtualMemorySizeBytes = this.factory.createLong(Long.valueOf(procMem.getSize()));
                    long rawMajorFaults = procMem.getMajorFaults();
                    majorFault = rawMajorFaults < 0L ? this.factory.createLong(MAJOR_FAULTS_NOT_IMPLEMENTED) : this.factory.createLong(Long.valueOf(procMem.getMajorFaults()));
                    long rawMinorFaults = procMem.getMinorFaults();
                    minorFault = rawMinorFaults < 0L ? this.factory.createLong(MINOR_FAULTS_NOT_IMPLEMENTED) : this.factory.createLong(Long.valueOf(procMem.getMinorFaults()));
                } else {
                    String errorMsg = "could not get proc mem for process" + String.valueOf(pid);
                    rssSizeBytes = this.factory.createLong(errorMsg);
                    virtualMemorySizeBytes = this.factory.createLong(errorMsg);
                    majorFault = this.factory.createLong(errorMsg);
                    minorFault = this.factory.createLong(errorMsg);
                }
                Optional<ProcCredName> procCredNameOpt = this.getProcCredName(sigar, pid);
                if (procCredNameOpt.isPresent()) {
                    ProcCredName procCredName = (ProcCredName)procCredNameOpt.get();
                    user = this.factory.createString(Optional.of((Object)procCredName.getUser()));
                    group = this.factory.createString(Optional.of((Object)procCredName.getGroup()));
                } else {
                    String errorMsg = "could not get proc cred name for process" + String.valueOf(pid);
                    user = this.factory.createString(ABSENT_STRING_VALUE, errorMsg);
                    group = this.factory.createString(ABSENT_STRING_VALUE, errorMsg);
                }
                SigarProcessesDto.Process process = SigarProcessesDto.Process.builder().pid(pid).name(name).parentPid(parentPid).state(state).threadCount(threadCount).nice(nice).commandLine(commandLine).cpuTimeMillis(cpuTimeMillis).liveTimeMillis(liveTimeMillis).rssSizeBytes(rssSizeBytes).virtualMemorySizeBytes(virtualMemorySizeBytes).majorFault(majorFault).minorFault(minorFault).user(user).group(group).build();
                pidToProcess.put((Object)pidStr, (Object)process);
            }
            SigarProcessesDto sigarProcessesDto = SigarProcessesDto.builder().pidToprocess((Map<String, SigarProcessesDto.Process>)pidToProcess.build()).procData((ListMultimap<String, SigarProcessesDto.ProcessRawData>)ArrayListMultimap.create()).uptime((Optional<Long>)upTime).build();
            result.setProcesses(sigarProcessesDto);
            return Optional.of((Object)sigarProcessesDto);
        }
        catch (Exception e) {
            log.error("Error while collecting process metrics", (Throwable)e);
            return Optional.absent();
        }
    }

    private Optional<ProcState> getProcState(SigarProxy sigar, long pid) {
        try {
            return Optional.fromNullable((Object)sigar.getProcState(pid));
        }
        catch (Exception e) {
            log.trace("Error while collecting ProcState for process {}. Error: {}", (Object)pid, (Object)e);
            return Optional.absent();
        }
    }

    private Optional<String[]> getProcArgs(SigarProxy sigar, long pid) {
        try {
            return Optional.fromNullable((Object)sigar.getProcArgs(pid));
        }
        catch (Exception e) {
            log.trace("Error while collecting Process arguments for process {}. Error: {}", (Object)pid, (Object)e);
            return Optional.absent();
        }
    }

    private Optional<ProcCpu> getProcCpu(SigarProxy sigar, long pid) {
        try {
            return Optional.fromNullable((Object)sigar.getProcCpu(pid));
        }
        catch (Exception e) {
            log.trace("Error while collecting process cpu for process {}. Error: {}", (Object)pid, (Object)e);
            return Optional.absent();
        }
    }

    private Optional<ProcMem> getProcMem(SigarProxy sigar, long pid) {
        try {
            return Optional.fromNullable((Object)sigar.getProcMem(pid));
        }
        catch (Exception e) {
            log.trace("Error while collecting process memory for process {}. Error: {}", (Object)pid, (Object)e);
            return Optional.absent();
        }
    }

    private Optional<ProcCredName> getProcCredName(SigarProxy sigar, long pid) {
        try {
            return Optional.fromNullable((Object)sigar.getProcCredName(pid));
        }
        catch (Exception e) {
            log.trace("Error while collecting process credentials names for process {}. Error: {}", (Object)pid, (Object)e);
            return Optional.absent();
        }
    }

    private Optional<Uptime> getUpTime(SigarProxy sigar) {
        try {
            return Optional.fromNullable((Object)sigar.getUptime());
        }
        catch (Exception e) {
            log.trace("Error while collecting UpTime {}. Error: {}", (Throwable)e);
            return Optional.absent();
        }
    }
}

