/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.sigar;

import com.appdynamics.sim.agent.extensions.servers.model.sigar.IModule;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarPartitionDto;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarRawData;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Map;
import lombok.Generated;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemMap;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Partitions
implements IModule<Map<String, SigarPartitionDto>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Partitions.class);

    @Inject
    Partitions() {
    }

    @Override
    public Optional<Map<String, SigarPartitionDto>> collectAndUpdate(SigarProxy sigar, SigarRawData result) {
        try {
            FileSystemMap fsMap = sigar.getFileSystemMap();
            ImmutableMap.Builder devNameToPartitionBuilder = ImmutableMap.builder();
            for (Object fileSystem : fsMap.keySet()) {
                boolean enabled;
                FileSystem fs = (FileSystem)fsMap.get(fileSystem);
                boolean bl = enabled = fs.getType() == 2 || fs.getType() == 3;
                if (enabled) {
                    String devName = fs.getDevName();
                    try {
                        FileSystemUsage usage = sigar.getFileSystemUsage(devName);
                        SigarPartitionDto partitionDto = SigarPartitionDto.builder().devName(devName).uptimeInSec((long)sigar.getUptime().getUptime()).diskReadBytes(usage.getDiskReadBytes()).diskReads(usage.getDiskReads()).diskWriteBytes(usage.getDiskWriteBytes()).diskWrites(usage.getDiskWrites()).diskQueue(usage.getDiskQueue()).diskServiceTime(usage.getDiskServiceTime()).spaceAvail(usage.getAvail()).spaceUsed(usage.getUsed()).build();
                        devNameToPartitionBuilder.put((Object)devName, (Object)partitionDto);
                    }
                    catch (SigarException e) {
                        log.debug("Skipping partition {}", (Object)devName, (Object)e);
                    }
                    continue;
                }
                log.debug("Skipping disabled fs : {}", (Object)fs);
            }
            result.setDevNameToPartition((Map<String, SigarPartitionDto>)devNameToPartitionBuilder.build());
            return Optional.of(result.getDevNameToPartition());
        }
        catch (Exception e) {
            log.debug("Failed to collect partition metrics", (Throwable)e);
            return Optional.absent();
        }
    }
}

