/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.newlinux;

import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataConstants;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.google.common.base.Optional;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class NewLinuxVolumesUtil {
    private static final String DEV = "/dev";

    public static RawDataString getBasePartitionName(@NonNull RawDataString partitionName, @NonNull RawDataFactory factory) {
        if (partitionName == null) {
            throw new NullPointerException("partitionName is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (!partitionName.isPresent() || StringUtils.isEmpty((CharSequence)partitionName.get())) {
            return RawDataConstants.ABSENT_STRING;
        }
        String partitionNameString = partitionName.get();
        if (partitionNameString.startsWith(DEV)) {
            String transformedName = FilenameUtils.getBaseName((String)partitionNameString);
            return factory.createString(Optional.of((Object)transformedName));
        }
        return partitionName;
    }
}

