/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.newlinux;

import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataConstants;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.model.ProcessClassIdCreator;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public class NewLinuxRawData {
    @NonNull
    private Memory memory;
    @NonNull
    private Memory freeCommandOutput;
    @NonNull
    private Map<String, NetworkInfoViaSysClassNet> networkToSysClassNet = Collections.emptyMap();
    @NonNull
    private Map<String, NetworkInfoViaIpAddr> networkToIpAddr = Collections.emptyMap();
    @NonNull
    private Map<String, String> networkToIpv4DefaultGateway = Collections.emptyMap();
    @NonNull
    private Map<String, String> networkToIpv6DefaultGateway = Collections.emptyMap();
    @NonNull
    private Map<String, NetworkInfoViaProcNetDev> networkToProcNetDev = Collections.emptyMap();
    @NonNull
    private Load load;
    @NonNull
    private OperatingSystem operatingSystem;
    @NonNull
    private Map<String, Processor> processors = Collections.emptyMap();
    @NonNull
    private Map<String, Cpu> cpus = Collections.emptyMap();
    @NonNull
    private Map<String, CpuPerf> cpuPerfs = Collections.emptyMap();
    @NonNull
    private Map<String, Volume> volumes = Collections.emptyMap();
    @NonNull
    private Map<String, Long> diskSectorSizes = Collections.emptyMap();
    @NonNull
    private Map<String, Partition> partitions = Collections.emptyMap();
    @NonNull
    private Map<String, NfsPartition> nfsPartitions = Collections.emptyMap();
    private long totalNumLogicalProcessors;
    @NonNull
    private Map<String, Process> processes = Collections.emptyMap();
    @NonNull
    private ListMultimap<String, ProcessRawData> procData = ArrayListMultimap.create();
    private long epochTime;

    public NewLinuxRawData(Load load, Memory memory, Memory freeCommandOutput, OperatingSystem operationSystem, Map<String, NetworkInfoViaSysClassNet> networkToSysClassNet, Map<String, NetworkInfoViaIpAddr> networkToIpAddr, Map<String, String> networkToIpv4DefaultGateway, Map<String, String> networkToIpv6DefaultGateway, Map<String, NetworkInfoViaProcNetDev> networkToProcNetDev, Map<String, Cpu> cpus, Map<String, CpuPerf> cpuPerfs, Map<String, Process> processes, long epochTime, Map<String, Volume> volumes, Map<String, Long> diskSectorSizes, Map<String, Partition> partitions, Map<String, NfsPartition> nfsPartitions) {
        this.load = load;
        this.memory = memory;
        this.freeCommandOutput = freeCommandOutput;
        this.networkToSysClassNet = networkToSysClassNet;
        this.networkToIpAddr = networkToIpAddr;
        this.networkToIpv4DefaultGateway = networkToIpv4DefaultGateway;
        this.networkToIpv6DefaultGateway = networkToIpv6DefaultGateway;
        this.networkToProcNetDev = networkToProcNetDev;
        this.volumes = volumes;
        this.diskSectorSizes = diskSectorSizes;
        this.partitions = partitions;
        this.nfsPartitions = nfsPartitions;
        this.operatingSystem = operationSystem;
        this.cpus = cpus;
        this.cpuPerfs = cpuPerfs;
        this.processes = processes;
        this.epochTime = epochTime;
    }

    @NonNull
    @Generated
    public Memory getMemory() {
        return this.memory;
    }

    @NonNull
    @Generated
    public Memory getFreeCommandOutput() {
        return this.freeCommandOutput;
    }

    @NonNull
    @Generated
    public Map<String, NetworkInfoViaSysClassNet> getNetworkToSysClassNet() {
        return this.networkToSysClassNet;
    }

    @NonNull
    @Generated
    public Map<String, NetworkInfoViaIpAddr> getNetworkToIpAddr() {
        return this.networkToIpAddr;
    }

    @NonNull
    @Generated
    public Map<String, String> getNetworkToIpv4DefaultGateway() {
        return this.networkToIpv4DefaultGateway;
    }

    @NonNull
    @Generated
    public Map<String, String> getNetworkToIpv6DefaultGateway() {
        return this.networkToIpv6DefaultGateway;
    }

    @NonNull
    @Generated
    public Map<String, NetworkInfoViaProcNetDev> getNetworkToProcNetDev() {
        return this.networkToProcNetDev;
    }

    @NonNull
    @Generated
    public Load getLoad() {
        return this.load;
    }

    @NonNull
    @Generated
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @NonNull
    @Generated
    public Map<String, Processor> getProcessors() {
        return this.processors;
    }

    @NonNull
    @Generated
    public Map<String, Cpu> getCpus() {
        return this.cpus;
    }

    @NonNull
    @Generated
    public Map<String, CpuPerf> getCpuPerfs() {
        return this.cpuPerfs;
    }

    @NonNull
    @Generated
    public Map<String, Volume> getVolumes() {
        return this.volumes;
    }

    @NonNull
    @Generated
    public Map<String, Long> getDiskSectorSizes() {
        return this.diskSectorSizes;
    }

    @NonNull
    @Generated
    public Map<String, Partition> getPartitions() {
        return this.partitions;
    }

    @NonNull
    @Generated
    public Map<String, NfsPartition> getNfsPartitions() {
        return this.nfsPartitions;
    }

    @NonNull
    @Generated
    public Map<String, Process> getProcesses() {
        return this.processes;
    }

    @NonNull
    @Generated
    public ListMultimap<String, ProcessRawData> getProcData() {
        return this.procData;
    }

    @Generated
    public long getEpochTime() {
        return this.epochTime;
    }

    @Generated
    public void setMemory(@NonNull Memory memory) {
        if (memory == null) {
            throw new NullPointerException("memory is marked non-null but is null");
        }
        this.memory = memory;
    }

    @Generated
    public void setFreeCommandOutput(@NonNull Memory freeCommandOutput) {
        if (freeCommandOutput == null) {
            throw new NullPointerException("freeCommandOutput is marked non-null but is null");
        }
        this.freeCommandOutput = freeCommandOutput;
    }

    @Generated
    public void setNetworkToSysClassNet(@NonNull Map<String, NetworkInfoViaSysClassNet> networkToSysClassNet) {
        if (networkToSysClassNet == null) {
            throw new NullPointerException("networkToSysClassNet is marked non-null but is null");
        }
        this.networkToSysClassNet = networkToSysClassNet;
    }

    @Generated
    public void setNetworkToIpAddr(@NonNull Map<String, NetworkInfoViaIpAddr> networkToIpAddr) {
        if (networkToIpAddr == null) {
            throw new NullPointerException("networkToIpAddr is marked non-null but is null");
        }
        this.networkToIpAddr = networkToIpAddr;
    }

    @Generated
    public void setNetworkToIpv4DefaultGateway(@NonNull Map<String, String> networkToIpv4DefaultGateway) {
        if (networkToIpv4DefaultGateway == null) {
            throw new NullPointerException("networkToIpv4DefaultGateway is marked non-null but is null");
        }
        this.networkToIpv4DefaultGateway = networkToIpv4DefaultGateway;
    }

    @Generated
    public void setNetworkToIpv6DefaultGateway(@NonNull Map<String, String> networkToIpv6DefaultGateway) {
        if (networkToIpv6DefaultGateway == null) {
            throw new NullPointerException("networkToIpv6DefaultGateway is marked non-null but is null");
        }
        this.networkToIpv6DefaultGateway = networkToIpv6DefaultGateway;
    }

    @Generated
    public void setNetworkToProcNetDev(@NonNull Map<String, NetworkInfoViaProcNetDev> networkToProcNetDev) {
        if (networkToProcNetDev == null) {
            throw new NullPointerException("networkToProcNetDev is marked non-null but is null");
        }
        this.networkToProcNetDev = networkToProcNetDev;
    }

    @Generated
    public void setLoad(@NonNull Load load) {
        if (load == null) {
            throw new NullPointerException("load is marked non-null but is null");
        }
        this.load = load;
    }

    @Generated
    public void setOperatingSystem(@NonNull OperatingSystem operatingSystem) {
        if (operatingSystem == null) {
            throw new NullPointerException("operatingSystem is marked non-null but is null");
        }
        this.operatingSystem = operatingSystem;
    }

    @Generated
    public void setProcessors(@NonNull Map<String, Processor> processors) {
        if (processors == null) {
            throw new NullPointerException("processors is marked non-null but is null");
        }
        this.processors = processors;
    }

    @Generated
    public void setCpus(@NonNull Map<String, Cpu> cpus) {
        if (cpus == null) {
            throw new NullPointerException("cpus is marked non-null but is null");
        }
        this.cpus = cpus;
    }

    @Generated
    public void setCpuPerfs(@NonNull Map<String, CpuPerf> cpuPerfs) {
        if (cpuPerfs == null) {
            throw new NullPointerException("cpuPerfs is marked non-null but is null");
        }
        this.cpuPerfs = cpuPerfs;
    }

    @Generated
    public void setVolumes(@NonNull Map<String, Volume> volumes) {
        if (volumes == null) {
            throw new NullPointerException("volumes is marked non-null but is null");
        }
        this.volumes = volumes;
    }

    @Generated
    public void setDiskSectorSizes(@NonNull Map<String, Long> diskSectorSizes) {
        if (diskSectorSizes == null) {
            throw new NullPointerException("diskSectorSizes is marked non-null but is null");
        }
        this.diskSectorSizes = diskSectorSizes;
    }

    @Generated
    public void setPartitions(@NonNull Map<String, Partition> partitions) {
        if (partitions == null) {
            throw new NullPointerException("partitions is marked non-null but is null");
        }
        this.partitions = partitions;
    }

    @Generated
    public void setNfsPartitions(@NonNull Map<String, NfsPartition> nfsPartitions) {
        if (nfsPartitions == null) {
            throw new NullPointerException("nfsPartitions is marked non-null but is null");
        }
        this.nfsPartitions = nfsPartitions;
    }

    @Generated
    public void setProcesses(@NonNull Map<String, Process> processes) {
        if (processes == null) {
            throw new NullPointerException("processes is marked non-null but is null");
        }
        this.processes = processes;
    }

    @Generated
    public void setProcData(@NonNull ListMultimap<String, ProcessRawData> procData) {
        if (procData == null) {
            throw new NullPointerException("procData is marked non-null but is null");
        }
        this.procData = procData;
    }

    @Generated
    public void setEpochTime(long epochTime) {
        this.epochTime = epochTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewLinuxRawData)) {
            return false;
        }
        NewLinuxRawData other = (NewLinuxRawData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalNumLogicalProcessors() != other.getTotalNumLogicalProcessors()) {
            return false;
        }
        if (this.getEpochTime() != other.getEpochTime()) {
            return false;
        }
        Memory this$memory = this.getMemory();
        Memory other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !((Object)this$memory).equals(other$memory)) {
            return false;
        }
        Memory this$freeCommandOutput = this.getFreeCommandOutput();
        Memory other$freeCommandOutput = other.getFreeCommandOutput();
        if (this$freeCommandOutput == null ? other$freeCommandOutput != null : !((Object)this$freeCommandOutput).equals(other$freeCommandOutput)) {
            return false;
        }
        Map<String, NetworkInfoViaSysClassNet> this$networkToSysClassNet = this.getNetworkToSysClassNet();
        Map<String, NetworkInfoViaSysClassNet> other$networkToSysClassNet = other.getNetworkToSysClassNet();
        if (this$networkToSysClassNet == null ? other$networkToSysClassNet != null : !((Object)this$networkToSysClassNet).equals(other$networkToSysClassNet)) {
            return false;
        }
        Map<String, NetworkInfoViaIpAddr> this$networkToIpAddr = this.getNetworkToIpAddr();
        Map<String, NetworkInfoViaIpAddr> other$networkToIpAddr = other.getNetworkToIpAddr();
        if (this$networkToIpAddr == null ? other$networkToIpAddr != null : !((Object)this$networkToIpAddr).equals(other$networkToIpAddr)) {
            return false;
        }
        Map<String, String> this$networkToIpv4DefaultGateway = this.getNetworkToIpv4DefaultGateway();
        Map<String, String> other$networkToIpv4DefaultGateway = other.getNetworkToIpv4DefaultGateway();
        if (this$networkToIpv4DefaultGateway == null ? other$networkToIpv4DefaultGateway != null : !((Object)this$networkToIpv4DefaultGateway).equals(other$networkToIpv4DefaultGateway)) {
            return false;
        }
        Map<String, String> this$networkToIpv6DefaultGateway = this.getNetworkToIpv6DefaultGateway();
        Map<String, String> other$networkToIpv6DefaultGateway = other.getNetworkToIpv6DefaultGateway();
        if (this$networkToIpv6DefaultGateway == null ? other$networkToIpv6DefaultGateway != null : !((Object)this$networkToIpv6DefaultGateway).equals(other$networkToIpv6DefaultGateway)) {
            return false;
        }
        Map<String, NetworkInfoViaProcNetDev> this$networkToProcNetDev = this.getNetworkToProcNetDev();
        Map<String, NetworkInfoViaProcNetDev> other$networkToProcNetDev = other.getNetworkToProcNetDev();
        if (this$networkToProcNetDev == null ? other$networkToProcNetDev != null : !((Object)this$networkToProcNetDev).equals(other$networkToProcNetDev)) {
            return false;
        }
        Load this$load = this.getLoad();
        Load other$load = other.getLoad();
        if (this$load == null ? other$load != null : !((Object)this$load).equals(other$load)) {
            return false;
        }
        OperatingSystem this$operatingSystem = this.getOperatingSystem();
        OperatingSystem other$operatingSystem = other.getOperatingSystem();
        if (this$operatingSystem == null ? other$operatingSystem != null : !((Object)this$operatingSystem).equals(other$operatingSystem)) {
            return false;
        }
        Map<String, Processor> this$processors = this.getProcessors();
        Map<String, Processor> other$processors = other.getProcessors();
        if (this$processors == null ? other$processors != null : !((Object)this$processors).equals(other$processors)) {
            return false;
        }
        Map<String, Cpu> this$cpus = this.getCpus();
        Map<String, Cpu> other$cpus = other.getCpus();
        if (this$cpus == null ? other$cpus != null : !((Object)this$cpus).equals(other$cpus)) {
            return false;
        }
        Map<String, CpuPerf> this$cpuPerfs = this.getCpuPerfs();
        Map<String, CpuPerf> other$cpuPerfs = other.getCpuPerfs();
        if (this$cpuPerfs == null ? other$cpuPerfs != null : !((Object)this$cpuPerfs).equals(other$cpuPerfs)) {
            return false;
        }
        Map<String, Volume> this$volumes = this.getVolumes();
        Map<String, Volume> other$volumes = other.getVolumes();
        if (this$volumes == null ? other$volumes != null : !((Object)this$volumes).equals(other$volumes)) {
            return false;
        }
        Map<String, Long> this$diskSectorSizes = this.getDiskSectorSizes();
        Map<String, Long> other$diskSectorSizes = other.getDiskSectorSizes();
        if (this$diskSectorSizes == null ? other$diskSectorSizes != null : !((Object)this$diskSectorSizes).equals(other$diskSectorSizes)) {
            return false;
        }
        Map<String, Partition> this$partitions = this.getPartitions();
        Map<String, Partition> other$partitions = other.getPartitions();
        if (this$partitions == null ? other$partitions != null : !((Object)this$partitions).equals(other$partitions)) {
            return false;
        }
        Map<String, NfsPartition> this$nfsPartitions = this.getNfsPartitions();
        Map<String, NfsPartition> other$nfsPartitions = other.getNfsPartitions();
        if (this$nfsPartitions == null ? other$nfsPartitions != null : !((Object)this$nfsPartitions).equals(other$nfsPartitions)) {
            return false;
        }
        Map<String, Process> this$processes = this.getProcesses();
        Map<String, Process> other$processes = other.getProcesses();
        if (this$processes == null ? other$processes != null : !((Object)this$processes).equals(other$processes)) {
            return false;
        }
        ListMultimap<String, ProcessRawData> this$procData = this.getProcData();
        ListMultimap<String, ProcessRawData> other$procData = other.getProcData();
        return !(this$procData == null ? other$procData != null : !this$procData.equals(other$procData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NewLinuxRawData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $totalNumLogicalProcessors = this.getTotalNumLogicalProcessors();
        result = result * 59 + (int)($totalNumLogicalProcessors >>> 32 ^ $totalNumLogicalProcessors);
        long $epochTime = this.getEpochTime();
        result = result * 59 + (int)($epochTime >>> 32 ^ $epochTime);
        Memory $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : ((Object)$memory).hashCode());
        Memory $freeCommandOutput = this.getFreeCommandOutput();
        result = result * 59 + ($freeCommandOutput == null ? 43 : ((Object)$freeCommandOutput).hashCode());
        Map<String, NetworkInfoViaSysClassNet> $networkToSysClassNet = this.getNetworkToSysClassNet();
        result = result * 59 + ($networkToSysClassNet == null ? 43 : ((Object)$networkToSysClassNet).hashCode());
        Map<String, NetworkInfoViaIpAddr> $networkToIpAddr = this.getNetworkToIpAddr();
        result = result * 59 + ($networkToIpAddr == null ? 43 : ((Object)$networkToIpAddr).hashCode());
        Map<String, String> $networkToIpv4DefaultGateway = this.getNetworkToIpv4DefaultGateway();
        result = result * 59 + ($networkToIpv4DefaultGateway == null ? 43 : ((Object)$networkToIpv4DefaultGateway).hashCode());
        Map<String, String> $networkToIpv6DefaultGateway = this.getNetworkToIpv6DefaultGateway();
        result = result * 59 + ($networkToIpv6DefaultGateway == null ? 43 : ((Object)$networkToIpv6DefaultGateway).hashCode());
        Map<String, NetworkInfoViaProcNetDev> $networkToProcNetDev = this.getNetworkToProcNetDev();
        result = result * 59 + ($networkToProcNetDev == null ? 43 : ((Object)$networkToProcNetDev).hashCode());
        Load $load = this.getLoad();
        result = result * 59 + ($load == null ? 43 : ((Object)$load).hashCode());
        OperatingSystem $operatingSystem = this.getOperatingSystem();
        result = result * 59 + ($operatingSystem == null ? 43 : ((Object)$operatingSystem).hashCode());
        Map<String, Processor> $processors = this.getProcessors();
        result = result * 59 + ($processors == null ? 43 : ((Object)$processors).hashCode());
        Map<String, Cpu> $cpus = this.getCpus();
        result = result * 59 + ($cpus == null ? 43 : ((Object)$cpus).hashCode());
        Map<String, CpuPerf> $cpuPerfs = this.getCpuPerfs();
        result = result * 59 + ($cpuPerfs == null ? 43 : ((Object)$cpuPerfs).hashCode());
        Map<String, Volume> $volumes = this.getVolumes();
        result = result * 59 + ($volumes == null ? 43 : ((Object)$volumes).hashCode());
        Map<String, Long> $diskSectorSizes = this.getDiskSectorSizes();
        result = result * 59 + ($diskSectorSizes == null ? 43 : ((Object)$diskSectorSizes).hashCode());
        Map<String, Partition> $partitions = this.getPartitions();
        result = result * 59 + ($partitions == null ? 43 : ((Object)$partitions).hashCode());
        Map<String, NfsPartition> $nfsPartitions = this.getNfsPartitions();
        result = result * 59 + ($nfsPartitions == null ? 43 : ((Object)$nfsPartitions).hashCode());
        Map<String, Process> $processes = this.getProcesses();
        result = result * 59 + ($processes == null ? 43 : ((Object)$processes).hashCode());
        ListMultimap<String, ProcessRawData> $procData = this.getProcData();
        result = result * 59 + ($procData == null ? 43 : $procData.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NewLinuxRawData(memory=" + String.valueOf(this.getMemory()) + ", freeCommandOutput=" + String.valueOf(this.getFreeCommandOutput()) + ", networkToSysClassNet=" + String.valueOf(this.getNetworkToSysClassNet()) + ", networkToIpAddr=" + String.valueOf(this.getNetworkToIpAddr()) + ", networkToIpv4DefaultGateway=" + String.valueOf(this.getNetworkToIpv4DefaultGateway()) + ", networkToIpv6DefaultGateway=" + String.valueOf(this.getNetworkToIpv6DefaultGateway()) + ", networkToProcNetDev=" + String.valueOf(this.getNetworkToProcNetDev()) + ", load=" + String.valueOf(this.getLoad()) + ", operatingSystem=" + String.valueOf(this.getOperatingSystem()) + ", processors=" + String.valueOf(this.getProcessors()) + ", cpus=" + String.valueOf(this.getCpus()) + ", cpuPerfs=" + String.valueOf(this.getCpuPerfs()) + ", volumes=" + String.valueOf(this.getVolumes()) + ", diskSectorSizes=" + String.valueOf(this.getDiskSectorSizes()) + ", partitions=" + String.valueOf(this.getPartitions()) + ", nfsPartitions=" + String.valueOf(this.getNfsPartitions()) + ", totalNumLogicalProcessors=" + this.getTotalNumLogicalProcessors() + ", processes=" + String.valueOf(this.getProcesses()) + ", procData=" + String.valueOf(this.getProcData()) + ", epochTime=" + this.getEpochTime() + ")";
    }

    @Generated
    protected NewLinuxRawData() {
    }

    @Generated
    long getTotalNumLogicalProcessors() {
        return this.totalNumLogicalProcessors;
    }

    @Generated
    void setTotalNumLogicalProcessors(long totalNumLogicalProcessors) {
        this.totalNumLogicalProcessors = totalNumLogicalProcessors;
    }

    static class Load {
        private RawDataLong oneMinute;
        private RawDataLong fiveMinutes;
        private RawDataLong fifteenMinutes;

        @Generated
        public static LoadBuilder builder() {
            return new LoadBuilder();
        }

        @Generated
        public RawDataLong getOneMinute() {
            return this.oneMinute;
        }

        @Generated
        public RawDataLong getFiveMinutes() {
            return this.fiveMinutes;
        }

        @Generated
        public RawDataLong getFifteenMinutes() {
            return this.fifteenMinutes;
        }

        @Generated
        public void setOneMinute(RawDataLong oneMinute) {
            this.oneMinute = oneMinute;
        }

        @Generated
        public void setFiveMinutes(RawDataLong fiveMinutes) {
            this.fiveMinutes = fiveMinutes;
        }

        @Generated
        public void setFifteenMinutes(RawDataLong fifteenMinutes) {
            this.fifteenMinutes = fifteenMinutes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Load)) {
                return false;
            }
            Load other = (Load)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RawDataLong this$oneMinute = this.getOneMinute();
            RawDataLong other$oneMinute = other.getOneMinute();
            if (this$oneMinute == null ? other$oneMinute != null : !this$oneMinute.equals(other$oneMinute)) {
                return false;
            }
            RawDataLong this$fiveMinutes = this.getFiveMinutes();
            RawDataLong other$fiveMinutes = other.getFiveMinutes();
            if (this$fiveMinutes == null ? other$fiveMinutes != null : !this$fiveMinutes.equals(other$fiveMinutes)) {
                return false;
            }
            RawDataLong this$fifteenMinutes = this.getFifteenMinutes();
            RawDataLong other$fifteenMinutes = other.getFifteenMinutes();
            return !(this$fifteenMinutes == null ? other$fifteenMinutes != null : !this$fifteenMinutes.equals(other$fifteenMinutes));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Load;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RawDataLong $oneMinute = this.getOneMinute();
            result = result * 59 + ($oneMinute == null ? 43 : $oneMinute.hashCode());
            RawDataLong $fiveMinutes = this.getFiveMinutes();
            result = result * 59 + ($fiveMinutes == null ? 43 : $fiveMinutes.hashCode());
            RawDataLong $fifteenMinutes = this.getFifteenMinutes();
            result = result * 59 + ($fifteenMinutes == null ? 43 : $fifteenMinutes.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NewLinuxRawData.Load(oneMinute=" + String.valueOf(this.getOneMinute()) + ", fiveMinutes=" + String.valueOf(this.getFiveMinutes()) + ", fifteenMinutes=" + String.valueOf(this.getFifteenMinutes()) + ")";
        }

        @Generated
        public Load(RawDataLong oneMinute, RawDataLong fiveMinutes, RawDataLong fifteenMinutes) {
            this.oneMinute = oneMinute;
            this.fiveMinutes = fiveMinutes;
            this.fifteenMinutes = fifteenMinutes;
        }

        @Generated
        protected Load() {
        }

        @Generated
        public static class LoadBuilder {
            @Generated
            private RawDataLong oneMinute;
            @Generated
            private RawDataLong fiveMinutes;
            @Generated
            private RawDataLong fifteenMinutes;

            @Generated
            LoadBuilder() {
            }

            @Generated
            public LoadBuilder oneMinute(RawDataLong oneMinute) {
                this.oneMinute = oneMinute;
                return this;
            }

            @Generated
            public LoadBuilder fiveMinutes(RawDataLong fiveMinutes) {
                this.fiveMinutes = fiveMinutes;
                return this;
            }

            @Generated
            public LoadBuilder fifteenMinutes(RawDataLong fifteenMinutes) {
                this.fifteenMinutes = fifteenMinutes;
                return this;
            }

            @Generated
            public Load build() {
                return new Load(this.oneMinute, this.fiveMinutes, this.fifteenMinutes);
            }

            @Generated
            public String toString() {
                return "NewLinuxRawData.Load.LoadBuilder(oneMinute=" + String.valueOf(this.oneMinute) + ", fiveMinutes=" + String.valueOf(this.fiveMinutes) + ", fifteenMinutes=" + String.valueOf(this.fifteenMinutes) + ")";
            }
        }
    }

    static class Memory {
        private RawDataLong totalKb;
        private RawDataLong availableKb;
        private RawDataLong freeKb;
        private RawDataLong usedKb;
        private RawDataLong slabReclaimableKb;
        private RawDataLong swapTotalKb;
        private RawDataLong swapFreeKb;
        private RawDataLong swapUsedKb;

        @Generated
        private static RawDataLong $default$availableKb() {
            return RawDataConstants.ABSENT_LONG;
        }

        @Generated
        private static RawDataLong $default$freeKb() {
            return RawDataConstants.ABSENT_LONG;
        }

        @Generated
        private static RawDataLong $default$usedKb() {
            return RawDataConstants.ABSENT_LONG;
        }

        @Generated
        private static RawDataLong $default$slabReclaimableKb() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$swapUsedKb() {
            return RawDataConstants.ABSENT_LONG;
        }

        @Generated
        public static MemoryBuilder builder() {
            return new MemoryBuilder();
        }

        @Generated
        public RawDataLong getTotalKb() {
            return this.totalKb;
        }

        @Generated
        public RawDataLong getAvailableKb() {
            return this.availableKb;
        }

        @Generated
        public RawDataLong getFreeKb() {
            return this.freeKb;
        }

        @Generated
        public RawDataLong getUsedKb() {
            return this.usedKb;
        }

        @Generated
        public RawDataLong getSlabReclaimableKb() {
            return this.slabReclaimableKb;
        }

        @Generated
        public RawDataLong getSwapTotalKb() {
            return this.swapTotalKb;
        }

        @Generated
        public RawDataLong getSwapFreeKb() {
            return this.swapFreeKb;
        }

        @Generated
        public RawDataLong getSwapUsedKb() {
            return this.swapUsedKb;
        }

        @Generated
        public void setTotalKb(RawDataLong totalKb) {
            this.totalKb = totalKb;
        }

        @Generated
        public void setAvailableKb(RawDataLong availableKb) {
            this.availableKb = availableKb;
        }

        @Generated
        public void setFreeKb(RawDataLong freeKb) {
            this.freeKb = freeKb;
        }

        @Generated
        public void setUsedKb(RawDataLong usedKb) {
            this.usedKb = usedKb;
        }

        @Generated
        public void setSlabReclaimableKb(RawDataLong slabReclaimableKb) {
            this.slabReclaimableKb = slabReclaimableKb;
        }

        @Generated
        public void setSwapTotalKb(RawDataLong swapTotalKb) {
            this.swapTotalKb = swapTotalKb;
        }

        @Generated
        public void setSwapFreeKb(RawDataLong swapFreeKb) {
            this.swapFreeKb = swapFreeKb;
        }

        @Generated
        public void setSwapUsedKb(RawDataLong swapUsedKb) {
            this.swapUsedKb = swapUsedKb;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Memory)) {
                return false;
            }
            Memory other = (Memory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RawDataLong this$totalKb = this.getTotalKb();
            RawDataLong other$totalKb = other.getTotalKb();
            if (this$totalKb == null ? other$totalKb != null : !this$totalKb.equals(other$totalKb)) {
                return false;
            }
            RawDataLong this$availableKb = this.getAvailableKb();
            RawDataLong other$availableKb = other.getAvailableKb();
            if (this$availableKb == null ? other$availableKb != null : !this$availableKb.equals(other$availableKb)) {
                return false;
            }
            RawDataLong this$freeKb = this.getFreeKb();
            RawDataLong other$freeKb = other.getFreeKb();
            if (this$freeKb == null ? other$freeKb != null : !this$freeKb.equals(other$freeKb)) {
                return false;
            }
            RawDataLong this$usedKb = this.getUsedKb();
            RawDataLong other$usedKb = other.getUsedKb();
            if (this$usedKb == null ? other$usedKb != null : !this$usedKb.equals(other$usedKb)) {
                return false;
            }
            RawDataLong this$slabReclaimableKb = this.getSlabReclaimableKb();
            RawDataLong other$slabReclaimableKb = other.getSlabReclaimableKb();
            if (this$slabReclaimableKb == null ? other$slabReclaimableKb != null : !this$slabReclaimableKb.equals(other$slabReclaimableKb)) {
                return false;
            }
            RawDataLong this$swapTotalKb = this.getSwapTotalKb();
            RawDataLong other$swapTotalKb = other.getSwapTotalKb();
            if (this$swapTotalKb == null ? other$swapTotalKb != null : !this$swapTotalKb.equals(other$swapTotalKb)) {
                return false;
            }
            RawDataLong this$swapFreeKb = this.getSwapFreeKb();
            RawDataLong other$swapFreeKb = other.getSwapFreeKb();
            if (this$swapFreeKb == null ? other$swapFreeKb != null : !this$swapFreeKb.equals(other$swapFreeKb)) {
                return false;
            }
            RawDataLong this$swapUsedKb = this.getSwapUsedKb();
            RawDataLong other$swapUsedKb = other.getSwapUsedKb();
            return !(this$swapUsedKb == null ? other$swapUsedKb != null : !this$swapUsedKb.equals(other$swapUsedKb));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Memory;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RawDataLong $totalKb = this.getTotalKb();
            result = result * 59 + ($totalKb == null ? 43 : $totalKb.hashCode());
            RawDataLong $availableKb = this.getAvailableKb();
            result = result * 59 + ($availableKb == null ? 43 : $availableKb.hashCode());
            RawDataLong $freeKb = this.getFreeKb();
            result = result * 59 + ($freeKb == null ? 43 : $freeKb.hashCode());
            RawDataLong $usedKb = this.getUsedKb();
            result = result * 59 + ($usedKb == null ? 43 : $usedKb.hashCode());
            RawDataLong $slabReclaimableKb = this.getSlabReclaimableKb();
            result = result * 59 + ($slabReclaimableKb == null ? 43 : $slabReclaimableKb.hashCode());
            RawDataLong $swapTotalKb = this.getSwapTotalKb();
            result = result * 59 + ($swapTotalKb == null ? 43 : $swapTotalKb.hashCode());
            RawDataLong $swapFreeKb = this.getSwapFreeKb();
            result = result * 59 + ($swapFreeKb == null ? 43 : $swapFreeKb.hashCode());
            RawDataLong $swapUsedKb = this.getSwapUsedKb();
            result = result * 59 + ($swapUsedKb == null ? 43 : $swapUsedKb.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NewLinuxRawData.Memory(totalKb=" + String.valueOf(this.getTotalKb()) + ", availableKb=" + String.valueOf(this.getAvailableKb()) + ", freeKb=" + String.valueOf(this.getFreeKb()) + ", usedKb=" + String.valueOf(this.getUsedKb()) + ", slabReclaimableKb=" + String.valueOf(this.getSlabReclaimableKb()) + ", swapTotalKb=" + String.valueOf(this.getSwapTotalKb()) + ", swapFreeKb=" + String.valueOf(this.getSwapFreeKb()) + ", swapUsedKb=" + String.valueOf(this.getSwapUsedKb()) + ")";
        }

        @Generated
        public Memory(RawDataLong totalKb, RawDataLong availableKb, RawDataLong freeKb, RawDataLong usedKb, RawDataLong slabReclaimableKb, RawDataLong swapTotalKb, RawDataLong swapFreeKb, RawDataLong swapUsedKb) {
            this.totalKb = totalKb;
            this.availableKb = availableKb;
            this.freeKb = freeKb;
            this.usedKb = usedKb;
            this.slabReclaimableKb = slabReclaimableKb;
            this.swapTotalKb = swapTotalKb;
            this.swapFreeKb = swapFreeKb;
            this.swapUsedKb = swapUsedKb;
        }

        @Generated
        protected Memory() {
            this.availableKb = Memory.$default$availableKb();
            this.freeKb = Memory.$default$freeKb();
            this.usedKb = Memory.$default$usedKb();
            this.slabReclaimableKb = Memory.$default$slabReclaimableKb();
            this.swapUsedKb = Memory.$default$swapUsedKb();
        }

        @Generated
        public static class MemoryBuilder {
            @Generated
            private RawDataLong totalKb;
            @Generated
            private boolean availableKb$set;
            @Generated
            private RawDataLong availableKb$value;
            @Generated
            private boolean freeKb$set;
            @Generated
            private RawDataLong freeKb$value;
            @Generated
            private boolean usedKb$set;
            @Generated
            private RawDataLong usedKb$value;
            @Generated
            private boolean slabReclaimableKb$set;
            @Generated
            private RawDataLong slabReclaimableKb$value;
            @Generated
            private RawDataLong swapTotalKb;
            @Generated
            private RawDataLong swapFreeKb;
            @Generated
            private boolean swapUsedKb$set;
            @Generated
            private RawDataLong swapUsedKb$value;

            @Generated
            MemoryBuilder() {
            }

            @Generated
            public MemoryBuilder totalKb(RawDataLong totalKb) {
                this.totalKb = totalKb;
                return this;
            }

            @Generated
            public MemoryBuilder availableKb(RawDataLong availableKb) {
                this.availableKb$value = availableKb;
                this.availableKb$set = true;
                return this;
            }

            @Generated
            public MemoryBuilder freeKb(RawDataLong freeKb) {
                this.freeKb$value = freeKb;
                this.freeKb$set = true;
                return this;
            }

            @Generated
            public MemoryBuilder usedKb(RawDataLong usedKb) {
                this.usedKb$value = usedKb;
                this.usedKb$set = true;
                return this;
            }

            @Generated
            public MemoryBuilder slabReclaimableKb(RawDataLong slabReclaimableKb) {
                this.slabReclaimableKb$value = slabReclaimableKb;
                this.slabReclaimableKb$set = true;
                return this;
            }

            @Generated
            public MemoryBuilder swapTotalKb(RawDataLong swapTotalKb) {
                this.swapTotalKb = swapTotalKb;
                return this;
            }

            @Generated
            public MemoryBuilder swapFreeKb(RawDataLong swapFreeKb) {
                this.swapFreeKb = swapFreeKb;
                return this;
            }

            @Generated
            public MemoryBuilder swapUsedKb(RawDataLong swapUsedKb) {
                this.swapUsedKb$value = swapUsedKb;
                this.swapUsedKb$set = true;
                return this;
            }

            @Generated
            public Memory build() {
                RawDataLong availableKb$value = this.availableKb$value;
                if (!this.availableKb$set) {
                    availableKb$value = Memory.$default$availableKb();
                }
                RawDataLong freeKb$value = this.freeKb$value;
                if (!this.freeKb$set) {
                    freeKb$value = Memory.$default$freeKb();
                }
                RawDataLong usedKb$value = this.usedKb$value;
                if (!this.usedKb$set) {
                    usedKb$value = Memory.$default$usedKb();
                }
                RawDataLong slabReclaimableKb$value = this.slabReclaimableKb$value;
                if (!this.slabReclaimableKb$set) {
                    slabReclaimableKb$value = Memory.$default$slabReclaimableKb();
                }
                RawDataLong swapUsedKb$value = this.swapUsedKb$value;
                if (!this.swapUsedKb$set) {
                    swapUsedKb$value = Memory.$default$swapUsedKb();
                }
                return new Memory(this.totalKb, availableKb$value, freeKb$value, usedKb$value, slabReclaimableKb$value, this.swapTotalKb, this.swapFreeKb, swapUsedKb$value);
            }

            @Generated
            public String toString() {
                return "NewLinuxRawData.Memory.MemoryBuilder(totalKb=" + String.valueOf(this.totalKb) + ", availableKb$value=" + String.valueOf(this.availableKb$value) + ", freeKb$value=" + String.valueOf(this.freeKb$value) + ", usedKb$value=" + String.valueOf(this.usedKb$value) + ", slabReclaimableKb$value=" + String.valueOf(this.slabReclaimableKb$value) + ", swapTotalKb=" + String.valueOf(this.swapTotalKb) + ", swapFreeKb=" + String.valueOf(this.swapFreeKb) + ", swapUsedKb$value=" + String.valueOf(this.swapUsedKb$value) + ")";
            }
        }
    }

    static class OperatingSystem {
        private RawDataString name;
        private RawDataString release;
        private RawDataString architecture;
        private RawDataString bios;

        @Generated
        public static OperatingSystemBuilder builder() {
            return new OperatingSystemBuilder();
        }

        @Generated
        public RawDataString getName() {
            return this.name;
        }

        @Generated
        public RawDataString getRelease() {
            return this.release;
        }

        @Generated
        public RawDataString getArchitecture() {
            return this.architecture;
        }

        @Generated
        public RawDataString getBios() {
            return this.bios;
        }

        @Generated
        public void setName(RawDataString name) {
            this.name = name;
        }

        @Generated
        public void setRelease(RawDataString release) {
            this.release = release;
        }

        @Generated
        public void setArchitecture(RawDataString architecture) {
            this.architecture = architecture;
        }

        @Generated
        public void setBios(RawDataString bios) {
            this.bios = bios;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OperatingSystem)) {
                return false;
            }
            OperatingSystem other = (OperatingSystem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RawDataString this$name = this.getName();
            RawDataString other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            RawDataString this$release = this.getRelease();
            RawDataString other$release = other.getRelease();
            if (this$release == null ? other$release != null : !this$release.equals(other$release)) {
                return false;
            }
            RawDataString this$architecture = this.getArchitecture();
            RawDataString other$architecture = other.getArchitecture();
            if (this$architecture == null ? other$architecture != null : !this$architecture.equals(other$architecture)) {
                return false;
            }
            RawDataString this$bios = this.getBios();
            RawDataString other$bios = other.getBios();
            return !(this$bios == null ? other$bios != null : !this$bios.equals(other$bios));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OperatingSystem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RawDataString $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            RawDataString $release = this.getRelease();
            result = result * 59 + ($release == null ? 43 : $release.hashCode());
            RawDataString $architecture = this.getArchitecture();
            result = result * 59 + ($architecture == null ? 43 : $architecture.hashCode());
            RawDataString $bios = this.getBios();
            result = result * 59 + ($bios == null ? 43 : $bios.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NewLinuxRawData.OperatingSystem(name=" + String.valueOf(this.getName()) + ", release=" + String.valueOf(this.getRelease()) + ", architecture=" + String.valueOf(this.getArchitecture()) + ", bios=" + String.valueOf(this.getBios()) + ")";
        }

        @Generated
        public OperatingSystem(RawDataString name, RawDataString release, RawDataString architecture, RawDataString bios) {
            this.name = name;
            this.release = release;
            this.architecture = architecture;
            this.bios = bios;
        }

        @Generated
        protected OperatingSystem() {
        }

        @Generated
        public static class OperatingSystemBuilder {
            @Generated
            private RawDataString name;
            @Generated
            private RawDataString release;
            @Generated
            private RawDataString architecture;
            @Generated
            private RawDataString bios;

            @Generated
            OperatingSystemBuilder() {
            }

            @Generated
            public OperatingSystemBuilder name(RawDataString name) {
                this.name = name;
                return this;
            }

            @Generated
            public OperatingSystemBuilder release(RawDataString release) {
                this.release = release;
                return this;
            }

            @Generated
            public OperatingSystemBuilder architecture(RawDataString architecture) {
                this.architecture = architecture;
                return this;
            }

            @Generated
            public OperatingSystemBuilder bios(RawDataString bios) {
                this.bios = bios;
                return this;
            }

            @Generated
            public OperatingSystem build() {
                return new OperatingSystem(this.name, this.release, this.architecture, this.bios);
            }

            @Generated
            public String toString() {
                return "NewLinuxRawData.OperatingSystem.OperatingSystemBuilder(name=" + String.valueOf(this.name) + ", release=" + String.valueOf(this.release) + ", architecture=" + String.valueOf(this.architecture) + ", bios=" + String.valueOf(this.bios) + ")";
            }
        }
    }

    static class Process {
        @NonNull
        private RawDataLong pid;
        private RawDataString name;
        @NonNull
        private RawDataString memoryPercent;
        @NonNull
        private RawDataString cpuTime;
        @NonNull
        private RawDataString effectiveGroup;
        private RawDataString elapsedTime;
        @NonNull
        private RawDataString effectiveUser;
        @NonNull
        private RawDataString nice;
        private RawDataLong majorFault;
        private RawDataLong minorFault;
        private RawDataLong threadCount;
        private RawDataLong groupId;
        private RawDataLong parentId;
        private RawDataLong memoryUsedKb;
        @NonNull
        private RawDataString state;
        @NonNull
        private RawDataString realUser;
        @NonNull
        private RawDataString realGroup;
        private RawDataLong virtualMemSizeKb;
        @NonNull
        private RawDataString cpuPercent;
        private RawDataString commandLine;
        @NonNull
        private RawDataString gpuUtilization;
        @NonNull
        private RawDataString gpuMemoryUtilization;

        @Generated
        private static RawDataLong $default$pid() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataString $default$name() {
            return RawDataConstants.ABSENT_STRING;
        }

        @Generated
        private static RawDataString $default$memoryPercent() {
            return RawDataConstants.ABSENT_STRING;
        }

        @Generated
        private static RawDataString $default$cpuTime() {
            return RawDataConstants.ABSENT_STRING;
        }

        @Generated
        private static RawDataString $default$effectiveGroup() {
            return RawDataConstants.ABSENT_STRING;
        }

        @Generated
        private static RawDataString $default$elapsedTime() {
            return RawDataConstants.ABSENT_STRING;
        }

        @Generated
        private static RawDataString $default$effectiveUser() {
            return RawDataConstants.ABSENT_STRING;
        }

        @Generated
        private static RawDataString $default$nice() {
            return RawDataConstants.ABSENT_STRING;
        }

        @Generated
        private static RawDataLong $default$majorFault() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$minorFault() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$threadCount() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$groupId() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$parentId() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$memoryUsedKb() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataString $default$state() {
            return RawDataConstants.ABSENT_STRING;
        }

        @Generated
        private static RawDataString $default$realUser() {
            return RawDataConstants.ABSENT_STRING;
        }

        @Generated
        private static RawDataString $default$realGroup() {
            return RawDataConstants.ABSENT_STRING;
        }

        @Generated
        private static RawDataLong $default$virtualMemSizeKb() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataString $default$cpuPercent() {
            return RawDataConstants.ABSENT_STRING;
        }

        @Generated
        private static RawDataString $default$commandLine() {
            return RawDataConstants.ABSENT_STRING;
        }

        @Generated
        private static RawDataString $default$gpuUtilization() {
            return RawDataConstants.ABSENT_STRING;
        }

        @Generated
        private static RawDataString $default$gpuMemoryUtilization() {
            return RawDataConstants.ABSENT_STRING;
        }

        @Generated
        public static ProcessBuilder builder() {
            return new ProcessBuilder();
        }

        @NonNull
        @Generated
        public RawDataLong getPid() {
            return this.pid;
        }

        @Generated
        public RawDataString getName() {
            return this.name;
        }

        @NonNull
        @Generated
        public RawDataString getMemoryPercent() {
            return this.memoryPercent;
        }

        @NonNull
        @Generated
        public RawDataString getCpuTime() {
            return this.cpuTime;
        }

        @NonNull
        @Generated
        public RawDataString getEffectiveGroup() {
            return this.effectiveGroup;
        }

        @Generated
        public RawDataString getElapsedTime() {
            return this.elapsedTime;
        }

        @NonNull
        @Generated
        public RawDataString getEffectiveUser() {
            return this.effectiveUser;
        }

        @NonNull
        @Generated
        public RawDataString getNice() {
            return this.nice;
        }

        @Generated
        public RawDataLong getMajorFault() {
            return this.majorFault;
        }

        @Generated
        public RawDataLong getMinorFault() {
            return this.minorFault;
        }

        @Generated
        public RawDataLong getThreadCount() {
            return this.threadCount;
        }

        @Generated
        public RawDataLong getGroupId() {
            return this.groupId;
        }

        @Generated
        public RawDataLong getParentId() {
            return this.parentId;
        }

        @Generated
        public RawDataLong getMemoryUsedKb() {
            return this.memoryUsedKb;
        }

        @NonNull
        @Generated
        public RawDataString getState() {
            return this.state;
        }

        @NonNull
        @Generated
        public RawDataString getRealUser() {
            return this.realUser;
        }

        @NonNull
        @Generated
        public RawDataString getRealGroup() {
            return this.realGroup;
        }

        @Generated
        public RawDataLong getVirtualMemSizeKb() {
            return this.virtualMemSizeKb;
        }

        @NonNull
        @Generated
        public RawDataString getCpuPercent() {
            return this.cpuPercent;
        }

        @Generated
        public RawDataString getCommandLine() {
            return this.commandLine;
        }

        @NonNull
        @Generated
        public RawDataString getGpuUtilization() {
            return this.gpuUtilization;
        }

        @NonNull
        @Generated
        public RawDataString getGpuMemoryUtilization() {
            return this.gpuMemoryUtilization;
        }

        @Generated
        public void setPid(@NonNull RawDataLong pid) {
            if (pid == null) {
                throw new NullPointerException("pid is marked non-null but is null");
            }
            this.pid = pid;
        }

        @Generated
        public void setName(RawDataString name) {
            this.name = name;
        }

        @Generated
        public void setMemoryPercent(@NonNull RawDataString memoryPercent) {
            if (memoryPercent == null) {
                throw new NullPointerException("memoryPercent is marked non-null but is null");
            }
            this.memoryPercent = memoryPercent;
        }

        @Generated
        public void setCpuTime(@NonNull RawDataString cpuTime) {
            if (cpuTime == null) {
                throw new NullPointerException("cpuTime is marked non-null but is null");
            }
            this.cpuTime = cpuTime;
        }

        @Generated
        public void setEffectiveGroup(@NonNull RawDataString effectiveGroup) {
            if (effectiveGroup == null) {
                throw new NullPointerException("effectiveGroup is marked non-null but is null");
            }
            this.effectiveGroup = effectiveGroup;
        }

        @Generated
        public void setElapsedTime(RawDataString elapsedTime) {
            this.elapsedTime = elapsedTime;
        }

        @Generated
        public void setEffectiveUser(@NonNull RawDataString effectiveUser) {
            if (effectiveUser == null) {
                throw new NullPointerException("effectiveUser is marked non-null but is null");
            }
            this.effectiveUser = effectiveUser;
        }

        @Generated
        public void setNice(@NonNull RawDataString nice) {
            if (nice == null) {
                throw new NullPointerException("nice is marked non-null but is null");
            }
            this.nice = nice;
        }

        @Generated
        public void setMajorFault(RawDataLong majorFault) {
            this.majorFault = majorFault;
        }

        @Generated
        public void setMinorFault(RawDataLong minorFault) {
            this.minorFault = minorFault;
        }

        @Generated
        public void setThreadCount(RawDataLong threadCount) {
            this.threadCount = threadCount;
        }

        @Generated
        public void setGroupId(RawDataLong groupId) {
            this.groupId = groupId;
        }

        @Generated
        public void setParentId(RawDataLong parentId) {
            this.parentId = parentId;
        }

        @Generated
        public void setMemoryUsedKb(RawDataLong memoryUsedKb) {
            this.memoryUsedKb = memoryUsedKb;
        }

        @Generated
        public void setState(@NonNull RawDataString state) {
            if (state == null) {
                throw new NullPointerException("state is marked non-null but is null");
            }
            this.state = state;
        }

        @Generated
        public void setRealUser(@NonNull RawDataString realUser) {
            if (realUser == null) {
                throw new NullPointerException("realUser is marked non-null but is null");
            }
            this.realUser = realUser;
        }

        @Generated
        public void setRealGroup(@NonNull RawDataString realGroup) {
            if (realGroup == null) {
                throw new NullPointerException("realGroup is marked non-null but is null");
            }
            this.realGroup = realGroup;
        }

        @Generated
        public void setVirtualMemSizeKb(RawDataLong virtualMemSizeKb) {
            this.virtualMemSizeKb = virtualMemSizeKb;
        }

        @Generated
        public void setCpuPercent(@NonNull RawDataString cpuPercent) {
            if (cpuPercent == null) {
                throw new NullPointerException("cpuPercent is marked non-null but is null");
            }
            this.cpuPercent = cpuPercent;
        }

        @Generated
        public void setCommandLine(RawDataString commandLine) {
            this.commandLine = commandLine;
        }

        @Generated
        public void setGpuUtilization(@NonNull RawDataString gpuUtilization) {
            if (gpuUtilization == null) {
                throw new NullPointerException("gpuUtilization is marked non-null but is null");
            }
            this.gpuUtilization = gpuUtilization;
        }

        @Generated
        public void setGpuMemoryUtilization(@NonNull RawDataString gpuMemoryUtilization) {
            if (gpuMemoryUtilization == null) {
                throw new NullPointerException("gpuMemoryUtilization is marked non-null but is null");
            }
            this.gpuMemoryUtilization = gpuMemoryUtilization;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Process)) {
                return false;
            }
            Process other = (Process)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RawDataLong this$pid = this.getPid();
            RawDataLong other$pid = other.getPid();
            if (this$pid == null ? other$pid != null : !this$pid.equals(other$pid)) {
                return false;
            }
            RawDataString this$name = this.getName();
            RawDataString other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            RawDataString this$memoryPercent = this.getMemoryPercent();
            RawDataString other$memoryPercent = other.getMemoryPercent();
            if (this$memoryPercent == null ? other$memoryPercent != null : !this$memoryPercent.equals(other$memoryPercent)) {
                return false;
            }
            RawDataString this$cpuTime = this.getCpuTime();
            RawDataString other$cpuTime = other.getCpuTime();
            if (this$cpuTime == null ? other$cpuTime != null : !this$cpuTime.equals(other$cpuTime)) {
                return false;
            }
            RawDataString this$effectiveGroup = this.getEffectiveGroup();
            RawDataString other$effectiveGroup = other.getEffectiveGroup();
            if (this$effectiveGroup == null ? other$effectiveGroup != null : !this$effectiveGroup.equals(other$effectiveGroup)) {
                return false;
            }
            RawDataString this$elapsedTime = this.getElapsedTime();
            RawDataString other$elapsedTime = other.getElapsedTime();
            if (this$elapsedTime == null ? other$elapsedTime != null : !this$elapsedTime.equals(other$elapsedTime)) {
                return false;
            }
            RawDataString this$effectiveUser = this.getEffectiveUser();
            RawDataString other$effectiveUser = other.getEffectiveUser();
            if (this$effectiveUser == null ? other$effectiveUser != null : !this$effectiveUser.equals(other$effectiveUser)) {
                return false;
            }
            RawDataString this$nice = this.getNice();
            RawDataString other$nice = other.getNice();
            if (this$nice == null ? other$nice != null : !this$nice.equals(other$nice)) {
                return false;
            }
            RawDataLong this$majorFault = this.getMajorFault();
            RawDataLong other$majorFault = other.getMajorFault();
            if (this$majorFault == null ? other$majorFault != null : !this$majorFault.equals(other$majorFault)) {
                return false;
            }
            RawDataLong this$minorFault = this.getMinorFault();
            RawDataLong other$minorFault = other.getMinorFault();
            if (this$minorFault == null ? other$minorFault != null : !this$minorFault.equals(other$minorFault)) {
                return false;
            }
            RawDataLong this$threadCount = this.getThreadCount();
            RawDataLong other$threadCount = other.getThreadCount();
            if (this$threadCount == null ? other$threadCount != null : !this$threadCount.equals(other$threadCount)) {
                return false;
            }
            RawDataLong this$groupId = this.getGroupId();
            RawDataLong other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            RawDataLong this$parentId = this.getParentId();
            RawDataLong other$parentId = other.getParentId();
            if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
                return false;
            }
            RawDataLong this$memoryUsedKb = this.getMemoryUsedKb();
            RawDataLong other$memoryUsedKb = other.getMemoryUsedKb();
            if (this$memoryUsedKb == null ? other$memoryUsedKb != null : !this$memoryUsedKb.equals(other$memoryUsedKb)) {
                return false;
            }
            RawDataString this$state = this.getState();
            RawDataString other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            RawDataString this$realUser = this.getRealUser();
            RawDataString other$realUser = other.getRealUser();
            if (this$realUser == null ? other$realUser != null : !this$realUser.equals(other$realUser)) {
                return false;
            }
            RawDataString this$realGroup = this.getRealGroup();
            RawDataString other$realGroup = other.getRealGroup();
            if (this$realGroup == null ? other$realGroup != null : !this$realGroup.equals(other$realGroup)) {
                return false;
            }
            RawDataLong this$virtualMemSizeKb = this.getVirtualMemSizeKb();
            RawDataLong other$virtualMemSizeKb = other.getVirtualMemSizeKb();
            if (this$virtualMemSizeKb == null ? other$virtualMemSizeKb != null : !this$virtualMemSizeKb.equals(other$virtualMemSizeKb)) {
                return false;
            }
            RawDataString this$cpuPercent = this.getCpuPercent();
            RawDataString other$cpuPercent = other.getCpuPercent();
            if (this$cpuPercent == null ? other$cpuPercent != null : !this$cpuPercent.equals(other$cpuPercent)) {
                return false;
            }
            RawDataString this$commandLine = this.getCommandLine();
            RawDataString other$commandLine = other.getCommandLine();
            if (this$commandLine == null ? other$commandLine != null : !this$commandLine.equals(other$commandLine)) {
                return false;
            }
            RawDataString this$gpuUtilization = this.getGpuUtilization();
            RawDataString other$gpuUtilization = other.getGpuUtilization();
            if (this$gpuUtilization == null ? other$gpuUtilization != null : !this$gpuUtilization.equals(other$gpuUtilization)) {
                return false;
            }
            RawDataString this$gpuMemoryUtilization = this.getGpuMemoryUtilization();
            RawDataString other$gpuMemoryUtilization = other.getGpuMemoryUtilization();
            return !(this$gpuMemoryUtilization == null ? other$gpuMemoryUtilization != null : !this$gpuMemoryUtilization.equals(other$gpuMemoryUtilization));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Process;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RawDataLong $pid = this.getPid();
            result = result * 59 + ($pid == null ? 43 : $pid.hashCode());
            RawDataString $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            RawDataString $memoryPercent = this.getMemoryPercent();
            result = result * 59 + ($memoryPercent == null ? 43 : $memoryPercent.hashCode());
            RawDataString $cpuTime = this.getCpuTime();
            result = result * 59 + ($cpuTime == null ? 43 : $cpuTime.hashCode());
            RawDataString $effectiveGroup = this.getEffectiveGroup();
            result = result * 59 + ($effectiveGroup == null ? 43 : $effectiveGroup.hashCode());
            RawDataString $elapsedTime = this.getElapsedTime();
            result = result * 59 + ($elapsedTime == null ? 43 : $elapsedTime.hashCode());
            RawDataString $effectiveUser = this.getEffectiveUser();
            result = result * 59 + ($effectiveUser == null ? 43 : $effectiveUser.hashCode());
            RawDataString $nice = this.getNice();
            result = result * 59 + ($nice == null ? 43 : $nice.hashCode());
            RawDataLong $majorFault = this.getMajorFault();
            result = result * 59 + ($majorFault == null ? 43 : $majorFault.hashCode());
            RawDataLong $minorFault = this.getMinorFault();
            result = result * 59 + ($minorFault == null ? 43 : $minorFault.hashCode());
            RawDataLong $threadCount = this.getThreadCount();
            result = result * 59 + ($threadCount == null ? 43 : $threadCount.hashCode());
            RawDataLong $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            RawDataLong $parentId = this.getParentId();
            result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
            RawDataLong $memoryUsedKb = this.getMemoryUsedKb();
            result = result * 59 + ($memoryUsedKb == null ? 43 : $memoryUsedKb.hashCode());
            RawDataString $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            RawDataString $realUser = this.getRealUser();
            result = result * 59 + ($realUser == null ? 43 : $realUser.hashCode());
            RawDataString $realGroup = this.getRealGroup();
            result = result * 59 + ($realGroup == null ? 43 : $realGroup.hashCode());
            RawDataLong $virtualMemSizeKb = this.getVirtualMemSizeKb();
            result = result * 59 + ($virtualMemSizeKb == null ? 43 : $virtualMemSizeKb.hashCode());
            RawDataString $cpuPercent = this.getCpuPercent();
            result = result * 59 + ($cpuPercent == null ? 43 : $cpuPercent.hashCode());
            RawDataString $commandLine = this.getCommandLine();
            result = result * 59 + ($commandLine == null ? 43 : $commandLine.hashCode());
            RawDataString $gpuUtilization = this.getGpuUtilization();
            result = result * 59 + ($gpuUtilization == null ? 43 : $gpuUtilization.hashCode());
            RawDataString $gpuMemoryUtilization = this.getGpuMemoryUtilization();
            result = result * 59 + ($gpuMemoryUtilization == null ? 43 : $gpuMemoryUtilization.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NewLinuxRawData.Process(pid=" + String.valueOf(this.getPid()) + ", name=" + String.valueOf(this.getName()) + ", memoryPercent=" + String.valueOf(this.getMemoryPercent()) + ", cpuTime=" + String.valueOf(this.getCpuTime()) + ", effectiveGroup=" + String.valueOf(this.getEffectiveGroup()) + ", elapsedTime=" + String.valueOf(this.getElapsedTime()) + ", effectiveUser=" + String.valueOf(this.getEffectiveUser()) + ", nice=" + String.valueOf(this.getNice()) + ", majorFault=" + String.valueOf(this.getMajorFault()) + ", minorFault=" + String.valueOf(this.getMinorFault()) + ", threadCount=" + String.valueOf(this.getThreadCount()) + ", groupId=" + String.valueOf(this.getGroupId()) + ", parentId=" + String.valueOf(this.getParentId()) + ", memoryUsedKb=" + String.valueOf(this.getMemoryUsedKb()) + ", state=" + String.valueOf(this.getState()) + ", realUser=" + String.valueOf(this.getRealUser()) + ", realGroup=" + String.valueOf(this.getRealGroup()) + ", virtualMemSizeKb=" + String.valueOf(this.getVirtualMemSizeKb()) + ", cpuPercent=" + String.valueOf(this.getCpuPercent()) + ", commandLine=" + String.valueOf(this.getCommandLine()) + ", gpuUtilization=" + String.valueOf(this.getGpuUtilization()) + ", gpuMemoryUtilization=" + String.valueOf(this.getGpuMemoryUtilization()) + ")";
        }

        @Generated
        public Process(@NonNull RawDataLong pid, RawDataString name, @NonNull RawDataString memoryPercent, @NonNull RawDataString cpuTime, @NonNull RawDataString effectiveGroup, RawDataString elapsedTime, @NonNull RawDataString effectiveUser, @NonNull RawDataString nice, RawDataLong majorFault, RawDataLong minorFault, RawDataLong threadCount, RawDataLong groupId, RawDataLong parentId, RawDataLong memoryUsedKb, @NonNull RawDataString state, @NonNull RawDataString realUser, @NonNull RawDataString realGroup, RawDataLong virtualMemSizeKb, @NonNull RawDataString cpuPercent, RawDataString commandLine, @NonNull RawDataString gpuUtilization, @NonNull RawDataString gpuMemoryUtilization) {
            if (pid == null) {
                throw new NullPointerException("pid is marked non-null but is null");
            }
            if (memoryPercent == null) {
                throw new NullPointerException("memoryPercent is marked non-null but is null");
            }
            if (cpuTime == null) {
                throw new NullPointerException("cpuTime is marked non-null but is null");
            }
            if (effectiveGroup == null) {
                throw new NullPointerException("effectiveGroup is marked non-null but is null");
            }
            if (effectiveUser == null) {
                throw new NullPointerException("effectiveUser is marked non-null but is null");
            }
            if (nice == null) {
                throw new NullPointerException("nice is marked non-null but is null");
            }
            if (state == null) {
                throw new NullPointerException("state is marked non-null but is null");
            }
            if (realUser == null) {
                throw new NullPointerException("realUser is marked non-null but is null");
            }
            if (realGroup == null) {
                throw new NullPointerException("realGroup is marked non-null but is null");
            }
            if (cpuPercent == null) {
                throw new NullPointerException("cpuPercent is marked non-null but is null");
            }
            if (gpuUtilization == null) {
                throw new NullPointerException("gpuUtilization is marked non-null but is null");
            }
            if (gpuMemoryUtilization == null) {
                throw new NullPointerException("gpuMemoryUtilization is marked non-null but is null");
            }
            this.pid = pid;
            this.name = name;
            this.memoryPercent = memoryPercent;
            this.cpuTime = cpuTime;
            this.effectiveGroup = effectiveGroup;
            this.elapsedTime = elapsedTime;
            this.effectiveUser = effectiveUser;
            this.nice = nice;
            this.majorFault = majorFault;
            this.minorFault = minorFault;
            this.threadCount = threadCount;
            this.groupId = groupId;
            this.parentId = parentId;
            this.memoryUsedKb = memoryUsedKb;
            this.state = state;
            this.realUser = realUser;
            this.realGroup = realGroup;
            this.virtualMemSizeKb = virtualMemSizeKb;
            this.cpuPercent = cpuPercent;
            this.commandLine = commandLine;
            this.gpuUtilization = gpuUtilization;
            this.gpuMemoryUtilization = gpuMemoryUtilization;
        }

        @Generated
        protected Process() {
            this.pid = Process.$default$pid();
            this.name = Process.$default$name();
            this.memoryPercent = Process.$default$memoryPercent();
            this.cpuTime = Process.$default$cpuTime();
            this.effectiveGroup = Process.$default$effectiveGroup();
            this.elapsedTime = Process.$default$elapsedTime();
            this.effectiveUser = Process.$default$effectiveUser();
            this.nice = Process.$default$nice();
            this.majorFault = Process.$default$majorFault();
            this.minorFault = Process.$default$minorFault();
            this.threadCount = Process.$default$threadCount();
            this.groupId = Process.$default$groupId();
            this.parentId = Process.$default$parentId();
            this.memoryUsedKb = Process.$default$memoryUsedKb();
            this.state = Process.$default$state();
            this.realUser = Process.$default$realUser();
            this.realGroup = Process.$default$realGroup();
            this.virtualMemSizeKb = Process.$default$virtualMemSizeKb();
            this.cpuPercent = Process.$default$cpuPercent();
            this.commandLine = Process.$default$commandLine();
            this.gpuUtilization = Process.$default$gpuUtilization();
            this.gpuMemoryUtilization = Process.$default$gpuMemoryUtilization();
        }

        public static class ProcessBuilder {
            @Generated
            private boolean pid$set;
            @Generated
            private RawDataLong pid$value;
            @Generated
            private boolean name$set;
            @Generated
            private RawDataString name$value;
            @Generated
            private boolean memoryPercent$set;
            @Generated
            private RawDataString memoryPercent$value;
            @Generated
            private boolean cpuTime$set;
            @Generated
            private RawDataString cpuTime$value;
            @Generated
            private boolean effectiveGroup$set;
            @Generated
            private RawDataString effectiveGroup$value;
            @Generated
            private boolean elapsedTime$set;
            @Generated
            private RawDataString elapsedTime$value;
            @Generated
            private boolean effectiveUser$set;
            @Generated
            private RawDataString effectiveUser$value;
            @Generated
            private boolean nice$set;
            @Generated
            private RawDataString nice$value;
            @Generated
            private boolean majorFault$set;
            @Generated
            private RawDataLong majorFault$value;
            @Generated
            private boolean minorFault$set;
            @Generated
            private RawDataLong minorFault$value;
            @Generated
            private boolean threadCount$set;
            @Generated
            private RawDataLong threadCount$value;
            @Generated
            private boolean groupId$set;
            @Generated
            private RawDataLong groupId$value;
            @Generated
            private boolean parentId$set;
            @Generated
            private RawDataLong parentId$value;
            @Generated
            private boolean memoryUsedKb$set;
            @Generated
            private RawDataLong memoryUsedKb$value;
            @Generated
            private boolean state$set;
            @Generated
            private RawDataString state$value;
            @Generated
            private boolean realUser$set;
            @Generated
            private RawDataString realUser$value;
            @Generated
            private boolean realGroup$set;
            @Generated
            private RawDataString realGroup$value;
            @Generated
            private boolean virtualMemSizeKb$set;
            @Generated
            private RawDataLong virtualMemSizeKb$value;
            @Generated
            private boolean cpuPercent$set;
            @Generated
            private RawDataString cpuPercent$value;
            @Generated
            private boolean commandLine$set;
            @Generated
            private RawDataString commandLine$value;
            @Generated
            private boolean gpuUtilization$set;
            @Generated
            private RawDataString gpuUtilization$value;
            @Generated
            private boolean gpuMemoryUtilization$set;
            @Generated
            private RawDataString gpuMemoryUtilization$value;
            private RawDataLong pid = RawDataConstants.ZERO_LONG;
            private RawDataString name = RawDataConstants.ABSENT_STRING;
            private RawDataString memoryPercent = RawDataConstants.ABSENT_STRING;
            private RawDataString cpuTime = RawDataConstants.ABSENT_STRING;
            private RawDataString effectiveGroup = RawDataConstants.ABSENT_STRING;
            private RawDataString elapsedTime = RawDataConstants.ABSENT_STRING;
            private RawDataString effectiveUser = RawDataConstants.ABSENT_STRING;
            private RawDataString nice = RawDataConstants.ABSENT_STRING;
            private RawDataLong majorFault = RawDataConstants.ZERO_LONG;
            private RawDataLong minorFault = RawDataConstants.ZERO_LONG;
            private RawDataLong threadCount = RawDataConstants.ZERO_LONG;
            private RawDataLong groupId = RawDataConstants.ZERO_LONG;
            private RawDataLong parentId = RawDataConstants.ZERO_LONG;
            private RawDataLong memoryUsedKb = RawDataConstants.ZERO_LONG;
            private RawDataString state = RawDataConstants.ABSENT_STRING;
            private RawDataString realUser = RawDataConstants.ABSENT_STRING;
            private RawDataString realGroup = RawDataConstants.ABSENT_STRING;
            private RawDataLong virtualMemSizeKb = RawDataConstants.ZERO_LONG;
            private RawDataString cpuPercent = RawDataConstants.ABSENT_STRING;
            private RawDataString commandLine = RawDataConstants.ABSENT_STRING;
            private RawDataString gpuUtilization = RawDataConstants.ABSENT_STRING;
            private RawDataString gpuMemoryUtilization = RawDataConstants.ABSENT_STRING;

            @Generated
            ProcessBuilder() {
            }

            @Generated
            public ProcessBuilder pid(@NonNull RawDataLong pid) {
                if (pid == null) {
                    throw new NullPointerException("pid is marked non-null but is null");
                }
                this.pid$value = pid;
                this.pid$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder name(RawDataString name) {
                this.name$value = name;
                this.name$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder memoryPercent(@NonNull RawDataString memoryPercent) {
                if (memoryPercent == null) {
                    throw new NullPointerException("memoryPercent is marked non-null but is null");
                }
                this.memoryPercent$value = memoryPercent;
                this.memoryPercent$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder cpuTime(@NonNull RawDataString cpuTime) {
                if (cpuTime == null) {
                    throw new NullPointerException("cpuTime is marked non-null but is null");
                }
                this.cpuTime$value = cpuTime;
                this.cpuTime$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder effectiveGroup(@NonNull RawDataString effectiveGroup) {
                if (effectiveGroup == null) {
                    throw new NullPointerException("effectiveGroup is marked non-null but is null");
                }
                this.effectiveGroup$value = effectiveGroup;
                this.effectiveGroup$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder elapsedTime(RawDataString elapsedTime) {
                this.elapsedTime$value = elapsedTime;
                this.elapsedTime$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder effectiveUser(@NonNull RawDataString effectiveUser) {
                if (effectiveUser == null) {
                    throw new NullPointerException("effectiveUser is marked non-null but is null");
                }
                this.effectiveUser$value = effectiveUser;
                this.effectiveUser$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder nice(@NonNull RawDataString nice) {
                if (nice == null) {
                    throw new NullPointerException("nice is marked non-null but is null");
                }
                this.nice$value = nice;
                this.nice$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder majorFault(RawDataLong majorFault) {
                this.majorFault$value = majorFault;
                this.majorFault$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder minorFault(RawDataLong minorFault) {
                this.minorFault$value = minorFault;
                this.minorFault$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder threadCount(RawDataLong threadCount) {
                this.threadCount$value = threadCount;
                this.threadCount$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder groupId(RawDataLong groupId) {
                this.groupId$value = groupId;
                this.groupId$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder parentId(RawDataLong parentId) {
                this.parentId$value = parentId;
                this.parentId$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder memoryUsedKb(RawDataLong memoryUsedKb) {
                this.memoryUsedKb$value = memoryUsedKb;
                this.memoryUsedKb$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder state(@NonNull RawDataString state) {
                if (state == null) {
                    throw new NullPointerException("state is marked non-null but is null");
                }
                this.state$value = state;
                this.state$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder realUser(@NonNull RawDataString realUser) {
                if (realUser == null) {
                    throw new NullPointerException("realUser is marked non-null but is null");
                }
                this.realUser$value = realUser;
                this.realUser$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder realGroup(@NonNull RawDataString realGroup) {
                if (realGroup == null) {
                    throw new NullPointerException("realGroup is marked non-null but is null");
                }
                this.realGroup$value = realGroup;
                this.realGroup$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder virtualMemSizeKb(RawDataLong virtualMemSizeKb) {
                this.virtualMemSizeKb$value = virtualMemSizeKb;
                this.virtualMemSizeKb$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder cpuPercent(@NonNull RawDataString cpuPercent) {
                if (cpuPercent == null) {
                    throw new NullPointerException("cpuPercent is marked non-null but is null");
                }
                this.cpuPercent$value = cpuPercent;
                this.cpuPercent$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder commandLine(RawDataString commandLine) {
                this.commandLine$value = commandLine;
                this.commandLine$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder gpuUtilization(@NonNull RawDataString gpuUtilization) {
                if (gpuUtilization == null) {
                    throw new NullPointerException("gpuUtilization is marked non-null but is null");
                }
                this.gpuUtilization$value = gpuUtilization;
                this.gpuUtilization$set = true;
                return this;
            }

            @Generated
            public ProcessBuilder gpuMemoryUtilization(@NonNull RawDataString gpuMemoryUtilization) {
                if (gpuMemoryUtilization == null) {
                    throw new NullPointerException("gpuMemoryUtilization is marked non-null but is null");
                }
                this.gpuMemoryUtilization$value = gpuMemoryUtilization;
                this.gpuMemoryUtilization$set = true;
                return this;
            }

            @Generated
            public Process build() {
                RawDataLong pid$value = this.pid$value;
                if (!this.pid$set) {
                    pid$value = Process.$default$pid();
                }
                RawDataString name$value = this.name$value;
                if (!this.name$set) {
                    name$value = Process.$default$name();
                }
                RawDataString memoryPercent$value = this.memoryPercent$value;
                if (!this.memoryPercent$set) {
                    memoryPercent$value = Process.$default$memoryPercent();
                }
                RawDataString cpuTime$value = this.cpuTime$value;
                if (!this.cpuTime$set) {
                    cpuTime$value = Process.$default$cpuTime();
                }
                RawDataString effectiveGroup$value = this.effectiveGroup$value;
                if (!this.effectiveGroup$set) {
                    effectiveGroup$value = Process.$default$effectiveGroup();
                }
                RawDataString elapsedTime$value = this.elapsedTime$value;
                if (!this.elapsedTime$set) {
                    elapsedTime$value = Process.$default$elapsedTime();
                }
                RawDataString effectiveUser$value = this.effectiveUser$value;
                if (!this.effectiveUser$set) {
                    effectiveUser$value = Process.$default$effectiveUser();
                }
                RawDataString nice$value = this.nice$value;
                if (!this.nice$set) {
                    nice$value = Process.$default$nice();
                }
                RawDataLong majorFault$value = this.majorFault$value;
                if (!this.majorFault$set) {
                    majorFault$value = Process.$default$majorFault();
                }
                RawDataLong minorFault$value = this.minorFault$value;
                if (!this.minorFault$set) {
                    minorFault$value = Process.$default$minorFault();
                }
                RawDataLong threadCount$value = this.threadCount$value;
                if (!this.threadCount$set) {
                    threadCount$value = Process.$default$threadCount();
                }
                RawDataLong groupId$value = this.groupId$value;
                if (!this.groupId$set) {
                    groupId$value = Process.$default$groupId();
                }
                RawDataLong parentId$value = this.parentId$value;
                if (!this.parentId$set) {
                    parentId$value = Process.$default$parentId();
                }
                RawDataLong memoryUsedKb$value = this.memoryUsedKb$value;
                if (!this.memoryUsedKb$set) {
                    memoryUsedKb$value = Process.$default$memoryUsedKb();
                }
                RawDataString state$value = this.state$value;
                if (!this.state$set) {
                    state$value = Process.$default$state();
                }
                RawDataString realUser$value = this.realUser$value;
                if (!this.realUser$set) {
                    realUser$value = Process.$default$realUser();
                }
                RawDataString realGroup$value = this.realGroup$value;
                if (!this.realGroup$set) {
                    realGroup$value = Process.$default$realGroup();
                }
                RawDataLong virtualMemSizeKb$value = this.virtualMemSizeKb$value;
                if (!this.virtualMemSizeKb$set) {
                    virtualMemSizeKb$value = Process.$default$virtualMemSizeKb();
                }
                RawDataString cpuPercent$value = this.cpuPercent$value;
                if (!this.cpuPercent$set) {
                    cpuPercent$value = Process.$default$cpuPercent();
                }
                RawDataString commandLine$value = this.commandLine$value;
                if (!this.commandLine$set) {
                    commandLine$value = Process.$default$commandLine();
                }
                RawDataString gpuUtilization$value = this.gpuUtilization$value;
                if (!this.gpuUtilization$set) {
                    gpuUtilization$value = Process.$default$gpuUtilization();
                }
                RawDataString gpuMemoryUtilization$value = this.gpuMemoryUtilization$value;
                if (!this.gpuMemoryUtilization$set) {
                    gpuMemoryUtilization$value = Process.$default$gpuMemoryUtilization();
                }
                return new Process(pid$value, name$value, memoryPercent$value, cpuTime$value, effectiveGroup$value, elapsedTime$value, effectiveUser$value, nice$value, majorFault$value, minorFault$value, threadCount$value, groupId$value, parentId$value, memoryUsedKb$value, state$value, realUser$value, realGroup$value, virtualMemSizeKb$value, cpuPercent$value, commandLine$value, gpuUtilization$value, gpuMemoryUtilization$value);
            }

            @Generated
            public String toString() {
                return "NewLinuxRawData.Process.ProcessBuilder(pid$value=" + String.valueOf(this.pid$value) + ", name$value=" + String.valueOf(this.name$value) + ", memoryPercent$value=" + String.valueOf(this.memoryPercent$value) + ", cpuTime$value=" + String.valueOf(this.cpuTime$value) + ", effectiveGroup$value=" + String.valueOf(this.effectiveGroup$value) + ", elapsedTime$value=" + String.valueOf(this.elapsedTime$value) + ", effectiveUser$value=" + String.valueOf(this.effectiveUser$value) + ", nice$value=" + String.valueOf(this.nice$value) + ", majorFault$value=" + String.valueOf(this.majorFault$value) + ", minorFault$value=" + String.valueOf(this.minorFault$value) + ", threadCount$value=" + String.valueOf(this.threadCount$value) + ", groupId$value=" + String.valueOf(this.groupId$value) + ", parentId$value=" + String.valueOf(this.parentId$value) + ", memoryUsedKb$value=" + String.valueOf(this.memoryUsedKb$value) + ", state$value=" + String.valueOf(this.state$value) + ", realUser$value=" + String.valueOf(this.realUser$value) + ", realGroup$value=" + String.valueOf(this.realGroup$value) + ", virtualMemSizeKb$value=" + String.valueOf(this.virtualMemSizeKb$value) + ", cpuPercent$value=" + String.valueOf(this.cpuPercent$value) + ", commandLine$value=" + String.valueOf(this.commandLine$value) + ", gpuUtilization$value=" + String.valueOf(this.gpuUtilization$value) + ", gpuMemoryUtilization$value=" + String.valueOf(this.gpuMemoryUtilization$value) + ")";
            }
        }
    }

    static class CpuPerf {
        @NonNull
        private String id;
        private long userTicks;
        private long niceTicks;
        private long systemTicks;
        private long idleTicks;
        private long waitTicks;
        private long irqTicks;
        private long softIrqTicks;
        private long stolenTicks;
        private long totalTicks;
        private long pagesPagedIn;
        private long pagesPagedOut;
        private long pagesSwappedIn;
        private long pagesSwappedOut;

        @Generated
        public static CpuPerfBuilder builder() {
            return new CpuPerfBuilder();
        }

        @NonNull
        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public long getUserTicks() {
            return this.userTicks;
        }

        @Generated
        public long getNiceTicks() {
            return this.niceTicks;
        }

        @Generated
        public long getSystemTicks() {
            return this.systemTicks;
        }

        @Generated
        public long getIdleTicks() {
            return this.idleTicks;
        }

        @Generated
        public long getWaitTicks() {
            return this.waitTicks;
        }

        @Generated
        public long getIrqTicks() {
            return this.irqTicks;
        }

        @Generated
        public long getSoftIrqTicks() {
            return this.softIrqTicks;
        }

        @Generated
        public long getStolenTicks() {
            return this.stolenTicks;
        }

        @Generated
        public long getTotalTicks() {
            return this.totalTicks;
        }

        @Generated
        public long getPagesPagedIn() {
            return this.pagesPagedIn;
        }

        @Generated
        public long getPagesPagedOut() {
            return this.pagesPagedOut;
        }

        @Generated
        public long getPagesSwappedIn() {
            return this.pagesSwappedIn;
        }

        @Generated
        public long getPagesSwappedOut() {
            return this.pagesSwappedOut;
        }

        @Generated
        public void setId(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
        }

        @Generated
        public void setUserTicks(long userTicks) {
            this.userTicks = userTicks;
        }

        @Generated
        public void setNiceTicks(long niceTicks) {
            this.niceTicks = niceTicks;
        }

        @Generated
        public void setSystemTicks(long systemTicks) {
            this.systemTicks = systemTicks;
        }

        @Generated
        public void setIdleTicks(long idleTicks) {
            this.idleTicks = idleTicks;
        }

        @Generated
        public void setWaitTicks(long waitTicks) {
            this.waitTicks = waitTicks;
        }

        @Generated
        public void setIrqTicks(long irqTicks) {
            this.irqTicks = irqTicks;
        }

        @Generated
        public void setSoftIrqTicks(long softIrqTicks) {
            this.softIrqTicks = softIrqTicks;
        }

        @Generated
        public void setStolenTicks(long stolenTicks) {
            this.stolenTicks = stolenTicks;
        }

        @Generated
        public void setTotalTicks(long totalTicks) {
            this.totalTicks = totalTicks;
        }

        @Generated
        public void setPagesPagedIn(long pagesPagedIn) {
            this.pagesPagedIn = pagesPagedIn;
        }

        @Generated
        public void setPagesPagedOut(long pagesPagedOut) {
            this.pagesPagedOut = pagesPagedOut;
        }

        @Generated
        public void setPagesSwappedIn(long pagesSwappedIn) {
            this.pagesSwappedIn = pagesSwappedIn;
        }

        @Generated
        public void setPagesSwappedOut(long pagesSwappedOut) {
            this.pagesSwappedOut = pagesSwappedOut;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CpuPerf)) {
                return false;
            }
            CpuPerf other = (CpuPerf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getUserTicks() != other.getUserTicks()) {
                return false;
            }
            if (this.getNiceTicks() != other.getNiceTicks()) {
                return false;
            }
            if (this.getSystemTicks() != other.getSystemTicks()) {
                return false;
            }
            if (this.getIdleTicks() != other.getIdleTicks()) {
                return false;
            }
            if (this.getWaitTicks() != other.getWaitTicks()) {
                return false;
            }
            if (this.getIrqTicks() != other.getIrqTicks()) {
                return false;
            }
            if (this.getSoftIrqTicks() != other.getSoftIrqTicks()) {
                return false;
            }
            if (this.getStolenTicks() != other.getStolenTicks()) {
                return false;
            }
            if (this.getTotalTicks() != other.getTotalTicks()) {
                return false;
            }
            if (this.getPagesPagedIn() != other.getPagesPagedIn()) {
                return false;
            }
            if (this.getPagesPagedOut() != other.getPagesPagedOut()) {
                return false;
            }
            if (this.getPagesSwappedIn() != other.getPagesSwappedIn()) {
                return false;
            }
            if (this.getPagesSwappedOut() != other.getPagesSwappedOut()) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CpuPerf;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $userTicks = this.getUserTicks();
            result = result * 59 + (int)($userTicks >>> 32 ^ $userTicks);
            long $niceTicks = this.getNiceTicks();
            result = result * 59 + (int)($niceTicks >>> 32 ^ $niceTicks);
            long $systemTicks = this.getSystemTicks();
            result = result * 59 + (int)($systemTicks >>> 32 ^ $systemTicks);
            long $idleTicks = this.getIdleTicks();
            result = result * 59 + (int)($idleTicks >>> 32 ^ $idleTicks);
            long $waitTicks = this.getWaitTicks();
            result = result * 59 + (int)($waitTicks >>> 32 ^ $waitTicks);
            long $irqTicks = this.getIrqTicks();
            result = result * 59 + (int)($irqTicks >>> 32 ^ $irqTicks);
            long $softIrqTicks = this.getSoftIrqTicks();
            result = result * 59 + (int)($softIrqTicks >>> 32 ^ $softIrqTicks);
            long $stolenTicks = this.getStolenTicks();
            result = result * 59 + (int)($stolenTicks >>> 32 ^ $stolenTicks);
            long $totalTicks = this.getTotalTicks();
            result = result * 59 + (int)($totalTicks >>> 32 ^ $totalTicks);
            long $pagesPagedIn = this.getPagesPagedIn();
            result = result * 59 + (int)($pagesPagedIn >>> 32 ^ $pagesPagedIn);
            long $pagesPagedOut = this.getPagesPagedOut();
            result = result * 59 + (int)($pagesPagedOut >>> 32 ^ $pagesPagedOut);
            long $pagesSwappedIn = this.getPagesSwappedIn();
            result = result * 59 + (int)($pagesSwappedIn >>> 32 ^ $pagesSwappedIn);
            long $pagesSwappedOut = this.getPagesSwappedOut();
            result = result * 59 + (int)($pagesSwappedOut >>> 32 ^ $pagesSwappedOut);
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NewLinuxRawData.CpuPerf(id=" + this.getId() + ", userTicks=" + this.getUserTicks() + ", niceTicks=" + this.getNiceTicks() + ", systemTicks=" + this.getSystemTicks() + ", idleTicks=" + this.getIdleTicks() + ", waitTicks=" + this.getWaitTicks() + ", irqTicks=" + this.getIrqTicks() + ", softIrqTicks=" + this.getSoftIrqTicks() + ", stolenTicks=" + this.getStolenTicks() + ", totalTicks=" + this.getTotalTicks() + ", pagesPagedIn=" + this.getPagesPagedIn() + ", pagesPagedOut=" + this.getPagesPagedOut() + ", pagesSwappedIn=" + this.getPagesSwappedIn() + ", pagesSwappedOut=" + this.getPagesSwappedOut() + ")";
        }

        @Generated
        public CpuPerf(@NonNull String id, long userTicks, long niceTicks, long systemTicks, long idleTicks, long waitTicks, long irqTicks, long softIrqTicks, long stolenTicks, long totalTicks, long pagesPagedIn, long pagesPagedOut, long pagesSwappedIn, long pagesSwappedOut) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            this.userTicks = userTicks;
            this.niceTicks = niceTicks;
            this.systemTicks = systemTicks;
            this.idleTicks = idleTicks;
            this.waitTicks = waitTicks;
            this.irqTicks = irqTicks;
            this.softIrqTicks = softIrqTicks;
            this.stolenTicks = stolenTicks;
            this.totalTicks = totalTicks;
            this.pagesPagedIn = pagesPagedIn;
            this.pagesPagedOut = pagesPagedOut;
            this.pagesSwappedIn = pagesSwappedIn;
            this.pagesSwappedOut = pagesSwappedOut;
        }

        @Generated
        protected CpuPerf() {
        }

        @Generated
        public static class CpuPerfBuilder {
            @Generated
            private String id;
            @Generated
            private long userTicks;
            @Generated
            private long niceTicks;
            @Generated
            private long systemTicks;
            @Generated
            private long idleTicks;
            @Generated
            private long waitTicks;
            @Generated
            private long irqTicks;
            @Generated
            private long softIrqTicks;
            @Generated
            private long stolenTicks;
            @Generated
            private long totalTicks;
            @Generated
            private long pagesPagedIn;
            @Generated
            private long pagesPagedOut;
            @Generated
            private long pagesSwappedIn;
            @Generated
            private long pagesSwappedOut;

            @Generated
            CpuPerfBuilder() {
            }

            @Generated
            public CpuPerfBuilder id(@NonNull String id) {
                if (id == null) {
                    throw new NullPointerException("id is marked non-null but is null");
                }
                this.id = id;
                return this;
            }

            @Generated
            public CpuPerfBuilder userTicks(long userTicks) {
                this.userTicks = userTicks;
                return this;
            }

            @Generated
            public CpuPerfBuilder niceTicks(long niceTicks) {
                this.niceTicks = niceTicks;
                return this;
            }

            @Generated
            public CpuPerfBuilder systemTicks(long systemTicks) {
                this.systemTicks = systemTicks;
                return this;
            }

            @Generated
            public CpuPerfBuilder idleTicks(long idleTicks) {
                this.idleTicks = idleTicks;
                return this;
            }

            @Generated
            public CpuPerfBuilder waitTicks(long waitTicks) {
                this.waitTicks = waitTicks;
                return this;
            }

            @Generated
            public CpuPerfBuilder irqTicks(long irqTicks) {
                this.irqTicks = irqTicks;
                return this;
            }

            @Generated
            public CpuPerfBuilder softIrqTicks(long softIrqTicks) {
                this.softIrqTicks = softIrqTicks;
                return this;
            }

            @Generated
            public CpuPerfBuilder stolenTicks(long stolenTicks) {
                this.stolenTicks = stolenTicks;
                return this;
            }

            @Generated
            public CpuPerfBuilder totalTicks(long totalTicks) {
                this.totalTicks = totalTicks;
                return this;
            }

            @Generated
            public CpuPerfBuilder pagesPagedIn(long pagesPagedIn) {
                this.pagesPagedIn = pagesPagedIn;
                return this;
            }

            @Generated
            public CpuPerfBuilder pagesPagedOut(long pagesPagedOut) {
                this.pagesPagedOut = pagesPagedOut;
                return this;
            }

            @Generated
            public CpuPerfBuilder pagesSwappedIn(long pagesSwappedIn) {
                this.pagesSwappedIn = pagesSwappedIn;
                return this;
            }

            @Generated
            public CpuPerfBuilder pagesSwappedOut(long pagesSwappedOut) {
                this.pagesSwappedOut = pagesSwappedOut;
                return this;
            }

            @Generated
            public CpuPerf build() {
                return new CpuPerf(this.id, this.userTicks, this.niceTicks, this.systemTicks, this.idleTicks, this.waitTicks, this.irqTicks, this.softIrqTicks, this.stolenTicks, this.totalTicks, this.pagesPagedIn, this.pagesPagedOut, this.pagesSwappedIn, this.pagesSwappedOut);
            }

            @Generated
            public String toString() {
                return "NewLinuxRawData.CpuPerf.CpuPerfBuilder(id=" + this.id + ", userTicks=" + this.userTicks + ", niceTicks=" + this.niceTicks + ", systemTicks=" + this.systemTicks + ", idleTicks=" + this.idleTicks + ", waitTicks=" + this.waitTicks + ", irqTicks=" + this.irqTicks + ", softIrqTicks=" + this.softIrqTicks + ", stolenTicks=" + this.stolenTicks + ", totalTicks=" + this.totalTicks + ", pagesPagedIn=" + this.pagesPagedIn + ", pagesPagedOut=" + this.pagesPagedOut + ", pagesSwappedIn=" + this.pagesSwappedIn + ", pagesSwappedOut=" + this.pagesSwappedOut + ")";
            }
        }
    }

    static class Cpu {
        @NonNull
        private String id;
        private RawDataString vendor;
        private RawDataString model;
        private RawDataString flags;
        private RawDataString speedMhz;
        private RawDataLong coreCount;
        private RawDataLong logicalProcessorCount;

        @Generated
        public static CpuBuilder builder() {
            return new CpuBuilder();
        }

        @NonNull
        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public RawDataString getVendor() {
            return this.vendor;
        }

        @Generated
        public RawDataString getModel() {
            return this.model;
        }

        @Generated
        public RawDataString getFlags() {
            return this.flags;
        }

        @Generated
        public RawDataString getSpeedMhz() {
            return this.speedMhz;
        }

        @Generated
        public RawDataLong getCoreCount() {
            return this.coreCount;
        }

        @Generated
        public RawDataLong getLogicalProcessorCount() {
            return this.logicalProcessorCount;
        }

        @Generated
        public void setId(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
        }

        @Generated
        public void setVendor(RawDataString vendor) {
            this.vendor = vendor;
        }

        @Generated
        public void setModel(RawDataString model) {
            this.model = model;
        }

        @Generated
        public void setFlags(RawDataString flags) {
            this.flags = flags;
        }

        @Generated
        public void setSpeedMhz(RawDataString speedMhz) {
            this.speedMhz = speedMhz;
        }

        @Generated
        public void setCoreCount(RawDataLong coreCount) {
            this.coreCount = coreCount;
        }

        @Generated
        public void setLogicalProcessorCount(RawDataLong logicalProcessorCount) {
            this.logicalProcessorCount = logicalProcessorCount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cpu)) {
                return false;
            }
            Cpu other = (Cpu)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            RawDataString this$vendor = this.getVendor();
            RawDataString other$vendor = other.getVendor();
            if (this$vendor == null ? other$vendor != null : !this$vendor.equals(other$vendor)) {
                return false;
            }
            RawDataString this$model = this.getModel();
            RawDataString other$model = other.getModel();
            if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
                return false;
            }
            RawDataString this$flags = this.getFlags();
            RawDataString other$flags = other.getFlags();
            if (this$flags == null ? other$flags != null : !this$flags.equals(other$flags)) {
                return false;
            }
            RawDataString this$speedMhz = this.getSpeedMhz();
            RawDataString other$speedMhz = other.getSpeedMhz();
            if (this$speedMhz == null ? other$speedMhz != null : !this$speedMhz.equals(other$speedMhz)) {
                return false;
            }
            RawDataLong this$coreCount = this.getCoreCount();
            RawDataLong other$coreCount = other.getCoreCount();
            if (this$coreCount == null ? other$coreCount != null : !this$coreCount.equals(other$coreCount)) {
                return false;
            }
            RawDataLong this$logicalProcessorCount = this.getLogicalProcessorCount();
            RawDataLong other$logicalProcessorCount = other.getLogicalProcessorCount();
            return !(this$logicalProcessorCount == null ? other$logicalProcessorCount != null : !this$logicalProcessorCount.equals(other$logicalProcessorCount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Cpu;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            RawDataString $vendor = this.getVendor();
            result = result * 59 + ($vendor == null ? 43 : $vendor.hashCode());
            RawDataString $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            RawDataString $flags = this.getFlags();
            result = result * 59 + ($flags == null ? 43 : $flags.hashCode());
            RawDataString $speedMhz = this.getSpeedMhz();
            result = result * 59 + ($speedMhz == null ? 43 : $speedMhz.hashCode());
            RawDataLong $coreCount = this.getCoreCount();
            result = result * 59 + ($coreCount == null ? 43 : $coreCount.hashCode());
            RawDataLong $logicalProcessorCount = this.getLogicalProcessorCount();
            result = result * 59 + ($logicalProcessorCount == null ? 43 : $logicalProcessorCount.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NewLinuxRawData.Cpu(id=" + this.getId() + ", vendor=" + String.valueOf(this.getVendor()) + ", model=" + String.valueOf(this.getModel()) + ", flags=" + String.valueOf(this.getFlags()) + ", speedMhz=" + String.valueOf(this.getSpeedMhz()) + ", coreCount=" + String.valueOf(this.getCoreCount()) + ", logicalProcessorCount=" + String.valueOf(this.getLogicalProcessorCount()) + ")";
        }

        @Generated
        public Cpu(@NonNull String id, RawDataString vendor, RawDataString model, RawDataString flags, RawDataString speedMhz, RawDataLong coreCount, RawDataLong logicalProcessorCount) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            this.vendor = vendor;
            this.model = model;
            this.flags = flags;
            this.speedMhz = speedMhz;
            this.coreCount = coreCount;
            this.logicalProcessorCount = logicalProcessorCount;
        }

        @Generated
        protected Cpu() {
        }

        @Generated
        public static class CpuBuilder {
            @Generated
            private String id;
            @Generated
            private RawDataString vendor;
            @Generated
            private RawDataString model;
            @Generated
            private RawDataString flags;
            @Generated
            private RawDataString speedMhz;
            @Generated
            private RawDataLong coreCount;
            @Generated
            private RawDataLong logicalProcessorCount;

            @Generated
            CpuBuilder() {
            }

            @Generated
            public CpuBuilder id(@NonNull String id) {
                if (id == null) {
                    throw new NullPointerException("id is marked non-null but is null");
                }
                this.id = id;
                return this;
            }

            @Generated
            public CpuBuilder vendor(RawDataString vendor) {
                this.vendor = vendor;
                return this;
            }

            @Generated
            public CpuBuilder model(RawDataString model) {
                this.model = model;
                return this;
            }

            @Generated
            public CpuBuilder flags(RawDataString flags) {
                this.flags = flags;
                return this;
            }

            @Generated
            public CpuBuilder speedMhz(RawDataString speedMhz) {
                this.speedMhz = speedMhz;
                return this;
            }

            @Generated
            public CpuBuilder coreCount(RawDataLong coreCount) {
                this.coreCount = coreCount;
                return this;
            }

            @Generated
            public CpuBuilder logicalProcessorCount(RawDataLong logicalProcessorCount) {
                this.logicalProcessorCount = logicalProcessorCount;
                return this;
            }

            @Generated
            public Cpu build() {
                return new Cpu(this.id, this.vendor, this.model, this.flags, this.speedMhz, this.coreCount, this.logicalProcessorCount);
            }

            @Generated
            public String toString() {
                return "NewLinuxRawData.Cpu.CpuBuilder(id=" + this.id + ", vendor=" + String.valueOf(this.vendor) + ", model=" + String.valueOf(this.model) + ", flags=" + String.valueOf(this.flags) + ", speedMhz=" + String.valueOf(this.speedMhz) + ", coreCount=" + String.valueOf(this.coreCount) + ", logicalProcessorCount=" + String.valueOf(this.logicalProcessorCount) + ")";
            }
        }
    }

    static class Processor {
        @NonNull
        private String processorId;
        @NonNull
        private String physicalId;
        @NonNull
        private String coreId;
        private RawDataString vendor;
        private RawDataString model;
        private double speedMhz;
        private RawDataString flags;

        @Generated
        public static ProcessorBuilder builder() {
            return new ProcessorBuilder();
        }

        @NonNull
        @Generated
        public String getProcessorId() {
            return this.processorId;
        }

        @NonNull
        @Generated
        public String getPhysicalId() {
            return this.physicalId;
        }

        @NonNull
        @Generated
        public String getCoreId() {
            return this.coreId;
        }

        @Generated
        public RawDataString getVendor() {
            return this.vendor;
        }

        @Generated
        public RawDataString getModel() {
            return this.model;
        }

        @Generated
        public double getSpeedMhz() {
            return this.speedMhz;
        }

        @Generated
        public RawDataString getFlags() {
            return this.flags;
        }

        @Generated
        public void setProcessorId(@NonNull String processorId) {
            if (processorId == null) {
                throw new NullPointerException("processorId is marked non-null but is null");
            }
            this.processorId = processorId;
        }

        @Generated
        public void setPhysicalId(@NonNull String physicalId) {
            if (physicalId == null) {
                throw new NullPointerException("physicalId is marked non-null but is null");
            }
            this.physicalId = physicalId;
        }

        @Generated
        public void setCoreId(@NonNull String coreId) {
            if (coreId == null) {
                throw new NullPointerException("coreId is marked non-null but is null");
            }
            this.coreId = coreId;
        }

        @Generated
        public void setVendor(RawDataString vendor) {
            this.vendor = vendor;
        }

        @Generated
        public void setModel(RawDataString model) {
            this.model = model;
        }

        @Generated
        public void setSpeedMhz(double speedMhz) {
            this.speedMhz = speedMhz;
        }

        @Generated
        public void setFlags(RawDataString flags) {
            this.flags = flags;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Processor)) {
                return false;
            }
            Processor other = (Processor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getSpeedMhz(), other.getSpeedMhz()) != 0) {
                return false;
            }
            String this$processorId = this.getProcessorId();
            String other$processorId = other.getProcessorId();
            if (this$processorId == null ? other$processorId != null : !this$processorId.equals(other$processorId)) {
                return false;
            }
            String this$physicalId = this.getPhysicalId();
            String other$physicalId = other.getPhysicalId();
            if (this$physicalId == null ? other$physicalId != null : !this$physicalId.equals(other$physicalId)) {
                return false;
            }
            String this$coreId = this.getCoreId();
            String other$coreId = other.getCoreId();
            if (this$coreId == null ? other$coreId != null : !this$coreId.equals(other$coreId)) {
                return false;
            }
            RawDataString this$vendor = this.getVendor();
            RawDataString other$vendor = other.getVendor();
            if (this$vendor == null ? other$vendor != null : !this$vendor.equals(other$vendor)) {
                return false;
            }
            RawDataString this$model = this.getModel();
            RawDataString other$model = other.getModel();
            if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
                return false;
            }
            RawDataString this$flags = this.getFlags();
            RawDataString other$flags = other.getFlags();
            return !(this$flags == null ? other$flags != null : !this$flags.equals(other$flags));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Processor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $speedMhz = Double.doubleToLongBits(this.getSpeedMhz());
            result = result * 59 + (int)($speedMhz >>> 32 ^ $speedMhz);
            String $processorId = this.getProcessorId();
            result = result * 59 + ($processorId == null ? 43 : $processorId.hashCode());
            String $physicalId = this.getPhysicalId();
            result = result * 59 + ($physicalId == null ? 43 : $physicalId.hashCode());
            String $coreId = this.getCoreId();
            result = result * 59 + ($coreId == null ? 43 : $coreId.hashCode());
            RawDataString $vendor = this.getVendor();
            result = result * 59 + ($vendor == null ? 43 : $vendor.hashCode());
            RawDataString $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            RawDataString $flags = this.getFlags();
            result = result * 59 + ($flags == null ? 43 : $flags.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NewLinuxRawData.Processor(processorId=" + this.getProcessorId() + ", physicalId=" + this.getPhysicalId() + ", coreId=" + this.getCoreId() + ", vendor=" + String.valueOf(this.getVendor()) + ", model=" + String.valueOf(this.getModel()) + ", speedMhz=" + this.getSpeedMhz() + ", flags=" + String.valueOf(this.getFlags()) + ")";
        }

        @Generated
        public Processor(@NonNull String processorId, @NonNull String physicalId, @NonNull String coreId, RawDataString vendor, RawDataString model, double speedMhz, RawDataString flags) {
            if (processorId == null) {
                throw new NullPointerException("processorId is marked non-null but is null");
            }
            if (physicalId == null) {
                throw new NullPointerException("physicalId is marked non-null but is null");
            }
            if (coreId == null) {
                throw new NullPointerException("coreId is marked non-null but is null");
            }
            this.processorId = processorId;
            this.physicalId = physicalId;
            this.coreId = coreId;
            this.vendor = vendor;
            this.model = model;
            this.speedMhz = speedMhz;
            this.flags = flags;
        }

        @Generated
        protected Processor() {
        }

        @Generated
        public static class ProcessorBuilder {
            @Generated
            private String processorId;
            @Generated
            private String physicalId;
            @Generated
            private String coreId;
            @Generated
            private RawDataString vendor;
            @Generated
            private RawDataString model;
            @Generated
            private double speedMhz;
            @Generated
            private RawDataString flags;

            @Generated
            ProcessorBuilder() {
            }

            @Generated
            public ProcessorBuilder processorId(@NonNull String processorId) {
                if (processorId == null) {
                    throw new NullPointerException("processorId is marked non-null but is null");
                }
                this.processorId = processorId;
                return this;
            }

            @Generated
            public ProcessorBuilder physicalId(@NonNull String physicalId) {
                if (physicalId == null) {
                    throw new NullPointerException("physicalId is marked non-null but is null");
                }
                this.physicalId = physicalId;
                return this;
            }

            @Generated
            public ProcessorBuilder coreId(@NonNull String coreId) {
                if (coreId == null) {
                    throw new NullPointerException("coreId is marked non-null but is null");
                }
                this.coreId = coreId;
                return this;
            }

            @Generated
            public ProcessorBuilder vendor(RawDataString vendor) {
                this.vendor = vendor;
                return this;
            }

            @Generated
            public ProcessorBuilder model(RawDataString model) {
                this.model = model;
                return this;
            }

            @Generated
            public ProcessorBuilder speedMhz(double speedMhz) {
                this.speedMhz = speedMhz;
                return this;
            }

            @Generated
            public ProcessorBuilder flags(RawDataString flags) {
                this.flags = flags;
                return this;
            }

            @Generated
            public Processor build() {
                return new Processor(this.processorId, this.physicalId, this.coreId, this.vendor, this.model, this.speedMhz, this.flags);
            }

            @Generated
            public String toString() {
                return "NewLinuxRawData.Processor.ProcessorBuilder(processorId=" + this.processorId + ", physicalId=" + this.physicalId + ", coreId=" + this.coreId + ", vendor=" + String.valueOf(this.vendor) + ", model=" + String.valueOf(this.model) + ", speedMhz=" + this.speedMhz + ", flags=" + String.valueOf(this.flags) + ")";
            }
        }
    }

    static class NfsPartition {
        private RawDataString name;
        private RawDataLong readBytes;
        private RawDataLong writeBytes;
        private RawDataLong numReads;
        private RawDataLong numWrites;
        private RawDataLong readTimeMilliseconds;
        private RawDataLong writeTimeMilliseconds;
        private RawDataLong queueTimeMilliseconds;
        private RawDataLong timeStampInSeconds;

        @Generated
        private static RawDataString $default$name() {
            return RawDataConstants.ABSENT_STRING;
        }

        @Generated
        private static RawDataLong $default$readBytes() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$writeBytes() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$numReads() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$numWrites() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$readTimeMilliseconds() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$writeTimeMilliseconds() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$queueTimeMilliseconds() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$timeStampInSeconds() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        public static NfsPartitionBuilder builder() {
            return new NfsPartitionBuilder();
        }

        @Generated
        public RawDataString getName() {
            return this.name;
        }

        @Generated
        public RawDataLong getReadBytes() {
            return this.readBytes;
        }

        @Generated
        public RawDataLong getWriteBytes() {
            return this.writeBytes;
        }

        @Generated
        public RawDataLong getNumReads() {
            return this.numReads;
        }

        @Generated
        public RawDataLong getNumWrites() {
            return this.numWrites;
        }

        @Generated
        public RawDataLong getReadTimeMilliseconds() {
            return this.readTimeMilliseconds;
        }

        @Generated
        public RawDataLong getWriteTimeMilliseconds() {
            return this.writeTimeMilliseconds;
        }

        @Generated
        public RawDataLong getQueueTimeMilliseconds() {
            return this.queueTimeMilliseconds;
        }

        @Generated
        public RawDataLong getTimeStampInSeconds() {
            return this.timeStampInSeconds;
        }

        @Generated
        public void setName(RawDataString name) {
            this.name = name;
        }

        @Generated
        public void setReadBytes(RawDataLong readBytes) {
            this.readBytes = readBytes;
        }

        @Generated
        public void setWriteBytes(RawDataLong writeBytes) {
            this.writeBytes = writeBytes;
        }

        @Generated
        public void setNumReads(RawDataLong numReads) {
            this.numReads = numReads;
        }

        @Generated
        public void setNumWrites(RawDataLong numWrites) {
            this.numWrites = numWrites;
        }

        @Generated
        public void setReadTimeMilliseconds(RawDataLong readTimeMilliseconds) {
            this.readTimeMilliseconds = readTimeMilliseconds;
        }

        @Generated
        public void setWriteTimeMilliseconds(RawDataLong writeTimeMilliseconds) {
            this.writeTimeMilliseconds = writeTimeMilliseconds;
        }

        @Generated
        public void setQueueTimeMilliseconds(RawDataLong queueTimeMilliseconds) {
            this.queueTimeMilliseconds = queueTimeMilliseconds;
        }

        @Generated
        public void setTimeStampInSeconds(RawDataLong timeStampInSeconds) {
            this.timeStampInSeconds = timeStampInSeconds;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NfsPartition)) {
                return false;
            }
            NfsPartition other = (NfsPartition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RawDataString this$name = this.getName();
            RawDataString other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            RawDataLong this$readBytes = this.getReadBytes();
            RawDataLong other$readBytes = other.getReadBytes();
            if (this$readBytes == null ? other$readBytes != null : !this$readBytes.equals(other$readBytes)) {
                return false;
            }
            RawDataLong this$writeBytes = this.getWriteBytes();
            RawDataLong other$writeBytes = other.getWriteBytes();
            if (this$writeBytes == null ? other$writeBytes != null : !this$writeBytes.equals(other$writeBytes)) {
                return false;
            }
            RawDataLong this$numReads = this.getNumReads();
            RawDataLong other$numReads = other.getNumReads();
            if (this$numReads == null ? other$numReads != null : !this$numReads.equals(other$numReads)) {
                return false;
            }
            RawDataLong this$numWrites = this.getNumWrites();
            RawDataLong other$numWrites = other.getNumWrites();
            if (this$numWrites == null ? other$numWrites != null : !this$numWrites.equals(other$numWrites)) {
                return false;
            }
            RawDataLong this$readTimeMilliseconds = this.getReadTimeMilliseconds();
            RawDataLong other$readTimeMilliseconds = other.getReadTimeMilliseconds();
            if (this$readTimeMilliseconds == null ? other$readTimeMilliseconds != null : !this$readTimeMilliseconds.equals(other$readTimeMilliseconds)) {
                return false;
            }
            RawDataLong this$writeTimeMilliseconds = this.getWriteTimeMilliseconds();
            RawDataLong other$writeTimeMilliseconds = other.getWriteTimeMilliseconds();
            if (this$writeTimeMilliseconds == null ? other$writeTimeMilliseconds != null : !this$writeTimeMilliseconds.equals(other$writeTimeMilliseconds)) {
                return false;
            }
            RawDataLong this$queueTimeMilliseconds = this.getQueueTimeMilliseconds();
            RawDataLong other$queueTimeMilliseconds = other.getQueueTimeMilliseconds();
            if (this$queueTimeMilliseconds == null ? other$queueTimeMilliseconds != null : !this$queueTimeMilliseconds.equals(other$queueTimeMilliseconds)) {
                return false;
            }
            RawDataLong this$timeStampInSeconds = this.getTimeStampInSeconds();
            RawDataLong other$timeStampInSeconds = other.getTimeStampInSeconds();
            return !(this$timeStampInSeconds == null ? other$timeStampInSeconds != null : !this$timeStampInSeconds.equals(other$timeStampInSeconds));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NfsPartition;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RawDataString $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            RawDataLong $readBytes = this.getReadBytes();
            result = result * 59 + ($readBytes == null ? 43 : $readBytes.hashCode());
            RawDataLong $writeBytes = this.getWriteBytes();
            result = result * 59 + ($writeBytes == null ? 43 : $writeBytes.hashCode());
            RawDataLong $numReads = this.getNumReads();
            result = result * 59 + ($numReads == null ? 43 : $numReads.hashCode());
            RawDataLong $numWrites = this.getNumWrites();
            result = result * 59 + ($numWrites == null ? 43 : $numWrites.hashCode());
            RawDataLong $readTimeMilliseconds = this.getReadTimeMilliseconds();
            result = result * 59 + ($readTimeMilliseconds == null ? 43 : $readTimeMilliseconds.hashCode());
            RawDataLong $writeTimeMilliseconds = this.getWriteTimeMilliseconds();
            result = result * 59 + ($writeTimeMilliseconds == null ? 43 : $writeTimeMilliseconds.hashCode());
            RawDataLong $queueTimeMilliseconds = this.getQueueTimeMilliseconds();
            result = result * 59 + ($queueTimeMilliseconds == null ? 43 : $queueTimeMilliseconds.hashCode());
            RawDataLong $timeStampInSeconds = this.getTimeStampInSeconds();
            result = result * 59 + ($timeStampInSeconds == null ? 43 : $timeStampInSeconds.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NewLinuxRawData.NfsPartition(name=" + String.valueOf(this.getName()) + ", readBytes=" + String.valueOf(this.getReadBytes()) + ", writeBytes=" + String.valueOf(this.getWriteBytes()) + ", numReads=" + String.valueOf(this.getNumReads()) + ", numWrites=" + String.valueOf(this.getNumWrites()) + ", readTimeMilliseconds=" + String.valueOf(this.getReadTimeMilliseconds()) + ", writeTimeMilliseconds=" + String.valueOf(this.getWriteTimeMilliseconds()) + ", queueTimeMilliseconds=" + String.valueOf(this.getQueueTimeMilliseconds()) + ", timeStampInSeconds=" + String.valueOf(this.getTimeStampInSeconds()) + ")";
        }

        @Generated
        protected NfsPartition() {
            this.name = NfsPartition.$default$name();
            this.readBytes = NfsPartition.$default$readBytes();
            this.writeBytes = NfsPartition.$default$writeBytes();
            this.numReads = NfsPartition.$default$numReads();
            this.numWrites = NfsPartition.$default$numWrites();
            this.readTimeMilliseconds = NfsPartition.$default$readTimeMilliseconds();
            this.writeTimeMilliseconds = NfsPartition.$default$writeTimeMilliseconds();
            this.queueTimeMilliseconds = NfsPartition.$default$queueTimeMilliseconds();
            this.timeStampInSeconds = NfsPartition.$default$timeStampInSeconds();
        }

        @Generated
        public NfsPartition(RawDataString name, RawDataLong readBytes, RawDataLong writeBytes, RawDataLong numReads, RawDataLong numWrites, RawDataLong readTimeMilliseconds, RawDataLong writeTimeMilliseconds, RawDataLong queueTimeMilliseconds, RawDataLong timeStampInSeconds) {
            this.name = name;
            this.readBytes = readBytes;
            this.writeBytes = writeBytes;
            this.numReads = numReads;
            this.numWrites = numWrites;
            this.readTimeMilliseconds = readTimeMilliseconds;
            this.writeTimeMilliseconds = writeTimeMilliseconds;
            this.queueTimeMilliseconds = queueTimeMilliseconds;
            this.timeStampInSeconds = timeStampInSeconds;
        }

        public static class NfsPartitionBuilder {
            @Generated
            private boolean name$set;
            @Generated
            private RawDataString name$value;
            @Generated
            private boolean readBytes$set;
            @Generated
            private RawDataLong readBytes$value;
            @Generated
            private boolean writeBytes$set;
            @Generated
            private RawDataLong writeBytes$value;
            @Generated
            private boolean numReads$set;
            @Generated
            private RawDataLong numReads$value;
            @Generated
            private boolean numWrites$set;
            @Generated
            private RawDataLong numWrites$value;
            @Generated
            private boolean readTimeMilliseconds$set;
            @Generated
            private RawDataLong readTimeMilliseconds$value;
            @Generated
            private boolean writeTimeMilliseconds$set;
            @Generated
            private RawDataLong writeTimeMilliseconds$value;
            @Generated
            private boolean queueTimeMilliseconds$set;
            @Generated
            private RawDataLong queueTimeMilliseconds$value;
            @Generated
            private boolean timeStampInSeconds$set;
            @Generated
            private RawDataLong timeStampInSeconds$value;
            private RawDataString name = RawDataConstants.ABSENT_STRING;
            private RawDataLong readBytes = RawDataConstants.ZERO_LONG;
            private RawDataLong writeBytes = RawDataConstants.ZERO_LONG;
            private RawDataLong numReads = RawDataConstants.ZERO_LONG;
            private RawDataLong numWrites = RawDataConstants.ZERO_LONG;
            private RawDataLong readTimeMilliseconds = RawDataConstants.ZERO_LONG;
            private RawDataLong writeTimeMilliseconds = RawDataConstants.ZERO_LONG;
            private RawDataLong queueTimeMilliseconds = RawDataConstants.ZERO_LONG;
            private RawDataLong timeStampInSeconds = RawDataConstants.ZERO_LONG;

            @Generated
            NfsPartitionBuilder() {
            }

            @Generated
            public NfsPartitionBuilder name(RawDataString name) {
                this.name$value = name;
                this.name$set = true;
                return this;
            }

            @Generated
            public NfsPartitionBuilder readBytes(RawDataLong readBytes) {
                this.readBytes$value = readBytes;
                this.readBytes$set = true;
                return this;
            }

            @Generated
            public NfsPartitionBuilder writeBytes(RawDataLong writeBytes) {
                this.writeBytes$value = writeBytes;
                this.writeBytes$set = true;
                return this;
            }

            @Generated
            public NfsPartitionBuilder numReads(RawDataLong numReads) {
                this.numReads$value = numReads;
                this.numReads$set = true;
                return this;
            }

            @Generated
            public NfsPartitionBuilder numWrites(RawDataLong numWrites) {
                this.numWrites$value = numWrites;
                this.numWrites$set = true;
                return this;
            }

            @Generated
            public NfsPartitionBuilder readTimeMilliseconds(RawDataLong readTimeMilliseconds) {
                this.readTimeMilliseconds$value = readTimeMilliseconds;
                this.readTimeMilliseconds$set = true;
                return this;
            }

            @Generated
            public NfsPartitionBuilder writeTimeMilliseconds(RawDataLong writeTimeMilliseconds) {
                this.writeTimeMilliseconds$value = writeTimeMilliseconds;
                this.writeTimeMilliseconds$set = true;
                return this;
            }

            @Generated
            public NfsPartitionBuilder queueTimeMilliseconds(RawDataLong queueTimeMilliseconds) {
                this.queueTimeMilliseconds$value = queueTimeMilliseconds;
                this.queueTimeMilliseconds$set = true;
                return this;
            }

            @Generated
            public NfsPartitionBuilder timeStampInSeconds(RawDataLong timeStampInSeconds) {
                this.timeStampInSeconds$value = timeStampInSeconds;
                this.timeStampInSeconds$set = true;
                return this;
            }

            @Generated
            public NfsPartition build() {
                RawDataString name$value = this.name$value;
                if (!this.name$set) {
                    name$value = NfsPartition.$default$name();
                }
                RawDataLong readBytes$value = this.readBytes$value;
                if (!this.readBytes$set) {
                    readBytes$value = NfsPartition.$default$readBytes();
                }
                RawDataLong writeBytes$value = this.writeBytes$value;
                if (!this.writeBytes$set) {
                    writeBytes$value = NfsPartition.$default$writeBytes();
                }
                RawDataLong numReads$value = this.numReads$value;
                if (!this.numReads$set) {
                    numReads$value = NfsPartition.$default$numReads();
                }
                RawDataLong numWrites$value = this.numWrites$value;
                if (!this.numWrites$set) {
                    numWrites$value = NfsPartition.$default$numWrites();
                }
                RawDataLong readTimeMilliseconds$value = this.readTimeMilliseconds$value;
                if (!this.readTimeMilliseconds$set) {
                    readTimeMilliseconds$value = NfsPartition.$default$readTimeMilliseconds();
                }
                RawDataLong writeTimeMilliseconds$value = this.writeTimeMilliseconds$value;
                if (!this.writeTimeMilliseconds$set) {
                    writeTimeMilliseconds$value = NfsPartition.$default$writeTimeMilliseconds();
                }
                RawDataLong queueTimeMilliseconds$value = this.queueTimeMilliseconds$value;
                if (!this.queueTimeMilliseconds$set) {
                    queueTimeMilliseconds$value = NfsPartition.$default$queueTimeMilliseconds();
                }
                RawDataLong timeStampInSeconds$value = this.timeStampInSeconds$value;
                if (!this.timeStampInSeconds$set) {
                    timeStampInSeconds$value = NfsPartition.$default$timeStampInSeconds();
                }
                return new NfsPartition(name$value, readBytes$value, writeBytes$value, numReads$value, numWrites$value, readTimeMilliseconds$value, writeTimeMilliseconds$value, queueTimeMilliseconds$value, timeStampInSeconds$value);
            }

            @Generated
            public String toString() {
                return "NewLinuxRawData.NfsPartition.NfsPartitionBuilder(name$value=" + String.valueOf(this.name$value) + ", readBytes$value=" + String.valueOf(this.readBytes$value) + ", writeBytes$value=" + String.valueOf(this.writeBytes$value) + ", numReads$value=" + String.valueOf(this.numReads$value) + ", numWrites$value=" + String.valueOf(this.numWrites$value) + ", readTimeMilliseconds$value=" + String.valueOf(this.readTimeMilliseconds$value) + ", writeTimeMilliseconds$value=" + String.valueOf(this.writeTimeMilliseconds$value) + ", queueTimeMilliseconds$value=" + String.valueOf(this.queueTimeMilliseconds$value) + ", timeStampInSeconds$value=" + String.valueOf(this.timeStampInSeconds$value) + ")";
            }
        }
    }

    static class Partition {
        private RawDataString name;
        private RawDataLong numReadsCompleted;
        private RawDataLong numSectorsRead;
        private RawDataLong numMillisecondsReading;
        private RawDataLong numWritesCompleted;
        private RawDataLong numSectorsWritten;
        private RawDataLong numMillisecondsWriting;
        private RawDataLong numMillisecondsDoingIo;
        private RawDataLong diskSectorSize;
        private RawDataLong readBytes;
        private RawDataLong writeBytes;
        private RawDataLong queueTimeMilliseconds;
        private RawDataLong timeStampInSeconds;
        private boolean isNfs;

        @Generated
        private static RawDataString $default$name() {
            return RawDataConstants.ABSENT_STRING;
        }

        @Generated
        private static RawDataLong $default$numReadsCompleted() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$numSectorsRead() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$numMillisecondsReading() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$numWritesCompleted() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$numSectorsWritten() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$numMillisecondsWriting() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$numMillisecondsDoingIo() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$diskSectorSize() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$readBytes() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$writeBytes() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$queueTimeMilliseconds() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$timeStampInSeconds() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static boolean $default$isNfs() {
            return false;
        }

        @Generated
        public static PartitionBuilder builder() {
            return new PartitionBuilder();
        }

        @Generated
        public RawDataString getName() {
            return this.name;
        }

        @Generated
        public RawDataLong getNumReadsCompleted() {
            return this.numReadsCompleted;
        }

        @Generated
        public RawDataLong getNumSectorsRead() {
            return this.numSectorsRead;
        }

        @Generated
        public RawDataLong getNumMillisecondsReading() {
            return this.numMillisecondsReading;
        }

        @Generated
        public RawDataLong getNumWritesCompleted() {
            return this.numWritesCompleted;
        }

        @Generated
        public RawDataLong getNumSectorsWritten() {
            return this.numSectorsWritten;
        }

        @Generated
        public RawDataLong getNumMillisecondsWriting() {
            return this.numMillisecondsWriting;
        }

        @Generated
        public RawDataLong getNumMillisecondsDoingIo() {
            return this.numMillisecondsDoingIo;
        }

        @Generated
        public RawDataLong getDiskSectorSize() {
            return this.diskSectorSize;
        }

        @Generated
        public RawDataLong getReadBytes() {
            return this.readBytes;
        }

        @Generated
        public RawDataLong getWriteBytes() {
            return this.writeBytes;
        }

        @Generated
        public RawDataLong getQueueTimeMilliseconds() {
            return this.queueTimeMilliseconds;
        }

        @Generated
        public RawDataLong getTimeStampInSeconds() {
            return this.timeStampInSeconds;
        }

        @Generated
        public boolean isNfs() {
            return this.isNfs;
        }

        @Generated
        public void setName(RawDataString name) {
            this.name = name;
        }

        @Generated
        public void setNumReadsCompleted(RawDataLong numReadsCompleted) {
            this.numReadsCompleted = numReadsCompleted;
        }

        @Generated
        public void setNumSectorsRead(RawDataLong numSectorsRead) {
            this.numSectorsRead = numSectorsRead;
        }

        @Generated
        public void setNumMillisecondsReading(RawDataLong numMillisecondsReading) {
            this.numMillisecondsReading = numMillisecondsReading;
        }

        @Generated
        public void setNumWritesCompleted(RawDataLong numWritesCompleted) {
            this.numWritesCompleted = numWritesCompleted;
        }

        @Generated
        public void setNumSectorsWritten(RawDataLong numSectorsWritten) {
            this.numSectorsWritten = numSectorsWritten;
        }

        @Generated
        public void setNumMillisecondsWriting(RawDataLong numMillisecondsWriting) {
            this.numMillisecondsWriting = numMillisecondsWriting;
        }

        @Generated
        public void setNumMillisecondsDoingIo(RawDataLong numMillisecondsDoingIo) {
            this.numMillisecondsDoingIo = numMillisecondsDoingIo;
        }

        @Generated
        public void setDiskSectorSize(RawDataLong diskSectorSize) {
            this.diskSectorSize = diskSectorSize;
        }

        @Generated
        public void setReadBytes(RawDataLong readBytes) {
            this.readBytes = readBytes;
        }

        @Generated
        public void setWriteBytes(RawDataLong writeBytes) {
            this.writeBytes = writeBytes;
        }

        @Generated
        public void setQueueTimeMilliseconds(RawDataLong queueTimeMilliseconds) {
            this.queueTimeMilliseconds = queueTimeMilliseconds;
        }

        @Generated
        public void setTimeStampInSeconds(RawDataLong timeStampInSeconds) {
            this.timeStampInSeconds = timeStampInSeconds;
        }

        @Generated
        public void setNfs(boolean isNfs) {
            this.isNfs = isNfs;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Partition)) {
                return false;
            }
            Partition other = (Partition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isNfs() != other.isNfs()) {
                return false;
            }
            RawDataString this$name = this.getName();
            RawDataString other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            RawDataLong this$numReadsCompleted = this.getNumReadsCompleted();
            RawDataLong other$numReadsCompleted = other.getNumReadsCompleted();
            if (this$numReadsCompleted == null ? other$numReadsCompleted != null : !this$numReadsCompleted.equals(other$numReadsCompleted)) {
                return false;
            }
            RawDataLong this$numSectorsRead = this.getNumSectorsRead();
            RawDataLong other$numSectorsRead = other.getNumSectorsRead();
            if (this$numSectorsRead == null ? other$numSectorsRead != null : !this$numSectorsRead.equals(other$numSectorsRead)) {
                return false;
            }
            RawDataLong this$numMillisecondsReading = this.getNumMillisecondsReading();
            RawDataLong other$numMillisecondsReading = other.getNumMillisecondsReading();
            if (this$numMillisecondsReading == null ? other$numMillisecondsReading != null : !this$numMillisecondsReading.equals(other$numMillisecondsReading)) {
                return false;
            }
            RawDataLong this$numWritesCompleted = this.getNumWritesCompleted();
            RawDataLong other$numWritesCompleted = other.getNumWritesCompleted();
            if (this$numWritesCompleted == null ? other$numWritesCompleted != null : !this$numWritesCompleted.equals(other$numWritesCompleted)) {
                return false;
            }
            RawDataLong this$numSectorsWritten = this.getNumSectorsWritten();
            RawDataLong other$numSectorsWritten = other.getNumSectorsWritten();
            if (this$numSectorsWritten == null ? other$numSectorsWritten != null : !this$numSectorsWritten.equals(other$numSectorsWritten)) {
                return false;
            }
            RawDataLong this$numMillisecondsWriting = this.getNumMillisecondsWriting();
            RawDataLong other$numMillisecondsWriting = other.getNumMillisecondsWriting();
            if (this$numMillisecondsWriting == null ? other$numMillisecondsWriting != null : !this$numMillisecondsWriting.equals(other$numMillisecondsWriting)) {
                return false;
            }
            RawDataLong this$numMillisecondsDoingIo = this.getNumMillisecondsDoingIo();
            RawDataLong other$numMillisecondsDoingIo = other.getNumMillisecondsDoingIo();
            if (this$numMillisecondsDoingIo == null ? other$numMillisecondsDoingIo != null : !this$numMillisecondsDoingIo.equals(other$numMillisecondsDoingIo)) {
                return false;
            }
            RawDataLong this$diskSectorSize = this.getDiskSectorSize();
            RawDataLong other$diskSectorSize = other.getDiskSectorSize();
            if (this$diskSectorSize == null ? other$diskSectorSize != null : !this$diskSectorSize.equals(other$diskSectorSize)) {
                return false;
            }
            RawDataLong this$readBytes = this.getReadBytes();
            RawDataLong other$readBytes = other.getReadBytes();
            if (this$readBytes == null ? other$readBytes != null : !this$readBytes.equals(other$readBytes)) {
                return false;
            }
            RawDataLong this$writeBytes = this.getWriteBytes();
            RawDataLong other$writeBytes = other.getWriteBytes();
            if (this$writeBytes == null ? other$writeBytes != null : !this$writeBytes.equals(other$writeBytes)) {
                return false;
            }
            RawDataLong this$queueTimeMilliseconds = this.getQueueTimeMilliseconds();
            RawDataLong other$queueTimeMilliseconds = other.getQueueTimeMilliseconds();
            if (this$queueTimeMilliseconds == null ? other$queueTimeMilliseconds != null : !this$queueTimeMilliseconds.equals(other$queueTimeMilliseconds)) {
                return false;
            }
            RawDataLong this$timeStampInSeconds = this.getTimeStampInSeconds();
            RawDataLong other$timeStampInSeconds = other.getTimeStampInSeconds();
            return !(this$timeStampInSeconds == null ? other$timeStampInSeconds != null : !this$timeStampInSeconds.equals(other$timeStampInSeconds));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Partition;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isNfs() ? 79 : 97);
            RawDataString $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            RawDataLong $numReadsCompleted = this.getNumReadsCompleted();
            result = result * 59 + ($numReadsCompleted == null ? 43 : $numReadsCompleted.hashCode());
            RawDataLong $numSectorsRead = this.getNumSectorsRead();
            result = result * 59 + ($numSectorsRead == null ? 43 : $numSectorsRead.hashCode());
            RawDataLong $numMillisecondsReading = this.getNumMillisecondsReading();
            result = result * 59 + ($numMillisecondsReading == null ? 43 : $numMillisecondsReading.hashCode());
            RawDataLong $numWritesCompleted = this.getNumWritesCompleted();
            result = result * 59 + ($numWritesCompleted == null ? 43 : $numWritesCompleted.hashCode());
            RawDataLong $numSectorsWritten = this.getNumSectorsWritten();
            result = result * 59 + ($numSectorsWritten == null ? 43 : $numSectorsWritten.hashCode());
            RawDataLong $numMillisecondsWriting = this.getNumMillisecondsWriting();
            result = result * 59 + ($numMillisecondsWriting == null ? 43 : $numMillisecondsWriting.hashCode());
            RawDataLong $numMillisecondsDoingIo = this.getNumMillisecondsDoingIo();
            result = result * 59 + ($numMillisecondsDoingIo == null ? 43 : $numMillisecondsDoingIo.hashCode());
            RawDataLong $diskSectorSize = this.getDiskSectorSize();
            result = result * 59 + ($diskSectorSize == null ? 43 : $diskSectorSize.hashCode());
            RawDataLong $readBytes = this.getReadBytes();
            result = result * 59 + ($readBytes == null ? 43 : $readBytes.hashCode());
            RawDataLong $writeBytes = this.getWriteBytes();
            result = result * 59 + ($writeBytes == null ? 43 : $writeBytes.hashCode());
            RawDataLong $queueTimeMilliseconds = this.getQueueTimeMilliseconds();
            result = result * 59 + ($queueTimeMilliseconds == null ? 43 : $queueTimeMilliseconds.hashCode());
            RawDataLong $timeStampInSeconds = this.getTimeStampInSeconds();
            result = result * 59 + ($timeStampInSeconds == null ? 43 : $timeStampInSeconds.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NewLinuxRawData.Partition(name=" + String.valueOf(this.getName()) + ", numReadsCompleted=" + String.valueOf(this.getNumReadsCompleted()) + ", numSectorsRead=" + String.valueOf(this.getNumSectorsRead()) + ", numMillisecondsReading=" + String.valueOf(this.getNumMillisecondsReading()) + ", numWritesCompleted=" + String.valueOf(this.getNumWritesCompleted()) + ", numSectorsWritten=" + String.valueOf(this.getNumSectorsWritten()) + ", numMillisecondsWriting=" + String.valueOf(this.getNumMillisecondsWriting()) + ", numMillisecondsDoingIo=" + String.valueOf(this.getNumMillisecondsDoingIo()) + ", diskSectorSize=" + String.valueOf(this.getDiskSectorSize()) + ", readBytes=" + String.valueOf(this.getReadBytes()) + ", writeBytes=" + String.valueOf(this.getWriteBytes()) + ", queueTimeMilliseconds=" + String.valueOf(this.getQueueTimeMilliseconds()) + ", timeStampInSeconds=" + String.valueOf(this.getTimeStampInSeconds()) + ", isNfs=" + this.isNfs() + ")";
        }

        @Generated
        protected Partition() {
            this.name = Partition.$default$name();
            this.numReadsCompleted = Partition.$default$numReadsCompleted();
            this.numSectorsRead = Partition.$default$numSectorsRead();
            this.numMillisecondsReading = Partition.$default$numMillisecondsReading();
            this.numWritesCompleted = Partition.$default$numWritesCompleted();
            this.numSectorsWritten = Partition.$default$numSectorsWritten();
            this.numMillisecondsWriting = Partition.$default$numMillisecondsWriting();
            this.numMillisecondsDoingIo = Partition.$default$numMillisecondsDoingIo();
            this.diskSectorSize = Partition.$default$diskSectorSize();
            this.readBytes = Partition.$default$readBytes();
            this.writeBytes = Partition.$default$writeBytes();
            this.queueTimeMilliseconds = Partition.$default$queueTimeMilliseconds();
            this.timeStampInSeconds = Partition.$default$timeStampInSeconds();
            this.isNfs = Partition.$default$isNfs();
        }

        @Generated
        public Partition(RawDataString name, RawDataLong numReadsCompleted, RawDataLong numSectorsRead, RawDataLong numMillisecondsReading, RawDataLong numWritesCompleted, RawDataLong numSectorsWritten, RawDataLong numMillisecondsWriting, RawDataLong numMillisecondsDoingIo, RawDataLong diskSectorSize, RawDataLong readBytes, RawDataLong writeBytes, RawDataLong queueTimeMilliseconds, RawDataLong timeStampInSeconds, boolean isNfs) {
            this.name = name;
            this.numReadsCompleted = numReadsCompleted;
            this.numSectorsRead = numSectorsRead;
            this.numMillisecondsReading = numMillisecondsReading;
            this.numWritesCompleted = numWritesCompleted;
            this.numSectorsWritten = numSectorsWritten;
            this.numMillisecondsWriting = numMillisecondsWriting;
            this.numMillisecondsDoingIo = numMillisecondsDoingIo;
            this.diskSectorSize = diskSectorSize;
            this.readBytes = readBytes;
            this.writeBytes = writeBytes;
            this.queueTimeMilliseconds = queueTimeMilliseconds;
            this.timeStampInSeconds = timeStampInSeconds;
            this.isNfs = isNfs;
        }

        public static class PartitionBuilder {
            @Generated
            private boolean name$set;
            @Generated
            private RawDataString name$value;
            @Generated
            private boolean numReadsCompleted$set;
            @Generated
            private RawDataLong numReadsCompleted$value;
            @Generated
            private boolean numSectorsRead$set;
            @Generated
            private RawDataLong numSectorsRead$value;
            @Generated
            private boolean numMillisecondsReading$set;
            @Generated
            private RawDataLong numMillisecondsReading$value;
            @Generated
            private boolean numWritesCompleted$set;
            @Generated
            private RawDataLong numWritesCompleted$value;
            @Generated
            private boolean numSectorsWritten$set;
            @Generated
            private RawDataLong numSectorsWritten$value;
            @Generated
            private boolean numMillisecondsWriting$set;
            @Generated
            private RawDataLong numMillisecondsWriting$value;
            @Generated
            private boolean numMillisecondsDoingIo$set;
            @Generated
            private RawDataLong numMillisecondsDoingIo$value;
            @Generated
            private boolean diskSectorSize$set;
            @Generated
            private RawDataLong diskSectorSize$value;
            @Generated
            private boolean readBytes$set;
            @Generated
            private RawDataLong readBytes$value;
            @Generated
            private boolean writeBytes$set;
            @Generated
            private RawDataLong writeBytes$value;
            @Generated
            private boolean queueTimeMilliseconds$set;
            @Generated
            private RawDataLong queueTimeMilliseconds$value;
            @Generated
            private boolean timeStampInSeconds$set;
            @Generated
            private RawDataLong timeStampInSeconds$value;
            @Generated
            private boolean isNfs$set;
            @Generated
            private boolean isNfs$value;
            private RawDataString name = RawDataConstants.ABSENT_STRING;
            private RawDataLong numReadsCompleted = RawDataConstants.ZERO_LONG;
            private RawDataLong numSectorsRead = RawDataConstants.ZERO_LONG;
            private RawDataLong numMillisecondsReading = RawDataConstants.ZERO_LONG;
            private RawDataLong numWritesCompleted = RawDataConstants.ZERO_LONG;
            private RawDataLong numSectorsWritten = RawDataConstants.ZERO_LONG;
            private RawDataLong numMillisecondsWriting = RawDataConstants.ZERO_LONG;
            private RawDataLong numMillisecondsDoingIo = RawDataConstants.ZERO_LONG;
            private RawDataLong diskSectorSize = RawDataConstants.ZERO_LONG;
            private RawDataLong readBytes = RawDataConstants.ZERO_LONG;
            private RawDataLong writeBytes = RawDataConstants.ZERO_LONG;
            private RawDataLong queueTimeMilliseconds = RawDataConstants.ZERO_LONG;
            private RawDataLong timeStampInSeconds = RawDataConstants.ZERO_LONG;
            private boolean isNfs = false;

            @Generated
            PartitionBuilder() {
            }

            @Generated
            public PartitionBuilder name(RawDataString name) {
                this.name$value = name;
                this.name$set = true;
                return this;
            }

            @Generated
            public PartitionBuilder numReadsCompleted(RawDataLong numReadsCompleted) {
                this.numReadsCompleted$value = numReadsCompleted;
                this.numReadsCompleted$set = true;
                return this;
            }

            @Generated
            public PartitionBuilder numSectorsRead(RawDataLong numSectorsRead) {
                this.numSectorsRead$value = numSectorsRead;
                this.numSectorsRead$set = true;
                return this;
            }

            @Generated
            public PartitionBuilder numMillisecondsReading(RawDataLong numMillisecondsReading) {
                this.numMillisecondsReading$value = numMillisecondsReading;
                this.numMillisecondsReading$set = true;
                return this;
            }

            @Generated
            public PartitionBuilder numWritesCompleted(RawDataLong numWritesCompleted) {
                this.numWritesCompleted$value = numWritesCompleted;
                this.numWritesCompleted$set = true;
                return this;
            }

            @Generated
            public PartitionBuilder numSectorsWritten(RawDataLong numSectorsWritten) {
                this.numSectorsWritten$value = numSectorsWritten;
                this.numSectorsWritten$set = true;
                return this;
            }

            @Generated
            public PartitionBuilder numMillisecondsWriting(RawDataLong numMillisecondsWriting) {
                this.numMillisecondsWriting$value = numMillisecondsWriting;
                this.numMillisecondsWriting$set = true;
                return this;
            }

            @Generated
            public PartitionBuilder numMillisecondsDoingIo(RawDataLong numMillisecondsDoingIo) {
                this.numMillisecondsDoingIo$value = numMillisecondsDoingIo;
                this.numMillisecondsDoingIo$set = true;
                return this;
            }

            @Generated
            public PartitionBuilder diskSectorSize(RawDataLong diskSectorSize) {
                this.diskSectorSize$value = diskSectorSize;
                this.diskSectorSize$set = true;
                return this;
            }

            @Generated
            public PartitionBuilder readBytes(RawDataLong readBytes) {
                this.readBytes$value = readBytes;
                this.readBytes$set = true;
                return this;
            }

            @Generated
            public PartitionBuilder writeBytes(RawDataLong writeBytes) {
                this.writeBytes$value = writeBytes;
                this.writeBytes$set = true;
                return this;
            }

            @Generated
            public PartitionBuilder queueTimeMilliseconds(RawDataLong queueTimeMilliseconds) {
                this.queueTimeMilliseconds$value = queueTimeMilliseconds;
                this.queueTimeMilliseconds$set = true;
                return this;
            }

            @Generated
            public PartitionBuilder timeStampInSeconds(RawDataLong timeStampInSeconds) {
                this.timeStampInSeconds$value = timeStampInSeconds;
                this.timeStampInSeconds$set = true;
                return this;
            }

            @Generated
            public PartitionBuilder isNfs(boolean isNfs) {
                this.isNfs$value = isNfs;
                this.isNfs$set = true;
                return this;
            }

            @Generated
            public Partition build() {
                RawDataString name$value = this.name$value;
                if (!this.name$set) {
                    name$value = Partition.$default$name();
                }
                RawDataLong numReadsCompleted$value = this.numReadsCompleted$value;
                if (!this.numReadsCompleted$set) {
                    numReadsCompleted$value = Partition.$default$numReadsCompleted();
                }
                RawDataLong numSectorsRead$value = this.numSectorsRead$value;
                if (!this.numSectorsRead$set) {
                    numSectorsRead$value = Partition.$default$numSectorsRead();
                }
                RawDataLong numMillisecondsReading$value = this.numMillisecondsReading$value;
                if (!this.numMillisecondsReading$set) {
                    numMillisecondsReading$value = Partition.$default$numMillisecondsReading();
                }
                RawDataLong numWritesCompleted$value = this.numWritesCompleted$value;
                if (!this.numWritesCompleted$set) {
                    numWritesCompleted$value = Partition.$default$numWritesCompleted();
                }
                RawDataLong numSectorsWritten$value = this.numSectorsWritten$value;
                if (!this.numSectorsWritten$set) {
                    numSectorsWritten$value = Partition.$default$numSectorsWritten();
                }
                RawDataLong numMillisecondsWriting$value = this.numMillisecondsWriting$value;
                if (!this.numMillisecondsWriting$set) {
                    numMillisecondsWriting$value = Partition.$default$numMillisecondsWriting();
                }
                RawDataLong numMillisecondsDoingIo$value = this.numMillisecondsDoingIo$value;
                if (!this.numMillisecondsDoingIo$set) {
                    numMillisecondsDoingIo$value = Partition.$default$numMillisecondsDoingIo();
                }
                RawDataLong diskSectorSize$value = this.diskSectorSize$value;
                if (!this.diskSectorSize$set) {
                    diskSectorSize$value = Partition.$default$diskSectorSize();
                }
                RawDataLong readBytes$value = this.readBytes$value;
                if (!this.readBytes$set) {
                    readBytes$value = Partition.$default$readBytes();
                }
                RawDataLong writeBytes$value = this.writeBytes$value;
                if (!this.writeBytes$set) {
                    writeBytes$value = Partition.$default$writeBytes();
                }
                RawDataLong queueTimeMilliseconds$value = this.queueTimeMilliseconds$value;
                if (!this.queueTimeMilliseconds$set) {
                    queueTimeMilliseconds$value = Partition.$default$queueTimeMilliseconds();
                }
                RawDataLong timeStampInSeconds$value = this.timeStampInSeconds$value;
                if (!this.timeStampInSeconds$set) {
                    timeStampInSeconds$value = Partition.$default$timeStampInSeconds();
                }
                boolean isNfs$value = this.isNfs$value;
                if (!this.isNfs$set) {
                    isNfs$value = Partition.$default$isNfs();
                }
                return new Partition(name$value, numReadsCompleted$value, numSectorsRead$value, numMillisecondsReading$value, numWritesCompleted$value, numSectorsWritten$value, numMillisecondsWriting$value, numMillisecondsDoingIo$value, diskSectorSize$value, readBytes$value, writeBytes$value, queueTimeMilliseconds$value, timeStampInSeconds$value, isNfs$value);
            }

            @Generated
            public String toString() {
                return "NewLinuxRawData.Partition.PartitionBuilder(name$value=" + String.valueOf(this.name$value) + ", numReadsCompleted$value=" + String.valueOf(this.numReadsCompleted$value) + ", numSectorsRead$value=" + String.valueOf(this.numSectorsRead$value) + ", numMillisecondsReading$value=" + String.valueOf(this.numMillisecondsReading$value) + ", numWritesCompleted$value=" + String.valueOf(this.numWritesCompleted$value) + ", numSectorsWritten$value=" + String.valueOf(this.numSectorsWritten$value) + ", numMillisecondsWriting$value=" + String.valueOf(this.numMillisecondsWriting$value) + ", numMillisecondsDoingIo$value=" + String.valueOf(this.numMillisecondsDoingIo$value) + ", diskSectorSize$value=" + String.valueOf(this.diskSectorSize$value) + ", readBytes$value=" + String.valueOf(this.readBytes$value) + ", writeBytes$value=" + String.valueOf(this.writeBytes$value) + ", queueTimeMilliseconds$value=" + String.valueOf(this.queueTimeMilliseconds$value) + ", timeStampInSeconds$value=" + String.valueOf(this.timeStampInSeconds$value) + ", isNfs$value=" + this.isNfs$value + ")";
            }
        }
    }

    static class Volume {
        private RawDataString name;
        private RawDataLong totalSpace;
        private RawDataLong usedSpace;
        private RawDataLong freeSpace;

        @Generated
        private static RawDataString $default$name() {
            return RawDataConstants.ABSENT_STRING;
        }

        @Generated
        private static RawDataLong $default$totalSpace() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$usedSpace() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        private static RawDataLong $default$freeSpace() {
            return RawDataConstants.ZERO_LONG;
        }

        @Generated
        public static VolumeBuilder builder() {
            return new VolumeBuilder();
        }

        @Generated
        public RawDataString getName() {
            return this.name;
        }

        @Generated
        public RawDataLong getTotalSpace() {
            return this.totalSpace;
        }

        @Generated
        public RawDataLong getUsedSpace() {
            return this.usedSpace;
        }

        @Generated
        public RawDataLong getFreeSpace() {
            return this.freeSpace;
        }

        @Generated
        public void setName(RawDataString name) {
            this.name = name;
        }

        @Generated
        public void setTotalSpace(RawDataLong totalSpace) {
            this.totalSpace = totalSpace;
        }

        @Generated
        public void setUsedSpace(RawDataLong usedSpace) {
            this.usedSpace = usedSpace;
        }

        @Generated
        public void setFreeSpace(RawDataLong freeSpace) {
            this.freeSpace = freeSpace;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Volume)) {
                return false;
            }
            Volume other = (Volume)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RawDataString this$name = this.getName();
            RawDataString other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            RawDataLong this$totalSpace = this.getTotalSpace();
            RawDataLong other$totalSpace = other.getTotalSpace();
            if (this$totalSpace == null ? other$totalSpace != null : !this$totalSpace.equals(other$totalSpace)) {
                return false;
            }
            RawDataLong this$usedSpace = this.getUsedSpace();
            RawDataLong other$usedSpace = other.getUsedSpace();
            if (this$usedSpace == null ? other$usedSpace != null : !this$usedSpace.equals(other$usedSpace)) {
                return false;
            }
            RawDataLong this$freeSpace = this.getFreeSpace();
            RawDataLong other$freeSpace = other.getFreeSpace();
            return !(this$freeSpace == null ? other$freeSpace != null : !this$freeSpace.equals(other$freeSpace));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Volume;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RawDataString $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            RawDataLong $totalSpace = this.getTotalSpace();
            result = result * 59 + ($totalSpace == null ? 43 : $totalSpace.hashCode());
            RawDataLong $usedSpace = this.getUsedSpace();
            result = result * 59 + ($usedSpace == null ? 43 : $usedSpace.hashCode());
            RawDataLong $freeSpace = this.getFreeSpace();
            result = result * 59 + ($freeSpace == null ? 43 : $freeSpace.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NewLinuxRawData.Volume(name=" + String.valueOf(this.getName()) + ", totalSpace=" + String.valueOf(this.getTotalSpace()) + ", usedSpace=" + String.valueOf(this.getUsedSpace()) + ", freeSpace=" + String.valueOf(this.getFreeSpace()) + ")";
        }

        @Generated
        public Volume(RawDataString name, RawDataLong totalSpace, RawDataLong usedSpace, RawDataLong freeSpace) {
            this.name = name;
            this.totalSpace = totalSpace;
            this.usedSpace = usedSpace;
            this.freeSpace = freeSpace;
        }

        @Generated
        protected Volume() {
            this.name = Volume.$default$name();
            this.totalSpace = Volume.$default$totalSpace();
            this.usedSpace = Volume.$default$usedSpace();
            this.freeSpace = Volume.$default$freeSpace();
        }

        public static class VolumeBuilder {
            @Generated
            private boolean name$set;
            @Generated
            private RawDataString name$value;
            @Generated
            private boolean totalSpace$set;
            @Generated
            private RawDataLong totalSpace$value;
            @Generated
            private boolean usedSpace$set;
            @Generated
            private RawDataLong usedSpace$value;
            @Generated
            private boolean freeSpace$set;
            @Generated
            private RawDataLong freeSpace$value;
            private RawDataString name = RawDataConstants.ABSENT_STRING;
            private RawDataLong totalSpace = RawDataConstants.ZERO_LONG;
            private RawDataLong usedSpace = RawDataConstants.ZERO_LONG;
            private RawDataLong freeSpace = RawDataConstants.ZERO_LONG;

            @Generated
            VolumeBuilder() {
            }

            @Generated
            public VolumeBuilder name(RawDataString name) {
                this.name$value = name;
                this.name$set = true;
                return this;
            }

            @Generated
            public VolumeBuilder totalSpace(RawDataLong totalSpace) {
                this.totalSpace$value = totalSpace;
                this.totalSpace$set = true;
                return this;
            }

            @Generated
            public VolumeBuilder usedSpace(RawDataLong usedSpace) {
                this.usedSpace$value = usedSpace;
                this.usedSpace$set = true;
                return this;
            }

            @Generated
            public VolumeBuilder freeSpace(RawDataLong freeSpace) {
                this.freeSpace$value = freeSpace;
                this.freeSpace$set = true;
                return this;
            }

            @Generated
            public Volume build() {
                RawDataString name$value = this.name$value;
                if (!this.name$set) {
                    name$value = Volume.$default$name();
                }
                RawDataLong totalSpace$value = this.totalSpace$value;
                if (!this.totalSpace$set) {
                    totalSpace$value = Volume.$default$totalSpace();
                }
                RawDataLong usedSpace$value = this.usedSpace$value;
                if (!this.usedSpace$set) {
                    usedSpace$value = Volume.$default$usedSpace();
                }
                RawDataLong freeSpace$value = this.freeSpace$value;
                if (!this.freeSpace$set) {
                    freeSpace$value = Volume.$default$freeSpace();
                }
                return new Volume(name$value, totalSpace$value, usedSpace$value, freeSpace$value);
            }

            @Generated
            public String toString() {
                return "NewLinuxRawData.Volume.VolumeBuilder(name$value=" + String.valueOf(this.name$value) + ", totalSpace$value=" + String.valueOf(this.totalSpace$value) + ", usedSpace$value=" + String.valueOf(this.usedSpace$value) + ", freeSpace$value=" + String.valueOf(this.freeSpace$value) + ")";
            }
        }
    }

    static class ProcessRawData {
        @NonNull
        private final ProcessClassIdCreator.ProcessClass procClass;
        @NonNull
        private final Process process;

        @NonNull
        @Generated
        public ProcessClassIdCreator.ProcessClass getProcClass() {
            return this.procClass;
        }

        @NonNull
        @Generated
        public Process getProcess() {
            return this.process;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcessRawData)) {
                return false;
            }
            ProcessRawData other = (ProcessRawData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ProcessClassIdCreator.ProcessClass this$procClass = this.getProcClass();
            ProcessClassIdCreator.ProcessClass other$procClass = other.getProcClass();
            if (this$procClass == null ? other$procClass != null : !((Object)this$procClass).equals(other$procClass)) {
                return false;
            }
            Process this$process = this.getProcess();
            Process other$process = other.getProcess();
            return !(this$process == null ? other$process != null : !((Object)this$process).equals(other$process));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ProcessRawData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ProcessClassIdCreator.ProcessClass $procClass = this.getProcClass();
            result = result * 59 + ($procClass == null ? 43 : ((Object)$procClass).hashCode());
            Process $process = this.getProcess();
            result = result * 59 + ($process == null ? 43 : ((Object)$process).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NewLinuxRawData.ProcessRawData(procClass=" + String.valueOf(this.getProcClass()) + ", process=" + String.valueOf(this.getProcess()) + ")";
        }

        @Generated
        public ProcessRawData(@NonNull ProcessClassIdCreator.ProcessClass procClass, @NonNull Process process) {
            if (procClass == null) {
                throw new NullPointerException("procClass is marked non-null but is null");
            }
            if (process == null) {
                throw new NullPointerException("process is marked non-null but is null");
            }
            this.procClass = procClass;
            this.process = process;
        }
    }

    static class NetworkInfoViaProcNetDev {
        private long outgoingPackets;
        private long incomingPackets;
        private long outgoingBytes;
        private long incomingBytes;
        private long outgoingPacketErrors;
        private long incomingPacketErrors;
        private long utcTimeStamp;

        @Generated
        public static NetworkInfoViaProcNetDevBuilder builder() {
            return new NetworkInfoViaProcNetDevBuilder();
        }

        @Generated
        public long getOutgoingPackets() {
            return this.outgoingPackets;
        }

        @Generated
        public long getIncomingPackets() {
            return this.incomingPackets;
        }

        @Generated
        public long getOutgoingBytes() {
            return this.outgoingBytes;
        }

        @Generated
        public long getIncomingBytes() {
            return this.incomingBytes;
        }

        @Generated
        public long getOutgoingPacketErrors() {
            return this.outgoingPacketErrors;
        }

        @Generated
        public long getIncomingPacketErrors() {
            return this.incomingPacketErrors;
        }

        @Generated
        public long getUtcTimeStamp() {
            return this.utcTimeStamp;
        }

        @Generated
        public void setOutgoingPackets(long outgoingPackets) {
            this.outgoingPackets = outgoingPackets;
        }

        @Generated
        public void setIncomingPackets(long incomingPackets) {
            this.incomingPackets = incomingPackets;
        }

        @Generated
        public void setOutgoingBytes(long outgoingBytes) {
            this.outgoingBytes = outgoingBytes;
        }

        @Generated
        public void setIncomingBytes(long incomingBytes) {
            this.incomingBytes = incomingBytes;
        }

        @Generated
        public void setOutgoingPacketErrors(long outgoingPacketErrors) {
            this.outgoingPacketErrors = outgoingPacketErrors;
        }

        @Generated
        public void setIncomingPacketErrors(long incomingPacketErrors) {
            this.incomingPacketErrors = incomingPacketErrors;
        }

        @Generated
        public void setUtcTimeStamp(long utcTimeStamp) {
            this.utcTimeStamp = utcTimeStamp;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NetworkInfoViaProcNetDev)) {
                return false;
            }
            NetworkInfoViaProcNetDev other = (NetworkInfoViaProcNetDev)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getOutgoingPackets() != other.getOutgoingPackets()) {
                return false;
            }
            if (this.getIncomingPackets() != other.getIncomingPackets()) {
                return false;
            }
            if (this.getOutgoingBytes() != other.getOutgoingBytes()) {
                return false;
            }
            if (this.getIncomingBytes() != other.getIncomingBytes()) {
                return false;
            }
            if (this.getOutgoingPacketErrors() != other.getOutgoingPacketErrors()) {
                return false;
            }
            if (this.getIncomingPacketErrors() != other.getIncomingPacketErrors()) {
                return false;
            }
            return this.getUtcTimeStamp() == other.getUtcTimeStamp();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NetworkInfoViaProcNetDev;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $outgoingPackets = this.getOutgoingPackets();
            result = result * 59 + (int)($outgoingPackets >>> 32 ^ $outgoingPackets);
            long $incomingPackets = this.getIncomingPackets();
            result = result * 59 + (int)($incomingPackets >>> 32 ^ $incomingPackets);
            long $outgoingBytes = this.getOutgoingBytes();
            result = result * 59 + (int)($outgoingBytes >>> 32 ^ $outgoingBytes);
            long $incomingBytes = this.getIncomingBytes();
            result = result * 59 + (int)($incomingBytes >>> 32 ^ $incomingBytes);
            long $outgoingPacketErrors = this.getOutgoingPacketErrors();
            result = result * 59 + (int)($outgoingPacketErrors >>> 32 ^ $outgoingPacketErrors);
            long $incomingPacketErrors = this.getIncomingPacketErrors();
            result = result * 59 + (int)($incomingPacketErrors >>> 32 ^ $incomingPacketErrors);
            long $utcTimeStamp = this.getUtcTimeStamp();
            result = result * 59 + (int)($utcTimeStamp >>> 32 ^ $utcTimeStamp);
            return result;
        }

        @Generated
        public String toString() {
            return "NewLinuxRawData.NetworkInfoViaProcNetDev(outgoingPackets=" + this.getOutgoingPackets() + ", incomingPackets=" + this.getIncomingPackets() + ", outgoingBytes=" + this.getOutgoingBytes() + ", incomingBytes=" + this.getIncomingBytes() + ", outgoingPacketErrors=" + this.getOutgoingPacketErrors() + ", incomingPacketErrors=" + this.getIncomingPacketErrors() + ", utcTimeStamp=" + this.getUtcTimeStamp() + ")";
        }

        @Generated
        public NetworkInfoViaProcNetDev(long outgoingPackets, long incomingPackets, long outgoingBytes, long incomingBytes, long outgoingPacketErrors, long incomingPacketErrors, long utcTimeStamp) {
            this.outgoingPackets = outgoingPackets;
            this.incomingPackets = incomingPackets;
            this.outgoingBytes = outgoingBytes;
            this.incomingBytes = incomingBytes;
            this.outgoingPacketErrors = outgoingPacketErrors;
            this.incomingPacketErrors = incomingPacketErrors;
            this.utcTimeStamp = utcTimeStamp;
        }

        @Generated
        protected NetworkInfoViaProcNetDev() {
        }

        @Generated
        public static class NetworkInfoViaProcNetDevBuilder {
            @Generated
            private long outgoingPackets;
            @Generated
            private long incomingPackets;
            @Generated
            private long outgoingBytes;
            @Generated
            private long incomingBytes;
            @Generated
            private long outgoingPacketErrors;
            @Generated
            private long incomingPacketErrors;
            @Generated
            private long utcTimeStamp;

            @Generated
            NetworkInfoViaProcNetDevBuilder() {
            }

            @Generated
            public NetworkInfoViaProcNetDevBuilder outgoingPackets(long outgoingPackets) {
                this.outgoingPackets = outgoingPackets;
                return this;
            }

            @Generated
            public NetworkInfoViaProcNetDevBuilder incomingPackets(long incomingPackets) {
                this.incomingPackets = incomingPackets;
                return this;
            }

            @Generated
            public NetworkInfoViaProcNetDevBuilder outgoingBytes(long outgoingBytes) {
                this.outgoingBytes = outgoingBytes;
                return this;
            }

            @Generated
            public NetworkInfoViaProcNetDevBuilder incomingBytes(long incomingBytes) {
                this.incomingBytes = incomingBytes;
                return this;
            }

            @Generated
            public NetworkInfoViaProcNetDevBuilder outgoingPacketErrors(long outgoingPacketErrors) {
                this.outgoingPacketErrors = outgoingPacketErrors;
                return this;
            }

            @Generated
            public NetworkInfoViaProcNetDevBuilder incomingPacketErrors(long incomingPacketErrors) {
                this.incomingPacketErrors = incomingPacketErrors;
                return this;
            }

            @Generated
            public NetworkInfoViaProcNetDevBuilder utcTimeStamp(long utcTimeStamp) {
                this.utcTimeStamp = utcTimeStamp;
                return this;
            }

            @Generated
            public NetworkInfoViaProcNetDev build() {
                return new NetworkInfoViaProcNetDev(this.outgoingPackets, this.incomingPackets, this.outgoingBytes, this.incomingBytes, this.outgoingPacketErrors, this.incomingPacketErrors, this.utcTimeStamp);
            }

            @Generated
            public String toString() {
                return "NewLinuxRawData.NetworkInfoViaProcNetDev.NetworkInfoViaProcNetDevBuilder(outgoingPackets=" + this.outgoingPackets + ", incomingPackets=" + this.incomingPackets + ", outgoingBytes=" + this.outgoingBytes + ", incomingBytes=" + this.incomingBytes + ", outgoingPacketErrors=" + this.outgoingPacketErrors + ", incomingPacketErrors=" + this.incomingPacketErrors + ", utcTimeStamp=" + this.utcTimeStamp + ")";
            }
        }
    }

    static class NetworkInfoViaIpAddr {
        @NonNull
        private String ipv4;
        @NonNull
        private String ipv6;

        @Generated
        public static NetworkInfoViaIpAddrBuilder builder() {
            return new NetworkInfoViaIpAddrBuilder();
        }

        @NonNull
        @Generated
        public String getIpv4() {
            return this.ipv4;
        }

        @NonNull
        @Generated
        public String getIpv6() {
            return this.ipv6;
        }

        @Generated
        public void setIpv4(@NonNull String ipv4) {
            if (ipv4 == null) {
                throw new NullPointerException("ipv4 is marked non-null but is null");
            }
            this.ipv4 = ipv4;
        }

        @Generated
        public void setIpv6(@NonNull String ipv6) {
            if (ipv6 == null) {
                throw new NullPointerException("ipv6 is marked non-null but is null");
            }
            this.ipv6 = ipv6;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NetworkInfoViaIpAddr)) {
                return false;
            }
            NetworkInfoViaIpAddr other = (NetworkInfoViaIpAddr)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$ipv4 = this.getIpv4();
            String other$ipv4 = other.getIpv4();
            if (this$ipv4 == null ? other$ipv4 != null : !this$ipv4.equals(other$ipv4)) {
                return false;
            }
            String this$ipv6 = this.getIpv6();
            String other$ipv6 = other.getIpv6();
            return !(this$ipv6 == null ? other$ipv6 != null : !this$ipv6.equals(other$ipv6));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NetworkInfoViaIpAddr;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $ipv4 = this.getIpv4();
            result = result * 59 + ($ipv4 == null ? 43 : $ipv4.hashCode());
            String $ipv6 = this.getIpv6();
            result = result * 59 + ($ipv6 == null ? 43 : $ipv6.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NewLinuxRawData.NetworkInfoViaIpAddr(ipv4=" + this.getIpv4() + ", ipv6=" + this.getIpv6() + ")";
        }

        @Generated
        public NetworkInfoViaIpAddr(@NonNull String ipv4, @NonNull String ipv6) {
            if (ipv4 == null) {
                throw new NullPointerException("ipv4 is marked non-null but is null");
            }
            if (ipv6 == null) {
                throw new NullPointerException("ipv6 is marked non-null but is null");
            }
            this.ipv4 = ipv4;
            this.ipv6 = ipv6;
        }

        @Generated
        protected NetworkInfoViaIpAddr() {
        }

        @Generated
        public static class NetworkInfoViaIpAddrBuilder {
            @Generated
            private String ipv4;
            @Generated
            private String ipv6;

            @Generated
            NetworkInfoViaIpAddrBuilder() {
            }

            @Generated
            public NetworkInfoViaIpAddrBuilder ipv4(@NonNull String ipv4) {
                if (ipv4 == null) {
                    throw new NullPointerException("ipv4 is marked non-null but is null");
                }
                this.ipv4 = ipv4;
                return this;
            }

            @Generated
            public NetworkInfoViaIpAddrBuilder ipv6(@NonNull String ipv6) {
                if (ipv6 == null) {
                    throw new NullPointerException("ipv6 is marked non-null but is null");
                }
                this.ipv6 = ipv6;
                return this;
            }

            @Generated
            public NetworkInfoViaIpAddr build() {
                return new NetworkInfoViaIpAddr(this.ipv4, this.ipv6);
            }

            @Generated
            public String toString() {
                return "NewLinuxRawData.NetworkInfoViaIpAddr.NetworkInfoViaIpAddrBuilder(ipv4=" + this.ipv4 + ", ipv6=" + this.ipv6 + ")";
            }
        }
    }

    static class NetworkInfoViaSysClassNet {
        @NonNull
        private String address;
        private long carrier;
        @NonNull
        private String duplex;
        @NonNull
        private String flags;
        private long mtu;
        @NonNull
        private String operstate;
        private long speed;

        @Generated
        public static NetworkInfoViaSysClassNetBuilder builder() {
            return new NetworkInfoViaSysClassNetBuilder();
        }

        @NonNull
        @Generated
        public String getAddress() {
            return this.address;
        }

        @Generated
        public long getCarrier() {
            return this.carrier;
        }

        @NonNull
        @Generated
        public String getDuplex() {
            return this.duplex;
        }

        @NonNull
        @Generated
        public String getFlags() {
            return this.flags;
        }

        @Generated
        public long getMtu() {
            return this.mtu;
        }

        @NonNull
        @Generated
        public String getOperstate() {
            return this.operstate;
        }

        @Generated
        public long getSpeed() {
            return this.speed;
        }

        @Generated
        public void setAddress(@NonNull String address) {
            if (address == null) {
                throw new NullPointerException("address is marked non-null but is null");
            }
            this.address = address;
        }

        @Generated
        public void setCarrier(long carrier) {
            this.carrier = carrier;
        }

        @Generated
        public void setDuplex(@NonNull String duplex) {
            if (duplex == null) {
                throw new NullPointerException("duplex is marked non-null but is null");
            }
            this.duplex = duplex;
        }

        @Generated
        public void setFlags(@NonNull String flags) {
            if (flags == null) {
                throw new NullPointerException("flags is marked non-null but is null");
            }
            this.flags = flags;
        }

        @Generated
        public void setMtu(long mtu) {
            this.mtu = mtu;
        }

        @Generated
        public void setOperstate(@NonNull String operstate) {
            if (operstate == null) {
                throw new NullPointerException("operstate is marked non-null but is null");
            }
            this.operstate = operstate;
        }

        @Generated
        public void setSpeed(long speed) {
            this.speed = speed;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NetworkInfoViaSysClassNet)) {
                return false;
            }
            NetworkInfoViaSysClassNet other = (NetworkInfoViaSysClassNet)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCarrier() != other.getCarrier()) {
                return false;
            }
            if (this.getMtu() != other.getMtu()) {
                return false;
            }
            if (this.getSpeed() != other.getSpeed()) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$duplex = this.getDuplex();
            String other$duplex = other.getDuplex();
            if (this$duplex == null ? other$duplex != null : !this$duplex.equals(other$duplex)) {
                return false;
            }
            String this$flags = this.getFlags();
            String other$flags = other.getFlags();
            if (this$flags == null ? other$flags != null : !this$flags.equals(other$flags)) {
                return false;
            }
            String this$operstate = this.getOperstate();
            String other$operstate = other.getOperstate();
            return !(this$operstate == null ? other$operstate != null : !this$operstate.equals(other$operstate));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NetworkInfoViaSysClassNet;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $carrier = this.getCarrier();
            result = result * 59 + (int)($carrier >>> 32 ^ $carrier);
            long $mtu = this.getMtu();
            result = result * 59 + (int)($mtu >>> 32 ^ $mtu);
            long $speed = this.getSpeed();
            result = result * 59 + (int)($speed >>> 32 ^ $speed);
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $duplex = this.getDuplex();
            result = result * 59 + ($duplex == null ? 43 : $duplex.hashCode());
            String $flags = this.getFlags();
            result = result * 59 + ($flags == null ? 43 : $flags.hashCode());
            String $operstate = this.getOperstate();
            result = result * 59 + ($operstate == null ? 43 : $operstate.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NewLinuxRawData.NetworkInfoViaSysClassNet(address=" + this.getAddress() + ", carrier=" + this.getCarrier() + ", duplex=" + this.getDuplex() + ", flags=" + this.getFlags() + ", mtu=" + this.getMtu() + ", operstate=" + this.getOperstate() + ", speed=" + this.getSpeed() + ")";
        }

        @Generated
        public NetworkInfoViaSysClassNet(@NonNull String address, long carrier, @NonNull String duplex, @NonNull String flags, long mtu, @NonNull String operstate, long speed) {
            if (address == null) {
                throw new NullPointerException("address is marked non-null but is null");
            }
            if (duplex == null) {
                throw new NullPointerException("duplex is marked non-null but is null");
            }
            if (flags == null) {
                throw new NullPointerException("flags is marked non-null but is null");
            }
            if (operstate == null) {
                throw new NullPointerException("operstate is marked non-null but is null");
            }
            this.address = address;
            this.carrier = carrier;
            this.duplex = duplex;
            this.flags = flags;
            this.mtu = mtu;
            this.operstate = operstate;
            this.speed = speed;
        }

        @Generated
        protected NetworkInfoViaSysClassNet() {
        }

        @Generated
        public static class NetworkInfoViaSysClassNetBuilder {
            @Generated
            private String address;
            @Generated
            private long carrier;
            @Generated
            private String duplex;
            @Generated
            private String flags;
            @Generated
            private long mtu;
            @Generated
            private String operstate;
            @Generated
            private long speed;

            @Generated
            NetworkInfoViaSysClassNetBuilder() {
            }

            @Generated
            public NetworkInfoViaSysClassNetBuilder address(@NonNull String address) {
                if (address == null) {
                    throw new NullPointerException("address is marked non-null but is null");
                }
                this.address = address;
                return this;
            }

            @Generated
            public NetworkInfoViaSysClassNetBuilder carrier(long carrier) {
                this.carrier = carrier;
                return this;
            }

            @Generated
            public NetworkInfoViaSysClassNetBuilder duplex(@NonNull String duplex) {
                if (duplex == null) {
                    throw new NullPointerException("duplex is marked non-null but is null");
                }
                this.duplex = duplex;
                return this;
            }

            @Generated
            public NetworkInfoViaSysClassNetBuilder flags(@NonNull String flags) {
                if (flags == null) {
                    throw new NullPointerException("flags is marked non-null but is null");
                }
                this.flags = flags;
                return this;
            }

            @Generated
            public NetworkInfoViaSysClassNetBuilder mtu(long mtu) {
                this.mtu = mtu;
                return this;
            }

            @Generated
            public NetworkInfoViaSysClassNetBuilder operstate(@NonNull String operstate) {
                if (operstate == null) {
                    throw new NullPointerException("operstate is marked non-null but is null");
                }
                this.operstate = operstate;
                return this;
            }

            @Generated
            public NetworkInfoViaSysClassNetBuilder speed(long speed) {
                this.speed = speed;
                return this;
            }

            @Generated
            public NetworkInfoViaSysClassNet build() {
                return new NetworkInfoViaSysClassNet(this.address, this.carrier, this.duplex, this.flags, this.mtu, this.operstate, this.speed);
            }

            @Generated
            public String toString() {
                return "NewLinuxRawData.NetworkInfoViaSysClassNet.NetworkInfoViaSysClassNetBuilder(address=" + this.address + ", carrier=" + this.carrier + ", duplex=" + this.duplex + ", flags=" + this.flags + ", mtu=" + this.mtu + ", operstate=" + this.operstate + ", speed=" + this.speed + ")";
            }
        }
    }
}

