/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.newlinux;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.EnvironmentVars;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.collector.RawCollectorUtil;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentName;
import com.appdynamics.sim.agent.extensions.servers.model.ProcessClassIdCreator;
import com.appdynamics.sim.agent.extensions.servers.model.RawCollector;
import com.appdynamics.sim.agent.extensions.servers.model.newlinux.NewLinuxRawData;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewLinuxRawCollector
implements RawCollector<NewLinuxRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewLinuxRawCollector.class);
    private static final String RUN_COLLECTOR = "run_collector";
    private static final NewLinuxRawData EMPTY_RAW_DATA = new NewLinuxRawData();
    public static final String MEMORY_PRE_CALCULATED = "memory.pre.calculated";
    private final ObjectMapper objectMapper;
    private final ProcessClassIdCreator processClassIdCreator;
    private final Optional<RawCollectorUtil.ICollectorProcessBuilder> processBuilder;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final Supplier<Map<String, String>> envVarsSupplier;
    private final RawCollectorUtil rawCollectorUtil;
    private final BootstrapConfiguration bootstrapConfiguration;
    private final RawDataFactory factory;

    @Inject
    NewLinuxRawCollector(@Sim ObjectMapper objectMapper, @NonNull BootstrapConfiguration bootstrapConfiguration, ProcessClassIdCreator processClassIdCreator, Optional<RawCollectorUtil.ICollectorProcessBuilder> collectorProcessBuilder, SimAgentRepetitiveLogger repetitiveLogger, @EnvironmentVars Supplier<Map<String, String>> envVarsSupplier, RawCollectorUtil rawCollectorUtil, RawDataFactory factory) throws IOException {
        if (bootstrapConfiguration == null) {
            throw new NullPointerException("bootstrapConfiguration is marked non-null but is null");
        }
        this.objectMapper = objectMapper;
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.processBuilder = collectorProcessBuilder;
        this.processClassIdCreator = processClassIdCreator;
        this.repetitiveLogger = repetitiveLogger;
        this.envVarsSupplier = envVarsSupplier;
        this.rawCollectorUtil = rawCollectorUtil;
        this.factory = factory;
    }

    @Override
    public NewLinuxRawData collectRawData(Set<String> componentsToCollect, long maxCollectionTimeMillis) {
        Optional<NewLinuxRawData> rawDataOpt = Optional.absent();
        if (!this.processBuilder.isPresent()) {
            this.repetitiveLogger.error(log, "Process to collect raw data is not present - skipping collection", new Object[0]);
        } else if (componentsToCollect.isEmpty()) {
            this.repetitiveLogger.debug(log, "No components to be collected - skipping collection", new Object[0]);
        } else {
            Set<String> expandedComponentsToCollect = this.getExpandedComponentsToCollect(componentsToCollect);
            this.repetitiveLogger.debug(log, "Collecting components - {}", new Object[]{expandedComponentsToCollect});
            log.trace("Collecting components - {}", expandedComponentsToCollect);
            ArrayList collectorArguments = Lists.newArrayList();
            collectorArguments.add(RUN_COLLECTOR);
            collectorArguments.addAll(expandedComponentsToCollect);
            rawDataOpt = this.rawCollectorUtil.runCollector(NewLinuxRawData.class, (RawCollectorUtil.ICollectorProcessBuilder)this.processBuilder.get(), this.objectMapper, (Optional<List<String>>)Optional.of((Object)collectorArguments), (Map)this.envVarsSupplier.get(), maxCollectionTimeMillis);
        }
        NewLinuxRawData rawData = (NewLinuxRawData)rawDataOpt.or((Object)EMPTY_RAW_DATA);
        this.preProcess(rawData);
        return rawData;
    }

    private void preProcess(NewLinuxRawData rawData) {
        try {
            this.preProcessAndSetCpus(rawData);
            this.preProcessCpuPerfs(rawData);
            this.preProcessPartitions(rawData);
            this.preProcessNfsPartitions(rawData);
            this.preProcessProcesses(rawData);
        }
        catch (Exception e) {
            this.repetitiveLogger.warn(log, "Caught exception during pre-processing: " + String.valueOf(e), new Object[0]);
        }
    }

    @VisibleForTesting
    void preProcessAndSetCpus(NewLinuxRawData rawData) {
        HashMap<String, NewLinuxRawData.Cpu> cpus = new HashMap<String, NewLinuxRawData.Cpu>();
        Map<String, NewLinuxRawData.Processor> processors = rawData.getProcessors();
        rawData.setTotalNumLogicalProcessors(processors.size());
        HashBasedTable cpuCoreLogicalTable = HashBasedTable.create();
        for (NewLinuxRawData.Processor processor : processors.values()) {
            Set<NewLinuxRawData.Processor> processorIdSet;
            String coreId;
            String cpuId = processor.getPhysicalId();
            if (cpuCoreLogicalTable.contains((Object)cpuId, (Object)(coreId = processor.getCoreId()))) {
                processorIdSet = (Set)cpuCoreLogicalTable.get((Object)cpuId, (Object)coreId);
            } else {
                processorIdSet = new HashSet();
                cpuCoreLogicalTable.put((Object)cpuId, (Object)coreId, processorIdSet);
            }
            processorIdSet.add(processor);
        }
        for (String cpuId : cpuCoreLogicalTable.rowKeySet()) {
            try {
                Map coresToProcessors = cpuCoreLogicalTable.row((Object)cpuId);
                int numPhysicalCoresForThisCpu = coresToProcessors.keySet().size();
                int numLogicalProcessorsForThisCpu = 0;
                double totalCurrentSpeeds = 0.0;
                RawDataString vendor = this.factory.createString(Optional.absent());
                RawDataString model = this.factory.createString(Optional.absent());
                RawDataString flags = this.factory.createString(Optional.absent());
                boolean firstOne = true;
                for (Set processorSet : coresToProcessors.values()) {
                    numLogicalProcessorsForThisCpu += processorSet.size();
                    for (NewLinuxRawData.Processor processor : processorSet) {
                        if (firstOne) {
                            vendor = processor.getVendor();
                            model = processor.getModel();
                            flags = this.factory.createString(Optional.of((Object)processor.getFlags().get().substring(0, Math.min(1023, processor.getFlags().get().length()))));
                            firstOne = false;
                        }
                        totalCurrentSpeeds += processor.getSpeedMhz();
                    }
                }
                RawDataLong numPhysicalCoresForThisCpuItem = this.factory.createLong(Long.valueOf(numPhysicalCoresForThisCpu));
                RawDataLong numLogicalProcessorsForThisCpuItem = this.factory.createLong(Long.valueOf(numLogicalProcessorsForThisCpu));
                double avgSpeed = numLogicalProcessorsForThisCpu == 0 ? 0.0 : totalCurrentSpeeds / (double)numLogicalProcessorsForThisCpu;
                RawDataString avgSpeedItem = this.factory.createString(Optional.of((Object)Double.toString(avgSpeed)));
                NewLinuxRawData.Cpu cpu = NewLinuxRawData.Cpu.builder().id(cpuId).vendor(vendor).model(model).flags(flags).speedMhz(avgSpeedItem).coreCount(numPhysicalCoresForThisCpuItem).logicalProcessorCount(numLogicalProcessorsForThisCpuItem).build();
                cpus.put(cpuId, cpu);
            }
            catch (Exception e) {
                this.repetitiveLogger.warn(log, "Caught exception when pre-processing cpu with id {}. The cpu will be removed from collected data. " + String.valueOf(e), new Object[]{cpuId});
            }
        }
        rawData.setCpus(cpus);
    }

    @VisibleForTesting
    void preProcessCpuPerfs(NewLinuxRawData rawData) {
        try {
            if (!rawData.getCpuPerfs().isEmpty()) {
                NewLinuxRawData.CpuPerf cpuPerf = rawData.getCpuPerfs().values().iterator().next();
                long totalTicks = cpuPerf.getUserTicks() + cpuPerf.getNiceTicks() + cpuPerf.getSystemTicks() + cpuPerf.getIdleTicks() + cpuPerf.getWaitTicks() + cpuPerf.getIrqTicks() + cpuPerf.getSoftIrqTicks() + cpuPerf.getStolenTicks();
                cpuPerf.setTotalTicks(totalTicks);
            }
        }
        catch (Exception e) {
            this.repetitiveLogger.warn(log, "Caught exception when pre-processing cpu performance. " + String.valueOf(e), new Object[0]);
        }
    }

    @VisibleForTesting
    void preProcessProcesses(NewLinuxRawData rawData) {
        ArrayListMultimap procData = ArrayListMultimap.create();
        for (Map.Entry<String, NewLinuxRawData.Process> processEntry : rawData.getProcesses().entrySet()) {
            try {
                NewLinuxRawData.Process process = processEntry.getValue();
                ProcessClassIdCreator.ProcessClass processClass = this.processClassIdCreator.extractClass(process.getCommandLine().get(), process.getName().get());
                procData.put((Object)processClass.getProcessClassId(), (Object)new NewLinuxRawData.ProcessRawData(processClass, process));
            }
            catch (Exception e) {
                this.repetitiveLogger.warn(log, "Caught exception when pre-processing process with id {}. The process will be removed from collected data. " + String.valueOf(e), new Object[]{processEntry.getKey()});
            }
        }
        rawData.setProcData((ListMultimap<String, NewLinuxRawData.ProcessRawData>)procData);
    }

    @VisibleForTesting
    void preProcessPartitions(NewLinuxRawData rawData) {
        HashMap<String, NewLinuxRawData.Partition> partitions = new HashMap<String, NewLinuxRawData.Partition>();
        Map<String, NewLinuxRawData.Partition> unprocessedPartitions = rawData.getPartitions();
        Map<String, NewLinuxRawData.Volume> unProcessedVolumes = rawData.getVolumes();
        HashMap<String, NewLinuxRawData.Volume> volumes = new HashMap<String, NewLinuxRawData.Volume>();
        Map<String, Long> unProcessedDiskSectorSizes = rawData.getDiskSectorSizes();
        HashMap<String, Long> diskSectorSizes = new HashMap<String, Long>();
        for (String string : unProcessedDiskSectorSizes.keySet()) {
            String sectorName = string.replaceAll("\\||-|`", "");
            diskSectorSizes.put(sectorName, unProcessedDiskSectorSizes.get(string));
        }
        for (Map.Entry entry : unProcessedVolumes.entrySet()) {
            String key = (String)entry.getKey();
            if (key == null) continue;
            if (key.equals(this.bootstrapConfiguration.getBindMountOfHostRoot())) {
                key = "/";
            } else if (key.startsWith(this.bootstrapConfiguration.getBindMountOfHostRoot())) {
                key = key.substring(this.bootstrapConfiguration.getBindMountOfHostRoot().length());
            }
            volumes.put(key, (NewLinuxRawData.Volume)entry.getValue());
        }
        rawData.setVolumes(volumes);
        for (NewLinuxRawData.Volume volume : volumes.values()) {
            RawDataString volumePartitionNameRaw = volume.getName();
            if (!volumePartitionNameRaw.isPresent()) continue;
            String volumePartitionName = volumePartitionNameRaw.get();
            for (String partitionName : unprocessedPartitions.keySet()) {
                try {
                    if (!volumePartitionName.endsWith(partitionName)) continue;
                    NewLinuxRawData.Partition partition = unprocessedPartitions.get(partitionName);
                    partition.setName(this.factory.createString(Optional.of((Object)volumePartitionName)));
                    Long diskSectorSize = (Long)diskSectorSizes.get(partitionName);
                    if (diskSectorSize != null) {
                        partition.setDiskSectorSize(this.factory.createLong(diskSectorSize));
                    }
                    partitions.put(volumePartitionName, partition);
                }
                catch (Exception e) {
                    this.repetitiveLogger.warn(log, "Caught exception when pre-processing partition with name {}. The partition will be removed from collected data. " + String.valueOf(e), new Object[]{partitionName});
                }
            }
        }
        rawData.setPartitions(partitions);
    }

    @VisibleForTesting
    void preProcessNfsPartitions(NewLinuxRawData rawData) {
        if (rawData.getNfsPartitions().isEmpty()) {
            return;
        }
        HashMap<String, NewLinuxRawData.Partition> partitions = new HashMap<String, NewLinuxRawData.Partition>();
        partitions.putAll(rawData.getPartitions());
        for (Map.Entry<String, NewLinuxRawData.NfsPartition> nfsPartitionEntry : rawData.getNfsPartitions().entrySet()) {
            try {
                NewLinuxRawData.NfsPartition nfsPartition = nfsPartitionEntry.getValue();
                NewLinuxRawData.Partition partition = NewLinuxRawData.Partition.builder().name(nfsPartition.getName()).numReadsCompleted(nfsPartition.getNumReads()).numWritesCompleted(nfsPartition.getNumWrites()).readBytes(nfsPartition.getReadBytes()).writeBytes(nfsPartition.getWriteBytes()).numMillisecondsReading(nfsPartition.getReadTimeMilliseconds()).numMillisecondsWriting(nfsPartition.getWriteTimeMilliseconds()).queueTimeMilliseconds(nfsPartition.getQueueTimeMilliseconds()).isNfs(true).timeStampInSeconds(nfsPartition.getTimeStampInSeconds()).build();
                partitions.put(nfsPartition.getName().get(), partition);
            }
            catch (Exception e) {
                this.repetitiveLogger.warn(log, "Caught exception when pre-processing NFS partition with id {}. The NFS partition will be removed from collected data. " + String.valueOf(e), new Object[]{nfsPartitionEntry.getKey()});
            }
        }
        rawData.setPartitions(partitions);
    }

    private Set<String> getExpandedComponentsToCollect(Set<String> componentsToCollect) {
        ImmutableSet.Builder expandedComponentsToCollectBuilder = ImmutableSet.builder();
        expandedComponentsToCollectBuilder.addAll(componentsToCollect);
        if (componentsToCollect.contains(ComponentName.MONITORED_PROCESS_CLASSES.toString())) {
            expandedComponentsToCollectBuilder.add((Object)ComponentName.CPUS.toString());
        }
        if (componentsToCollect.contains(ComponentName.MEMORY.toString())) {
            expandedComponentsToCollectBuilder.add((Object)MEMORY_PRE_CALCULATED);
        }
        return expandedComponentsToCollectBuilder.build();
    }
}

