/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.newlinux;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.OperatingSystem;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.newlinux.NewLinuxRawData;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import lombok.Generated;

@VisibleForAssistedInject
public class NewLinuxOperatingSystem
extends OperatingSystem<NewLinuxRawData> {
    private NewLinuxRawData.OperatingSystem operatingSystem;
    protected static final String UNKNOWN = "unknown";

    @Inject
    private NewLinuxOperatingSystem(@Sim MachineProperties machineProperties, Predicate<ToggleableReporter<NewLinuxRawData>> isDisabledPredicate, RawDataFactory rawDataFactory) {
        super("Linux", machineProperties, isDisabledPredicate, rawDataFactory);
    }

    @Override
    public void update(NewLinuxRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.operatingSystem = rawData.getOperatingSystem();
    }

    @Override
    public void report(NewLinuxRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        super.report(rawData, reportMetricsConfig);
        if (reportMetricsConfig.isReportSimMetrics()) {
            RawDataString bios = this.operatingSystem.getBios();
            this.machineProperties.updateProperty("Bios|Version", bios, Optional.of((Object)UNKNOWN));
        }
    }

    @Override
    protected RawDataString getOsName() {
        return this.operatingSystem.getName();
    }

    @Override
    protected RawDataString getRelease() {
        return this.operatingSystem.getRelease();
    }

    @Override
    protected RawDataString getArchitecture() {
        return this.operatingSystem.getArchitecture();
    }

    @Override
    @Generated
    public String toString() {
        return "NewLinuxOperatingSystem(super=" + super.toString() + ", operatingSystem=" + String.valueOf(this.operatingSystem) + ")";
    }
}

