/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.newlinux;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentFactory;
import com.appdynamics.sim.agent.extensions.servers.model.Network;
import com.appdynamics.sim.agent.extensions.servers.model.Networks;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.filter.Filters;
import com.appdynamics.sim.agent.extensions.servers.model.newlinux.NewLinuxNetworksUtil;
import com.appdynamics.sim.agent.extensions.servers.model.newlinux.NewLinuxRawData;
import com.appdynamics.sim.agent.extensions.servers.model.transformer.Transformer;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

@VisibleForAssistedInject
public class NewLinuxNetworks
extends Networks<NewLinuxRawData> {
    @Inject
    protected NewLinuxNetworks(@NonNull MetricsService metricsService, @NonNull MachineProperties machineProperties, @NonNull SimAgentRepetitiveLogger repetitiveLogger, @NonNull ComponentFactory<NewLinuxRawData, Network<NewLinuxRawData>> networkFactory, @NonNull Filters<Network<NewLinuxRawData>> filters, @NonNull Set<Transformer<Network<NewLinuxRawData>>> metadataTransformers, @NonNull Predicate<ToggleableReporter<NewLinuxRawData>> isDisabledPredicate) {
        super(metricsService, machineProperties, repetitiveLogger, networkFactory, filters, metadataTransformers, isDisabledPredicate);
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (repetitiveLogger == null) {
            throw new NullPointerException("repetitiveLogger is marked non-null but is null");
        }
        if (networkFactory == null) {
            throw new NullPointerException("networkFactory is marked non-null but is null");
        }
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (metadataTransformers == null) {
            throw new NullPointerException("metadataTransformers is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
    }

    @Override
    protected Set<String> extractIds(NewLinuxRawData rawData) {
        LinkedHashSet<String> ids = new LinkedHashSet<String>(rawData.getNetworkToIpAddr().keySet());
        ids.retainAll(rawData.getNetworkToProcNetDev().keySet());
        ids.retainAll(this.getNonLoopbackInterfaces(rawData).keySet());
        return Collections.unmodifiableSet(ids);
    }

    @VisibleForTesting
    Map<String, NewLinuxRawData.NetworkInfoViaSysClassNet> getNonLoopbackInterfaces(NewLinuxRawData rawData) {
        HashMap<String, NewLinuxRawData.NetworkInfoViaSysClassNet> nonLoopbackInterfaces = new HashMap<String, NewLinuxRawData.NetworkInfoViaSysClassNet>();
        for (Map.Entry<String, NewLinuxRawData.NetworkInfoViaSysClassNet> entry : rawData.getNetworkToSysClassNet().entrySet()) {
            if (NewLinuxNetworksUtil.isLoopbackInterface(entry.getValue().getFlags())) continue;
            nonLoopbackInterfaces.put(entry.getKey(), entry.getValue());
        }
        return nonLoopbackInterfaces;
    }

    @Override
    @Generated
    public String toString() {
        return "NewLinuxNetworks(super=" + super.toString() + ")";
    }
}

