/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.newlinux;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataConstants;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItemUtil;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.ProcessProperties;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.model.MonitoredProcessClass;
import com.appdynamics.sim.agent.extensions.servers.model.newlinux.NewLinuxGpuMetricsProvider;
import com.appdynamics.sim.agent.extensions.servers.model.newlinux.NewLinuxRawData;
import com.appdynamics.sim.agent.extensions.servers.util.NixProcessStateUtil;
import com.appdynamics.sim.agent.extensions.servers.util.NixRawDataProcessClassSummingCalculator;
import com.appdynamics.sim.agent.extensions.servers.util.NixUtils;
import com.appdynamics.sim.agent.extensions.servers.util.Pair;
import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import com.appdynamics.sim.processes.common.rest.SimProcessDtoState;
import com.appdynamics.sim.processes.common.rest.SimProcessObservationDto;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForAssistedInject
public class NewLinuxMonitoredProcessClass
extends MonitoredProcessClass<NewLinuxRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewLinuxMonitoredProcessClass.class);
    private static final String UNKNOWN_VALUE = "Unknown";
    private static final String NO_GPU_METRIC = "-";
    private static final String ZERO_METRIC = "0";
    private RawDataLong memoryUsedKb;
    private RawDataLong memoryUsedPercent;
    private RawDataLong numThreads;
    private RawDataLong virtualMemoryKb;
    private RawDataLong processCount;
    private RawDataLong numProcessors;
    private RawDataLong gpuUsedPercent;
    private RawDataLong gpuMemoryUsedPercent;
    private final NixProcessStateUtil procStateUtil;
    private final NixRawDataProcessClassSummingCalculator cpuUsedPercent;
    private final NixRawDataProcessClassSummingCalculator majorFaultsRate;
    private final NixRawDataProcessClassSummingCalculator minorFaultsRate;
    private final RawDataFactory factory;
    private final RawDataItemUtil rawDataItemUtil;
    private final MetricsService metricsService;
    private volatile Map<RawDataLong, Pair<RawDataLong, Double>> currentProcessCpuMetrics = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
    private volatile Map<RawDataLong, Pair<RawDataLong, Double>> currentProcessMemoryMetrics = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
    private volatile Map<RawDataLong, SimProcessDtoState> currentProcessStateMetrics = new HashMap<RawDataLong, SimProcessDtoState>();
    private Map<RawDataLong, Pair<Long, Long>> pidToCpuTimeAndEpochTime = new HashMap<RawDataLong, Pair<Long, Long>>();
    private Map<RawDataLong, String> currentProcessCommandLineMap = new HashMap<RawDataLong, String>();
    private final NewLinuxGpuMetricsProvider gpuMetricsProvider;

    @Inject
    NewLinuxMonitoredProcessClass(@Assisted @NonNull String classId, @NonNull MetricsService metricsService, @NonNull Provider<ServersMonitorConfig> serversMonitorConfig, @NonNull NixProcessStateUtil procStateUtil, @NonNull ProcessProperties processProperties, SimAgentRepetitiveLogger repetitiveLogger, RawDataFactory factory, RawDataItemUtil rawDataItemUtil, BootstrapConfiguration bootstrapConfiguration, NewLinuxGpuMetricsProvider gpuMetricsProvider) {
        super(classId, metricsService, serversMonitorConfig, processProperties, repetitiveLogger, factory);
        if (classId == null) {
            throw new NullPointerException("classId is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (serversMonitorConfig == null) {
            throw new NullPointerException("serversMonitorConfig is marked non-null but is null");
        }
        if (procStateUtil == null) {
            throw new NullPointerException("procStateUtil is marked non-null but is null");
        }
        if (processProperties == null) {
            throw new NullPointerException("processProperties is marked non-null but is null");
        }
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.factory = factory;
        this.rawDataItemUtil = rawDataItemUtil;
        this.procStateUtil = procStateUtil;
        this.cpuUsedPercent = new NixRawDataProcessClassSummingCalculator(factory, NixRawDataProcessClassSummingCalculator.CPU_USAGE_CALC);
        this.majorFaultsRate = new NixRawDataProcessClassSummingCalculator(factory, NixRawDataProcessClassSummingCalculator.RATE_CALC);
        this.minorFaultsRate = new NixRawDataProcessClassSummingCalculator(factory, NixRawDataProcessClassSummingCalculator.RATE_CALC);
        this.metricsService = metricsService;
        this.gpuMetricsProvider = gpuMetricsProvider;
    }

    @Override
    protected void updateMetrics(NewLinuxRawData rawData, List<SimProcessObservationDto> filteredObservations) {
        this.numProcessors = this.factory.createLong(Long.valueOf(rawData.getTotalNumLogicalProcessors()));
        List allProcsData = rawData.getProcData().get((Object)this.getClassId());
        if (allProcsData.isEmpty()) {
            return;
        }
        ImmutableSet.Builder filteredProcessIdSetBuilder = new ImmutableSet.Builder();
        for (SimProcessObservationDto simProcessObservationDto : filteredObservations) {
            filteredProcessIdSetBuilder.add((Object)this.factory.createLong(Long.valueOf(simProcessObservationDto.getProcessId())));
        }
        ImmutableSet filteredProcessIdSet = filteredProcessIdSetBuilder.build();
        ImmutableMap.Builder pidToCpuTimeMapBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder pidToMajorFaultMapBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder pidToMinorFaultMapBuilder = new ImmutableMap.Builder();
        this.memoryUsedKb = RawDataConstants.ZERO_LONG;
        this.numThreads = RawDataConstants.ZERO_LONG;
        this.virtualMemoryKb = RawDataConstants.ZERO_LONG;
        double memoryUsedPercentDbl = 0.0;
        boolean hasGpuData = false;
        double gpuUsedPercentDbl = 0.0;
        double gpuMemoryUsedPercentDbl = 0.0;
        for (NewLinuxRawData.ProcessRawData procData : allProcsData) {
            long cpuTimeInSeconds = 0L;
            NewLinuxRawData.Process process = procData.getProcess();
            RawDataLong processId = procData.getProcess().getPid();
            try {
                cpuTimeInSeconds = TimeUnit.MILLISECONDS.toSeconds(NixUtils.getTimeInMilis(process.getCpuTime().get()));
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                this.repetitiveLogger.warn(log, ex.getMessage(), new Object[0]);
            }
            RawDataLong majorFaults = process.getMajorFault();
            RawDataLong minorFaults = process.getMinorFault();
            if (processId.isPresent() && filteredProcessIdSet.contains((Object)processId)) {
                this.memoryUsedKb = this.memoryUsedKb.add(process.getMemoryUsedKb());
                this.numThreads = this.numThreads.add(process.getThreadCount());
                this.virtualMemoryKb = this.virtualMemoryKb.add(process.getVirtualMemSizeKb());
                try {
                    double d = Double.parseDouble(process.getMemoryPercent().get());
                    memoryUsedPercentDbl += d;
                }
                catch (IllegalStateException | NumberFormatException d) {
                    // empty catch block
                }
                String gpuUtil = process.getGpuUtilization().or(NO_GPU_METRIC);
                String gpuMemUtil = process.getGpuMemoryUtilization().or(NO_GPU_METRIC);
                if (!NO_GPU_METRIC.equals(gpuUtil) || !NO_GPU_METRIC.equals(gpuMemUtil)) {
                    hasGpuData = true;
                    try {
                        gpuUsedPercentDbl += Double.parseDouble(NO_GPU_METRIC.equals(gpuUtil) ? ZERO_METRIC : gpuUtil);
                        gpuMemoryUsedPercentDbl += Double.parseDouble(NO_GPU_METRIC.equals(gpuMemUtil) ? ZERO_METRIC : gpuMemUtil);
                    }
                    catch (NumberFormatException e) {
                        this.repetitiveLogger.warn(log, "Error parsing GPU metrics for process " + String.valueOf(processId) + ": " + e.getMessage(), new Object[0]);
                    }
                }
            }
            pidToCpuTimeMapBuilder.put((Object)processId, (Object)this.factory.createLong(Long.valueOf(cpuTimeInSeconds)));
            pidToMajorFaultMapBuilder.put((Object)processId, (Object)majorFaults);
            pidToMinorFaultMapBuilder.put((Object)processId, (Object)minorFaults);
        }
        this.memoryUsedPercent = this.factory.createLong(Long.valueOf(Math.round(memoryUsedPercentDbl)));
        this.processCount = this.factory.createLong(Long.valueOf(filteredObservations.size()));
        this.cpuUsedPercent.calculate((ImmutableMap<RawDataLong, RawDataLong>)pidToCpuTimeMapBuilder.build(), this.factory.createLong(Long.valueOf(rawData.getEpochTime())), (Set<RawDataLong>)filteredProcessIdSet);
        this.majorFaultsRate.calculate((ImmutableMap<RawDataLong, RawDataLong>)pidToMajorFaultMapBuilder.build(), this.factory.createLong(Long.valueOf(rawData.getEpochTime())), (Set<RawDataLong>)filteredProcessIdSet);
        this.minorFaultsRate.calculate((ImmutableMap<RawDataLong, RawDataLong>)pidToMinorFaultMapBuilder.build(), this.factory.createLong(Long.valueOf(rawData.getEpochTime())), (Set<RawDataLong>)filteredProcessIdSet);
        if (hasGpuData) {
            this.gpuUsedPercent = this.factory.createLong(Long.valueOf(Math.round(gpuUsedPercentDbl)));
            this.gpuMemoryUsedPercent = this.factory.createLong(Long.valueOf(Math.round(gpuMemoryUsedPercentDbl)));
            this.gpuMetricsProvider.updateGpuMetrics(this.gpuUsedPercent, this.gpuMemoryUsedPercent);
        } else {
            this.gpuMetricsProvider.updateGpuMetrics(null, null);
        }
    }

    @Override
    protected ImmutableList<SimProcessObservationDto> getAllObservations(NewLinuxRawData rawData) {
        this.numProcessors = this.factory.createLong(Long.valueOf(rawData.getTotalNumLogicalProcessors()));
        List allProcData = rawData.getProcData().get((Object)this.getClassId());
        ImmutableList.Builder observationsBuilder = ImmutableList.builder();
        this.updateProcessMetricsMap(allProcData, rawData.getEpochTime());
        for (NewLinuxRawData.ProcessRawData processRawData : allProcData) {
            NewLinuxRawData.Process process = processRawData.getProcess();
            long elapsedTimeInMillis = 0L;
            try {
                elapsedTimeInMillis = NixUtils.getTimeInMilis(process.getElapsedTime().get());
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                this.repetitiveLogger.warn(log, ex.getMessage(), new Object[0]);
            }
            SimProcessObservationDto observation = new SimProcessObservationDto(elapsedTimeInMillis, processRawData.getProcClass().getProcessClassId(), processRawData.getProcClass().getProcessClass(), process.getName().or(UNKNOWN_VALUE), process.getPid().or(Long.valueOf(UnknownValueUtil.getUnknownValue())).longValue(), process.getParentId().or(Long.valueOf(UnknownValueUtil.getUnknownValue())).longValue(), process.getCommandLine().or(UNKNOWN_VALUE), process.getRealUser().or(UNKNOWN_VALUE), this.procStateUtil.getProcessState(process.getState().or(UNKNOWN_VALUE)), this.buildOsRelatedProcessProperties(process));
            observationsBuilder.add((Object)observation);
        }
        return observationsBuilder.build();
    }

    @Override
    protected RawDataLong getCpuUsedPercent() {
        RawDataLong calculatedCpuUsedPercent = this.cpuUsedPercent.getLastCookedResult();
        return this.numProcessors.or(Long.valueOf(0L)) != 0L ? calculatedCpuUsedPercent.divide(this.numProcessors) : calculatedCpuUsedPercent;
    }

    private void updateProcessMetricsMap(List<NewLinuxRawData.ProcessRawData> procData, long epochTime) {
        HashMap<RawDataLong, Pair<RawDataLong, Double>> newCpuData = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
        HashMap<RawDataLong, Pair<RawDataLong, Double>> newMemoryData = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
        HashMap<RawDataLong, String> newCommandLineMap = new HashMap<RawDataLong, String>();
        HashMap<RawDataLong, SimProcessDtoState> newStateData = new HashMap<RawDataLong, SimProcessDtoState>();
        for (NewLinuxRawData.ProcessRawData processRawData : procData) {
            NewLinuxRawData.Process process = processRawData.getProcess();
            RawDataLong pid = process.getPid();
            Long cpuTime = 0L;
            try {
                cpuTime = TimeUnit.MILLISECONDS.toSeconds(NixUtils.getTimeInMilis(process.getCpuTime().get()));
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                this.repetitiveLogger.warn(log, ex.getMessage(), new Object[0]);
            }
            RawDataLong memoryUsage = this.factory.createLong(Long.valueOf((long)Double.parseDouble(process.getMemoryPercent().get())));
            RawDataLong cpuUsage = null;
            if (this.pidToCpuTimeAndEpochTime.get(pid) != null) {
                Long oldCpuTime = (Long)this.pidToCpuTimeAndEpochTime.get((Object)pid).first;
                Long oldEpochTime = (Long)this.pidToCpuTimeAndEpochTime.get((Object)pid).second;
                if (epochTime > oldEpochTime) {
                    long cpuTimeDifference = cpuTime - oldCpuTime;
                    long epochTimeDifference = epochTime - oldEpochTime;
                    cpuUsage = this.factory.createLong(Long.valueOf(Math.round(100.0 * (double)cpuTimeDifference / (double)epochTimeDifference)));
                }
            }
            this.pidToCpuTimeAndEpochTime.put(pid, Pair.of(cpuTime, epochTime));
            if (cpuUsage == null) continue;
            cpuUsage = this.numProcessors.or(Long.valueOf(0L)) != 0L ? cpuUsage.divide(this.numProcessors) : cpuUsage;
            Double alpha = this.getAverageAlpha();
            Double expoMovingMemoryAverageValue = (double)memoryUsage.get().longValue() * 1.0;
            Double expoMovingCpuAverageValue = (double)cpuUsage.get().longValue() * 1.0;
            if (this.currentProcessMemoryMetrics.get(pid) != null) {
                Double oldMemoryUsage = this.currentProcessMemoryMetrics.get(pid).getSecond();
                Double oldCpuUsage = this.currentProcessCpuMetrics.get(pid).getSecond();
                expoMovingMemoryAverageValue = oldMemoryUsage + alpha * ((double)memoryUsage.get().longValue() - oldMemoryUsage);
                expoMovingCpuAverageValue = oldCpuUsage + alpha * ((double)cpuUsage.get().longValue() - oldCpuUsage);
            }
            newCpuData.put(pid, Pair.of(cpuUsage, expoMovingCpuAverageValue));
            newMemoryData.put(pid, Pair.of(memoryUsage, expoMovingMemoryAverageValue));
            newCommandLineMap.put(pid, process.getCommandLine().get());
            newStateData.put(pid, this.procStateUtil.getProcessState(process.getState().or(UNKNOWN_VALUE)));
            this.currentProcessStateMetrics.remove(pid);
        }
        if (this.gpuMetricsProvider.hasGpuMetrics()) {
            this.gpuMetricsProvider.updateProcessLevelGpuMetrics(procData);
        }
        this.currentProcessCpuMetrics = newCpuData;
        this.currentProcessMemoryMetrics = newMemoryData;
        this.currentProcessCommandLineMap = newCommandLineMap;
        this.currentProcessStateMetrics.keySet().stream().forEach(key -> newStateData.put((RawDataLong)key, SimProcessDtoState.TERMINATED));
        this.currentProcessStateMetrics = newStateData;
    }

    @Override
    protected RawDataLong getMajorFaultsRate() {
        return this.majorFaultsRate.getLastCookedResult();
    }

    @Override
    protected RawDataLong getMinorFaultsRate() {
        return this.minorFaultsRate.getLastCookedResult();
    }

    @Override
    public Map<RawDataLong, Pair<RawDataLong, Double>> getCurrentProcessCpuMetrics() {
        return this.currentProcessCpuMetrics;
    }

    @Override
    public Map<RawDataLong, Pair<RawDataLong, Double>> getCurrentProcessMemoryMetrics() {
        return this.currentProcessMemoryMetrics;
    }

    @Override
    public Map<RawDataLong, String> getCurrentProcessCommandLineMap() {
        return this.currentProcessCommandLineMap;
    }

    @Override
    public Map<RawDataLong, SimProcessDtoState> getCurrentProcessStateMetrics() {
        return this.currentProcessStateMetrics;
    }

    private Map<String, String> buildOsRelatedProcessProperties(NewLinuxRawData.Process process) {
        ImmutableMap.Builder propertyBuilder = ImmutableMap.builder();
        propertyBuilder.put((Object)NewLinuxProcessPropertyKey.EFFECTIVE_GROUP.getKey(), (Object)process.getEffectiveGroup().or(UNKNOWN_VALUE));
        propertyBuilder.put((Object)NewLinuxProcessPropertyKey.NICE_LEVEL.getKey(), (Object)process.getNice().or(UNKNOWN_VALUE));
        propertyBuilder.put((Object)NewLinuxProcessPropertyKey.PGID.getKey(), (Object)Long.toString(process.getGroupId().or(Long.valueOf(UnknownValueUtil.getUnknownValue()))));
        propertyBuilder.put((Object)NewLinuxProcessPropertyKey.REAL_GROUP.getKey(), (Object)process.getRealGroup().or(UNKNOWN_VALUE));
        propertyBuilder.put((Object)NewLinuxProcessPropertyKey.REAL_USER.getKey(), (Object)process.getRealUser().or(UNKNOWN_VALUE));
        return propertyBuilder.build();
    }

    @Override
    @Generated
    public RawDataLong getMemoryUsedKb() {
        return this.memoryUsedKb;
    }

    @Override
    @Generated
    public RawDataLong getMemoryUsedPercent() {
        return this.memoryUsedPercent;
    }

    @Override
    @Generated
    public RawDataLong getNumThreads() {
        return this.numThreads;
    }

    @Override
    @Generated
    public RawDataLong getVirtualMemoryKb() {
        return this.virtualMemoryKb;
    }

    @Override
    @Generated
    public RawDataLong getProcessCount() {
        return this.processCount;
    }

    @Generated
    public RawDataLong getNumProcessors() {
        return this.numProcessors;
    }

    @Generated
    public RawDataLong getGpuUsedPercent() {
        return this.gpuUsedPercent;
    }

    @Generated
    public RawDataLong getGpuMemoryUsedPercent() {
        return this.gpuMemoryUsedPercent;
    }

    @Generated
    public NixProcessStateUtil getProcStateUtil() {
        return this.procStateUtil;
    }

    @Generated
    public RawDataFactory getFactory() {
        return this.factory;
    }

    @Generated
    public RawDataItemUtil getRawDataItemUtil() {
        return this.rawDataItemUtil;
    }

    @Generated
    public MetricsService getMetricsService() {
        return this.metricsService;
    }

    @Generated
    public Map<RawDataLong, Pair<Long, Long>> getPidToCpuTimeAndEpochTime() {
        return this.pidToCpuTimeAndEpochTime;
    }

    @Override
    @Generated
    public NewLinuxGpuMetricsProvider getGpuMetricsProvider() {
        return this.gpuMetricsProvider;
    }

    static enum NewLinuxProcessPropertyKey {
        EFFECTIVE_GROUP("effectiveGroup"),
        NICE_LEVEL("niceLevel"),
        PGID("pgid"),
        REAL_USER("realUser"),
        REAL_GROUP("realGroup");

        private final String key;

        @Generated
        private NewLinuxProcessPropertyKey(String key) {
            this.key = key;
        }

        @Generated
        public String getKey() {
            return this.key;
        }
    }
}

