/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.newlinux;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItemUtil;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.util.DeltaCalculatorUtil;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Memory;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.newlinux.NewLinuxRawData;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForAssistedInject
public class NewLinuxMemory
extends Memory<NewLinuxRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewLinuxMemory.class);
    private static final String USE_SLAB_RECLAIMABLE_IN_FREE_MEM = "appdynamics.machine.agent.extensions.countSlabReclaimableAsFreeMem";
    private NewLinuxRawData.Memory memory;
    private NewLinuxRawData.Memory freeCommandOutput;
    private final DeltaCalculatorUtil pagesPagedInCalculator;
    private final DeltaCalculatorUtil pagesPagedOutculator;
    private final DeltaCalculatorUtil pagesSwappedInCalculator;
    private final DeltaCalculatorUtil pagesSwappedOutCalculator;
    private final RawDataFactory rawDataFactory;
    private final RawDataItemUtil rawDataItemUtil;
    private Optional<Boolean> useSlabReclaimableInFreeMem = Optional.absent();
    private final BootstrapConfiguration bootstrapConfiguration;

    @Inject
    NewLinuxMemory(@Sim MetricsService metricsService, MachineProperties machineProperties, Predicate<ToggleableReporter<NewLinuxRawData>> isDisabledPredicate, RawDataFactory rawDataFactory, RawDataItemUtil rawDataItemUtil, BootstrapConfiguration bootstrapConfiguration) {
        super("LinuxMemory", metricsService, machineProperties, isDisabledPredicate, rawDataFactory);
        this.pagesPagedInCalculator = new DeltaCalculatorUtil();
        this.pagesPagedOutculator = new DeltaCalculatorUtil();
        this.pagesSwappedInCalculator = new DeltaCalculatorUtil();
        this.pagesSwappedOutCalculator = new DeltaCalculatorUtil();
        this.rawDataFactory = rawDataFactory;
        this.rawDataItemUtil = rawDataItemUtil;
        this.bootstrapConfiguration = bootstrapConfiguration;
    }

    @Override
    public void update(NewLinuxRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.memory = rawData.getMemory();
        this.freeCommandOutput = rawData.getFreeCommandOutput();
        NewLinuxRawData.CpuPerf cpuPerf = rawData.getCpuPerfs().get("_Total");
        if (cpuPerf != null) {
            this.pagesPagedInCalculator.calculate(cpuPerf.getPagesPagedIn());
            this.pagesPagedOutculator.calculate(cpuPerf.getPagesPagedOut());
            this.pagesSwappedInCalculator.calculate(cpuPerf.getPagesSwappedIn());
            this.pagesSwappedOutCalculator.calculate(cpuPerf.getPagesSwappedOut());
        }
    }

    @Override
    public void report(NewLinuxRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        super.report(rawData, reportMetricsConfig);
        if (reportMetricsConfig.isReportPercentileMetrics()) {
            this.metricsService.reportMetric("Hardware Resources|Memory|Pages Paged In 95th Percentile", ExtensionMetricAggregatorType.PERCENTILE, ((Long)this.getPagesPagedIn().get()).longValue());
            this.metricsService.reportMetric("Hardware Resources|Memory|Pages Paged Out 95th Percentile", ExtensionMetricAggregatorType.PERCENTILE, ((Long)this.getPagesPagedOut().get()).longValue());
            this.metricsService.reportMetric("Hardware Resources|Memory|Pages Swapped In 95th Percentile", ExtensionMetricAggregatorType.PERCENTILE, ((Long)this.getPagesSwappedIn().get()).longValue());
            this.metricsService.reportMetric("Hardware Resources|Memory|Pages Swapped Out 95th Percentile", ExtensionMetricAggregatorType.PERCENTILE, ((Long)this.getPagesSwappedOut().get()).longValue());
        }
    }

    @Override
    protected RawDataLong getSwapTotalMb() {
        return this.rawDataItemUtil.kilobytesToMegabytes(this.memory.getSwapTotalKb());
    }

    @Override
    protected RawDataLong getSwapFreeMb() {
        if (this.isUsingFreeCommandOutput()) {
            return this.rawDataItemUtil.kilobytesToMegabytes(this.freeCommandOutput.getSwapFreeKb());
        }
        return this.rawDataItemUtil.kilobytesToMegabytes(this.memory.getSwapFreeKb());
    }

    @Override
    protected RawDataLong getPhysicalTotalMb() {
        RawDataLong physicalTotalKb = this.memory.getTotalKb();
        return this.rawDataItemUtil.kilobytesToMegabytes(physicalTotalKb);
    }

    @Override
    protected RawDataLong getPhysicalFreeMb() {
        RawDataLong physicalFreeKb;
        if (this.isUsingFreeCommandOutput()) {
            physicalFreeKb = this.freeCommandOutput.getFreeKb();
        } else {
            physicalFreeKb = this.memory.getAvailableKb();
            RawDataLong slabReclaimableKb = this.memory.getSlabReclaimableKb();
            Boolean useSlabReclaimable = this.getUseSlabReclaimableInFreeMem();
            if (useSlabReclaimable.booleanValue() && slabReclaimableKb.isPresent()) {
                physicalFreeKb = physicalFreeKb.add(slabReclaimableKb);
            }
        }
        return this.rawDataItemUtil.kilobytesToMegabytes(physicalFreeKb);
    }

    @Override
    protected RawDataLong getPhysicalUsedMb() {
        if (this.isUsingFreeCommandOutput()) {
            return this.rawDataItemUtil.kilobytesToMegabytes(this.freeCommandOutput.getUsedKb());
        }
        return super.getPhysicalUsedMb();
    }

    @Override
    protected RawDataLong getPhysicalUsedPct() {
        if (this.isUsingFreeCommandOutput()) {
            return CalculationUtils.calculatePercentage(this.freeCommandOutput.getUsedKb(), this.freeCommandOutput.getTotalKb(), this.rawDataFactory);
        }
        return super.getPhysicalUsedPct();
    }

    @Override
    protected RawDataLong getSwapUsedMb() {
        if (this.isUsingFreeCommandOutput()) {
            return this.rawDataItemUtil.kilobytesToMegabytes(this.freeCommandOutput.getSwapUsedKb());
        }
        return super.getSwapUsedMb();
    }

    private Optional<Long> getPagesPagedIn() {
        return Optional.of((Object)this.pagesPagedInCalculator.getLastResult());
    }

    private Optional<Long> getPagesPagedOut() {
        return Optional.of((Object)this.pagesPagedOutculator.getLastResult());
    }

    private Optional<Long> getPagesSwappedIn() {
        return Optional.of((Object)this.pagesSwappedInCalculator.getLastResult());
    }

    private Optional<Long> getPagesSwappedOut() {
        return Optional.of((Object)this.pagesSwappedOutCalculator.getLastResult());
    }

    private Boolean getUseSlabReclaimableInFreeMem() {
        if (!this.useSlabReclaimableInFreeMem.isPresent()) {
            this.useSlabReclaimableInFreeMem = Optional.of((Object)Boolean.parseBoolean(System.getProperty(USE_SLAB_RECLAIMABLE_IN_FREE_MEM, "false")));
        }
        return (Boolean)this.useSlabReclaimableInFreeMem.get();
    }

    @VisibleForTesting
    boolean isUsingFreeCommandOutput() {
        boolean swapFreeKbAndSwapUsedKbPresent;
        boolean freeKbAndUsedKbPresent = this.freeCommandOutput != null && this.freeCommandOutput.getFreeKb().isPresent() && this.freeCommandOutput.getUsedKb().isPresent();
        boolean bl = swapFreeKbAndSwapUsedKbPresent = this.freeCommandOutput != null && this.freeCommandOutput.getSwapFreeKb().isPresent() && this.freeCommandOutput.getSwapUsedKb().isPresent();
        if (!(!this.bootstrapConfiguration.getCollectMemoryMetricsUsingFreeCommandEnabled().booleanValue() || freeKbAndUsedKbPresent && swapFreeKbAndSwapUsedKbPresent)) {
            log.trace("Free command output is incomplete. Using /proc/meminfo file to collect memory metrics");
        }
        return this.bootstrapConfiguration.getCollectMemoryMetricsUsingFreeCommandEnabled() != false && freeKbAndUsedKbPresent && swapFreeKbAndSwapUsedKbPresent;
    }

    @Generated
    public String toString() {
        return "NewLinuxMemory(super=" + super.toString() + ", memory=" + String.valueOf(this.memory) + ", freeCommandOutput=" + String.valueOf(this.freeCommandOutput) + ", pagesPagedInCalculator=" + String.valueOf(this.pagesPagedInCalculator) + ", pagesPagedOutculator=" + String.valueOf(this.pagesPagedOutculator) + ", pagesSwappedInCalculator=" + String.valueOf(this.pagesSwappedInCalculator) + ", pagesSwappedOutCalculator=" + String.valueOf(this.pagesSwappedOutCalculator) + ", rawDataFactory=" + String.valueOf(this.rawDataFactory) + ", rawDataItemUtil=" + String.valueOf(this.rawDataItemUtil) + ", useSlabReclaimableInFreeMem=" + this.getUseSlabReclaimableInFreeMem() + ", bootstrapConfiguration=" + String.valueOf(this.bootstrapConfiguration) + ")";
    }
}

