/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.newlinux;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.model.GpuMetricsProvider;
import com.appdynamics.sim.agent.extensions.servers.model.newlinux.NewLinuxRawData;
import com.appdynamics.sim.agent.extensions.servers.util.Pair;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewLinuxGpuMetricsProvider
implements GpuMetricsProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewLinuxGpuMetricsProvider.class);
    private static final String NO_GPU_METRIC = "-";
    private static final String ZERO_METRIC = "0";
    private final Map<RawDataLong, Pair<RawDataLong, RawDataLong>> processGpuMetrics = new HashMap<RawDataLong, Pair<RawDataLong, RawDataLong>>();
    private final BootstrapConfiguration bootstrapConfiguration;
    private final RawDataFactory factory;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private RawDataLong gpuUsedPercent;
    private RawDataLong gpuMemoryUsedPercent;

    @Inject
    public NewLinuxGpuMetricsProvider(BootstrapConfiguration bootstrapConfiguration, RawDataFactory factory, SimAgentRepetitiveLogger repetitiveLogger) {
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.factory = factory;
        this.repetitiveLogger = repetitiveLogger;
    }

    @Override
    public boolean hasGpuMetrics() {
        return this.bootstrapConfiguration.getGpuEnabled();
    }

    @Override
    public Map<RawDataLong, Pair<RawDataLong, RawDataLong>> getProcessLevelGpuMetrics() {
        return this.processGpuMetrics;
    }

    @Override
    public RawDataLong getGpuUsedPercent() {
        return this.gpuUsedPercent;
    }

    @Override
    public RawDataLong getGpuMemoryUsedPercent() {
        return this.gpuMemoryUsedPercent;
    }

    public void updateGpuMetrics(RawDataLong gpuUsedPercent, RawDataLong gpuMemoryUsedPercent) {
        this.gpuUsedPercent = gpuUsedPercent;
        this.gpuMemoryUsedPercent = gpuMemoryUsedPercent;
    }

    public void updateProcessLevelGpuMetrics(List<NewLinuxRawData.ProcessRawData> procData) {
        if (!this.hasGpuMetrics()) {
            return;
        }
        this.processGpuMetrics.clear();
        for (NewLinuxRawData.ProcessRawData processRawData : procData) {
            try {
                NewLinuxRawData.Process process = processRawData.getProcess();
                RawDataLong pid = process.getPid();
                String gpuUtil = process.getGpuUtilization().or(NO_GPU_METRIC);
                String gpuMemUtil = process.getGpuMemoryUtilization().or(NO_GPU_METRIC);
                if (NO_GPU_METRIC.equals(gpuUtil) && NO_GPU_METRIC.equals(gpuMemUtil)) continue;
                RawDataLong gpuUsage = this.factory.createLong(Long.valueOf(Math.round(Double.parseDouble(NO_GPU_METRIC.equals(gpuUtil) ? ZERO_METRIC : gpuUtil))));
                RawDataLong gpuMemoryUsage = this.factory.createLong(Long.valueOf(Math.round(Double.parseDouble(NO_GPU_METRIC.equals(gpuMemUtil) ? ZERO_METRIC : gpuMemUtil))));
                this.processGpuMetrics.put(pid, Pair.of(gpuUsage, gpuMemoryUsage));
            }
            catch (NumberFormatException e) {
                this.repetitiveLogger.warn(log, "Error parsing GPU metrics for process: " + e.getMessage(), new Object[0]);
            }
        }
    }
}

