/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.hpux;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.servers.collector.RawCollectorUtil;
import com.appdynamics.sim.agent.extensions.servers.model.ProcessClassIdCreator;
import com.appdynamics.sim.agent.extensions.servers.model.RawCollector;
import com.appdynamics.sim.agent.extensions.servers.model.hpux.HpUxRawData;
import com.appdynamics.sim.agent.extensions.servers.util.NixUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.dropwizard.util.SizeUnit;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HpUxRawCollector
implements RawCollector<HpUxRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HpUxRawCollector.class);
    @VisibleForTesting
    static final String CPUPERF_ID_TOTAL = "_Total";
    private static final Pattern DAY_PATTERN = Pattern.compile("(\\d*) day");
    private static final Pattern MIN_PATTERN = Pattern.compile("(\\d*) min");
    private static final Pattern HR_PATTERN = Pattern.compile("(\\d*) hr");
    private static final Pattern HR_MIN_PATTERN = Pattern.compile("(\\d{1,2}):(\\d{2})");
    private static final HpUxRawData EMPTY_RAW_DATA = new HpUxRawData();
    private final ObjectMapper objectMapper;
    private final ProcessClassIdCreator processClassIdCreator;
    private final Optional<RawCollectorUtil.ICollectorProcessBuilder> processBuilder;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final RawCollectorUtil rawCollectorUtil;

    @Inject
    HpUxRawCollector(ObjectMapper objectMapper, ProcessClassIdCreator processClassIdCreator, Optional<RawCollectorUtil.ICollectorProcessBuilder> collectorProcessBuilder, SimAgentRepetitiveLogger repetitiveLogger, RawCollectorUtil rawCollectorUtil) throws IOException {
        this.objectMapper = objectMapper;
        this.processBuilder = collectorProcessBuilder;
        this.processClassIdCreator = processClassIdCreator;
        this.repetitiveLogger = repetitiveLogger;
        this.rawCollectorUtil = rawCollectorUtil;
    }

    @Override
    public HpUxRawData collectRawData(Set<String> componentsToCollect, long maxCollectionTimeMillis) {
        Optional<HpUxRawData> rawDataOpt = Optional.absent();
        if (!this.processBuilder.isPresent()) {
            this.repetitiveLogger.error(log, "Process to collect raw data is not present - skipping collection", new Object[0]);
        } else {
            RawCollectorUtil.ICollectorProcessBuilder collectorProcessBuilder = (RawCollectorUtil.ICollectorProcessBuilder)this.processBuilder.get();
            ImmutableMap environmentVar = ImmutableMap.builder().put((Object)"APPDYNAMICS_DATA_COLLECTOR_SAMPLING_INTERVAL", (Object)String.valueOf(maxCollectionTimeMillis / 1000L)).build();
            rawDataOpt = this.rawCollectorUtil.runCollector(HpUxRawData.class, collectorProcessBuilder, this.objectMapper, (Optional<List<String>>)Optional.absent(), (Map<String, String>)environmentVar, maxCollectionTimeMillis);
            log.debug("Raw data after running script " + String.valueOf(rawDataOpt));
        }
        HpUxRawData rawData = (HpUxRawData)rawDataOpt.or((Object)EMPTY_RAW_DATA);
        this.preProcess(rawData);
        return rawData;
    }

    private void preProcess(HpUxRawData rawData) {
        log.debug("pre-processing raw data: {}", (Object)rawData);
        this.preProcessProcesses(rawData);
        this.preProcessUptime(rawData.getCpuPerfs().get(CPUPERF_ID_TOTAL));
        this.preProcessPartitions(rawData);
        this.preProcessCpus(rawData);
        log.debug("preProcess done");
    }

    private void preProcessProcesses(HpUxRawData rawData) {
        Set<String> pids = rawData.getPidToProcessAll().keySet();
        long totalMemoryKb = SizeUnit.MEGABYTES.toKilobytes(rawData.getMemory().getTotalMb());
        for (String pid : pids) {
            HpUxRawData.ProcessAll processAll = rawData.getPidToProcessAll().get(pid);
            HpUxRawData.ProcessMemory processMemory = rawData.getPidToProcessMemory().get(pid);
            this.separateNameElapsedTimeCommand(processAll);
            if (processMemory != null) {
                processAll.setMemoryUsedKb(processMemory.getMemoryUsedKb());
                processAll.setMemoryPercent(String.valueOf((double)processMemory.getMemoryUsedKb() / (double)totalMemoryKb));
            }
            ProcessClassIdCreator.ProcessClass processClass = this.processClassIdCreator.extractClass(processAll.getCommandLine(), processAll.getName());
            rawData.getProcData().put((Object)processClass.getProcessClassId(), (Object)new HpUxRawData.ProcessRawData(processClass, processAll));
        }
    }

    private void separateNameElapsedTimeCommand(HpUxRawData.ProcessAll process) {
        String nameElapsedTimeCommandLine = process.getNameElapsedTimeCommandLine();
        NixUtils.SeparatedCommEtimeArgs separatedCommEtimeArgs = NixUtils.separateCommEtimeArgs(nameElapsedTimeCommandLine);
        process.setName(separatedCommEtimeArgs.getCommand());
        process.setElapsedTime(separatedCommEtimeArgs.getElapsedTime());
        process.setCommandLine(separatedCommEtimeArgs.getArgs());
    }

    @VisibleForTesting
    void preProcessUptime(HpUxRawData.CpuPerf cpuPerf) {
        long uptimeDays = 0L;
        long uptimeMins = 0L;
        long uptimeHrs = 0L;
        String uptimeStr = cpuPerf.getUptimeStr();
        int upIndex = uptimeStr.indexOf("up");
        if (upIndex != -1) {
            uptimeStr = uptimeStr.substring(upIndex);
            Matcher dayMatcher = DAY_PATTERN.matcher(uptimeStr);
            Matcher hrMinMatcher = HR_MIN_PATTERN.matcher(uptimeStr);
            uptimeDays = this.setFieldIfMatch(dayMatcher);
            if (hrMinMatcher.find()) {
                uptimeHrs = Long.valueOf(hrMinMatcher.group(1));
                uptimeMins = Long.valueOf(hrMinMatcher.group(2));
            } else {
                Matcher hrMatcher = HR_PATTERN.matcher(uptimeStr);
                Matcher minMatcher = MIN_PATTERN.matcher(uptimeStr);
                uptimeHrs = this.setFieldIfMatch(hrMatcher);
                uptimeMins = this.setFieldIfMatch(minMatcher);
            }
            cpuPerf.setUptimeHours(uptimeHrs);
            cpuPerf.setUptimeMinutes(uptimeMins);
            cpuPerf.setUptimeDays(uptimeDays);
        } else {
            cpuPerf.setUptimeHours(uptimeHrs);
            cpuPerf.setUptimeMinutes(uptimeMins);
            cpuPerf.setUptimeDays(uptimeDays);
        }
    }

    private long setFieldIfMatch(Matcher matcher) {
        return matcher.find() ? Long.valueOf(matcher.group(1)) : 0L;
    }

    @VisibleForTesting
    void preProcessPartitions(HpUxRawData rawData) {
        HashMap<String, HpUxRawData.Partition> partitions = new HashMap<String, HpUxRawData.Partition>();
        Map<String, HpUxRawData.Partition> unprocessedPartitions = rawData.getPartitions();
        Map<String, HpUxRawData.Volume> volumes = rawData.getVolumes();
        volumes.remove("/proc");
        unprocessedPartitions.remove("/proc");
        for (String mountPoint : unprocessedPartitions.keySet()) {
            if (!volumes.containsKey(mountPoint)) continue;
            partitions.put(volumes.get(mountPoint).getName(), unprocessedPartitions.get(mountPoint));
        }
        HashSet<String> partitionNamesMissingMatchingFs = new HashSet<String>(unprocessedPartitions.keySet());
        partitionNamesMissingMatchingFs.removeAll(rawData.getVolumes().keySet());
        for (String partitionName : partitionNamesMissingMatchingFs) {
            int length = partitionName.length();
            for (String volMountPoint : rawData.getVolumes().keySet()) {
                if (volMountPoint.length() <= length || !volMountPoint.substring(0, length).equals(partitionName)) continue;
                partitions.put(rawData.getVolumes().get(volMountPoint).getName(), unprocessedPartitions.get(partitionName));
            }
        }
        rawData.setPartitions(partitions);
    }

    private void preProcessCpus(HpUxRawData rawData) {
        rawData.setTotalNumLogicalProcessors(rawData.getCpus().size());
    }
}

