/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.hpux;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Memory;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.hpux.HpUxRawData;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import io.dropwizard.util.SizeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForAssistedInject
public class HpUxMemory
extends Memory<HpUxRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HpUxMemory.class);
    private final RawDataFactory rawDataFactory;
    private HpUxRawData.Memory memory;
    private final BootstrapConfiguration bootstrapConfiguration;

    @Inject
    public HpUxMemory(@Sim MetricsService metricsService, MachineProperties machineProperties, Predicate<ToggleableReporter<HpUxRawData>> isDisabledPredicate, RawDataFactory rawDataFactory, BootstrapConfiguration bootstrapConfiguration) {
        super("HpUxMemory", metricsService, machineProperties, isDisabledPredicate, rawDataFactory);
        this.rawDataFactory = rawDataFactory;
        this.bootstrapConfiguration = bootstrapConfiguration;
    }

    @Override
    public void update(HpUxRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.memory = rawData.getMemory();
    }

    @Override
    protected RawDataLong getSwapTotalMb() {
        if (this.isUsingVmstatCommandOutput()) {
            return this.rawDataFactory.createLong(Long.valueOf(SizeUnit.KILOBYTES.toMegabytes(this.memory.getTotalSwapKb())));
        }
        return this.rawDataFactory.createLong(Long.valueOf(SizeUnit.KILOBYTES.toMegabytes(this.memory.getTotalSwapKb())));
    }

    @Override
    protected RawDataLong getSwapFreeMb() {
        RawDataLong swapTotalMb = this.getSwapTotalMb();
        if (!swapTotalMb.isPresent()) {
            return swapTotalMb;
        }
        if (this.isUsingVmstatCommandOutput()) {
            return this.rawDataFactory.createLong(Long.valueOf(swapTotalMb.get() - SizeUnit.KILOBYTES.toMegabytes(this.memory.getUsedSwapKb())));
        }
        return this.rawDataFactory.createLong(Long.valueOf(swapTotalMb.get() - SizeUnit.KILOBYTES.toMegabytes(this.memory.getUsedSwapKb())));
    }

    @Override
    protected RawDataLong getPhysicalTotalMb() {
        RawDataLong physicalTotalMb = this.rawDataFactory.createLong(Long.valueOf(this.memory.getTotalMb()));
        log.debug("getPhysicalTotalMb - {}", (Object)physicalTotalMb);
        return physicalTotalMb;
    }

    @Override
    protected RawDataLong getPhysicalFreeMb() {
        RawDataLong physicalTotalMb = this.getPhysicalTotalMb();
        if (!physicalTotalMb.isPresent()) {
            return physicalTotalMb;
        }
        RawDataLong physicalFreeMb = this.rawDataFactory.createLong(Long.valueOf(physicalTotalMb.get() - SizeUnit.KILOBYTES.toMegabytes(this.memory.getUsedKb())));
        log.debug("getPhysicalFreeMb - {}", (Object)physicalFreeMb);
        return physicalFreeMb;
    }

    @VisibleForTesting
    boolean isUsingVmstatCommandOutput() {
        return this.bootstrapConfiguration.getCollectMemoryMetricsUsingVmstatCommandEnabled();
    }

    @Generated
    public String toString() {
        return "HpUxMemory(super=" + super.toString() + ", rawDataFactory=" + String.valueOf(this.rawDataFactory) + ", memory=" + String.valueOf(this.memory) + ", bootstrapConfiguration=" + String.valueOf(this.bootstrapConfiguration) + ")";
    }
}

