/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.hpux;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItemUtil;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Cpu;
import com.appdynamics.sim.agent.extensions.servers.model.hpux.HpUxRawData;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Map;

public class HpUxCpu
extends Cpu<HpUxRawData> {
    private static final String HP = "HP";
    private final RawDataFactory factory;
    private HpUxRawData.Cpu cpu;

    @Inject
    private HpUxCpu(@Assisted String cpuId, @Sim MachineProperties machineProperties, RawDataItemUtil rawDataItemUtil, RawDataFactory factory) {
        super(cpuId, machineProperties, rawDataItemUtil);
        this.factory = factory;
    }

    @Override
    public void update(HpUxRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.cpu = rawData.getCpus().get(this.getCpuId());
    }

    @Override
    protected RawDataLong getNumLogicalProcessors() {
        return this.factory.createLong(Long.valueOf(this.cpu.getSmtThreads()));
    }

    @Override
    protected RawDataLong getNumCores() {
        return this.factory.createLong(Long.valueOf(this.cpu.getCores()));
    }

    @Override
    protected RawDataString getCpuVendor() {
        return this.factory.createString(Optional.of((Object)HP));
    }

    @Override
    protected RawDataString getCpuModel() {
        return this.factory.createString(Optional.of((Object)this.cpu.getModel()));
    }

    @Override
    protected RawDataString getCpuMaxSpeedMhz() {
        String value = String.valueOf(CalculationUtils.hzToMhz(this.cpu.getMaxSpeedHz()));
        return this.factory.createString(Optional.of((Object)value));
    }

    @Override
    protected RawDataString getCpuCurrentSpeedMhz() {
        return this.factory.createString(Optional.of((Object)HP));
    }

    @Override
    protected Map<String, RawDataString> getOsSpecificProperties() {
        ImmutableMap.Builder properties = new ImmutableMap.Builder();
        properties.put((Object)"CPU|{0}|SMT Enabled", (Object)this.factory.createString(Optional.of((Object)this.cpu.getSmtEnabled())));
        properties.put((Object)"CPU|{0}|State", (Object)this.factory.createString(Optional.of((Object)this.cpu.getState())));
        return properties.build();
    }
}

