/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.filter;

import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Component;
import com.appdynamics.sim.agent.extensions.servers.model.filter.IComponentWhitelistProcessingMethod;
import com.appdynamics.sim.agent.extensions.servers.model.filter.PrioritizationFilter;
import com.appdynamics.sim.agent.extensions.servers.model.filter.PrioritizationFilterResult;
import com.google.common.base.Optional;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

class WhitelistPrioritizationFilter<COMPONENT extends Component<?>>
implements PrioritizationFilter<COMPONENT> {
    private IComponentWhitelistProcessingMethod<COMPONENT> whitelistProcessorMethod;

    @Override
    public PrioritizationFilterResult<COMPONENT> apply(@NonNull Optional<PrioritizationFilterResult<COMPONENT>> prevPrioritization, Set<COMPONENT> components, @NonNull ReportMetricsConfig configuration) {
        if (prevPrioritization == null) {
            throw new NullPointerException("prevPrioritization is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        LinkedHashSet<COMPONENT> priorityList = this.whitelistProcessorMethod.extractByWhitelist(components);
        return PrioritizationFilterResult.combinedWithWhitelistOf(prevPrioritization, priorityList);
    }

    @Generated
    public WhitelistPrioritizationFilter(IComponentWhitelistProcessingMethod<COMPONENT> whitelistProcessorMethod) {
        this.whitelistProcessorMethod = whitelistProcessorMethod;
    }
}

