/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.filter;

import com.appdynamics.sim.agent.extensions.servers.model.Component;
import com.appdynamics.sim.agent.extensions.servers.model.filter.FilterPredicate;
import com.appdynamics.sim.agent.extensions.servers.model.filter.PrioritizationFilterResult;
import com.appdynamics.sim.agent.extensions.servers.model.filter.ReductionFilter;
import com.appdynamics.sim.agent.extensions.servers.model.filter.ReductionFilterResult;
import com.google.common.base.Optional;
import java.util.LinkedHashSet;
import lombok.Generated;
import lombok.NonNull;

public class SinglePredicateReductionFilter<COMPONENT extends Component<?>>
implements ReductionFilter<COMPONENT> {
    protected static final boolean RESPECTS_WHITELIST = true;
    protected static final boolean IGNORES_WHITELIST = false;
    private final FilterPredicate<COMPONENT> predicate;
    private final boolean respectsWhitelist;

    @Override
    public ReductionFilterResult<COMPONENT> apply(@NonNull Optional<PrioritizationFilterResult<COMPONENT>> prioritization, @NonNull ReductionFilterResult<COMPONENT> prevReductionResult) {
        if (prioritization == null) {
            throw new NullPointerException("prioritization is marked non-null but is null");
        }
        if (prevReductionResult == null) {
            throw new NullPointerException("prevReductionResult is marked non-null but is null");
        }
        LinkedHashSet<Component> filteredSet = new LinkedHashSet<Component>();
        this.predicate.refresh();
        for (Component component : prevReductionResult.getFilteredComponents()) {
            boolean isIncludedDueToWhitelist = this.respectsWhitelist && prioritization.isPresent() && ((PrioritizationFilterResult)prioritization.get()).getWhitelistComponents().contains(component);
            boolean isIncluded = isIncludedDueToWhitelist || this.predicate.apply(component);
            if (!isIncluded) continue;
            filteredSet.add(component);
        }
        return ReductionFilterResult.of(filteredSet);
    }

    @Generated
    public SinglePredicateReductionFilter(FilterPredicate<COMPONENT> predicate, boolean respectsWhitelist) {
        this.predicate = predicate;
        this.respectsWhitelist = respectsWhitelist;
    }
}

