/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.filter;

import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Component;
import com.appdynamics.sim.agent.extensions.servers.model.filter.IComponentRankingMethod;
import com.appdynamics.sim.agent.extensions.servers.model.filter.PrioritizationFilter;
import com.appdynamics.sim.agent.extensions.servers.model.filter.PrioritizationFilterResult;
import com.google.common.base.Optional;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;

public class RankPrioritizationFilter<COMPONENT extends Component<?>>
implements PrioritizationFilter<COMPONENT> {
    private final IComponentRankingMethod<COMPONENT> rankingMethod;

    @Override
    public PrioritizationFilterResult<COMPONENT> apply(Optional<PrioritizationFilterResult<COMPONENT>> prevPrioritization, Set<COMPONENT> components, ReportMetricsConfig configuration) {
        PrioritizationFilterResult prevPrioritizationOrEmpty = (PrioritizationFilterResult)prevPrioritization.or(PrioritizationFilterResult.empty());
        Set prioritizedComponents = prevPrioritizationOrEmpty.getPrioritizedComponents();
        Set<Object> rankedSet = this.rankingMethod.rank(prioritizedComponents, components);
        if (rankedSet == null) {
            rankedSet = Collections.emptySet();
        }
        return PrioritizationFilterResult.combinedOf(prevPrioritization, prevPrioritizationOrEmpty.getWhitelistComponents(), rankedSet);
    }

    @Generated
    public RankPrioritizationFilter(IComponentRankingMethod<COMPONENT> rankingMethod) {
        this.rankingMethod = rankingMethod;
    }
}

