/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.filter;

import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.model.MonitoredProcessClass;
import com.appdynamics.sim.agent.extensions.servers.model.filter.IComponentWhitelistProcessingMethod;
import com.google.common.collect.ArrayListMultimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ProcessClassWhitelistMethod<RAWDATA>
implements IComponentWhitelistProcessingMethod<MonitoredProcessClass<RAWDATA>> {
    private final Provider<ServersMonitorConfig> monitorConfigProvider;

    @Inject
    public ProcessClassWhitelistMethod(Provider<ServersMonitorConfig> monitorConfigProvider) {
        this.monitorConfigProvider = monitorConfigProvider;
    }

    @Override
    public LinkedHashSet<MonitoredProcessClass<RAWDATA>> extractByWhitelist(Set<MonitoredProcessClass<RAWDATA>> totalSet) {
        ArrayListMultimap priorityList = ArrayListMultimap.create();
        Map<String, String> orderedClassRegexMap = ((ServersMonitorConfig)this.monitorConfigProvider.get()).getProcessMonitorConfig().getProcessClassSelectorRegexList();
        HashMap<String, Integer> rankMap = new HashMap<String, Integer>();
        int rank = 1;
        for (String string : orderedClassRegexMap.keySet()) {
            rankMap.put(string, rank++);
        }
        for (MonitoredProcessClass monitoredProcessClass : totalSet) {
            Integer rankValue = (Integer)rankMap.get(monitoredProcessClass.getClassId());
            if (rankValue == null) continue;
            priorityList.put((Object)rankValue, (Object)monitoredProcessClass);
        }
        return new LinkedHashSet<MonitoredProcessClass<RAWDATA>>(priorityList.values());
    }
}

