/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.filter;

import com.appdynamics.sim.agent.extensions.servers.model.Component;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;

public class PrioritizationFilterResult<COMPONENT extends Component<?>> {
    private final Set<COMPONENT> whitelistComponents;
    private final Set<COMPONENT> prioritizedComponents;

    public static <STATIC_COMPONENT extends Component<?>> PrioritizationFilterResult<STATIC_COMPONENT> empty() {
        return new PrioritizationFilterResult(Collections.emptySet(), Collections.emptySet());
    }

    public static <STATIC_COMPONENT extends Component<?>> PrioritizationFilterResult<STATIC_COMPONENT> combinedWithWhitelistOf(Optional<PrioritizationFilterResult<STATIC_COMPONENT>> prevResult, Set<STATIC_COMPONENT> currentWhitelist) {
        return PrioritizationFilterResult.combinedOf(prevResult, currentWhitelist, currentWhitelist);
    }

    public static <STATIC_COMPONENT extends Component<?>> PrioritizationFilterResult<STATIC_COMPONENT> combinedOf(Optional<PrioritizationFilterResult<STATIC_COMPONENT>> prevResult, Set<STATIC_COMPONENT> currentWhitelist, Set<STATIC_COMPONENT> currentPrioritized) {
        Set<Object> combinedPrioritized;
        Set<Object> combinedWhitelist;
        if (prevResult.isPresent()) {
            combinedWhitelist = PrioritizationFilterResult.combinedOrderedSetOf(((PrioritizationFilterResult)prevResult.get()).getWhitelistComponents(), currentWhitelist);
            combinedPrioritized = PrioritizationFilterResult.combinedOrderedSetOf(((PrioritizationFilterResult)prevResult.get()).getPrioritizedComponents(), currentPrioritized);
        } else {
            combinedWhitelist = currentWhitelist;
            combinedPrioritized = currentPrioritized;
        }
        return new PrioritizationFilterResult(ImmutableSet.copyOf(combinedWhitelist), ImmutableSet.copyOf(combinedPrioritized));
    }

    private static <T> Set<T> combinedOrderedSetOf(Set<T> firstSet, Set<T> secondSet) {
        LinkedHashSet<T> combinedSet = new LinkedHashSet<T>();
        combinedSet.addAll(firstSet);
        combinedSet.addAll(secondSet);
        return combinedSet;
    }

    @Generated
    public Set<COMPONENT> getWhitelistComponents() {
        return this.whitelistComponents;
    }

    @Generated
    public Set<COMPONENT> getPrioritizedComponents() {
        return this.prioritizedComponents;
    }

    @Generated
    PrioritizationFilterResult(Set<COMPONENT> whitelistComponents, Set<COMPONENT> prioritizedComponents) {
        this.whitelistComponents = whitelistComponents;
        this.prioritizedComponents = prioritizedComponents;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrioritizationFilterResult)) {
            return false;
        }
        PrioritizationFilterResult other = (PrioritizationFilterResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<COMPONENT> this$whitelistComponents = this.getWhitelistComponents();
        Set<COMPONENT> other$whitelistComponents = other.getWhitelistComponents();
        if (this$whitelistComponents == null ? other$whitelistComponents != null : !((Object)this$whitelistComponents).equals(other$whitelistComponents)) {
            return false;
        }
        Set<COMPONENT> this$prioritizedComponents = this.getPrioritizedComponents();
        Set<COMPONENT> other$prioritizedComponents = other.getPrioritizedComponents();
        return !(this$prioritizedComponents == null ? other$prioritizedComponents != null : !((Object)this$prioritizedComponents).equals(other$prioritizedComponents));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PrioritizationFilterResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<COMPONENT> $whitelistComponents = this.getWhitelistComponents();
        result = result * 59 + ($whitelistComponents == null ? 43 : ((Object)$whitelistComponents).hashCode());
        Set<COMPONENT> $prioritizedComponents = this.getPrioritizedComponents();
        result = result * 59 + ($prioritizedComponents == null ? 43 : ((Object)$prioritizedComponents).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PrioritizationFilterResult(whitelistComponents=" + String.valueOf(this.getWhitelistComponents()) + ", prioritizedComponents=" + String.valueOf(this.getPrioritizedComponents()) + ")";
    }
}

