/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.aix;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataConstants;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItemUtil;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Volume;
import com.appdynamics.sim.agent.extensions.servers.model.aix.AixRawData;
import com.appdynamics.sim.agent.extensions.servers.model.aix.AixVolumesUtil;
import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.dropwizard.util.SizeUnit;
import java.util.Set;
import lombok.Generated;

@VisibleForAssistedInject
public class AixVolume
extends Volume<AixRawData> {
    private AixRawData.Volume volume;
    private Set<String> validVolumePartitionNames;

    @Inject
    private AixVolume(@Assisted String mountPoint, @Sim MetricsService metricsService, @Sim MachineProperties machineProperties, RawDataFactory factory, RawDataItemUtil dataItemUtil) {
        super(mountPoint, metricsService, machineProperties, factory, dataItemUtil);
    }

    @Override
    public void update(AixRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.volume = rawData.getVolumes().get(this.getMountPoint());
        this.validVolumePartitionNames = rawData.getPartitions().keySet();
    }

    @Override
    protected RawDataString getPartition() {
        if (this.validVolumePartitionNames.contains(this.volume.getName())) {
            return this.getFactory().createString(Optional.of((Object)this.volume.getName()));
        }
        return RawDataConstants.ABSENT_STRING;
    }

    @Override
    protected RawDataString getPartitionDisplayName() {
        RawDataString rawPartition = this.getPartition();
        Optional<String> result = AixVolumesUtil.getBasePartitionName((Optional<String>)rawPartition.getValue());
        return this.getFactory().createString(result);
    }

    @Override
    protected RawDataLong getSizeMb() {
        long sizeMb = SizeUnit.KILOBYTES.toMegabytes(this.volume.getTotalKb());
        if (UnknownValueUtil.isUnknownValue(sizeMb)) {
            return RawDataConstants.ABSENT_LONG;
        }
        return this.getFactory().createLong(Long.valueOf(sizeMb));
    }

    @Override
    protected RawDataLong getUsedMb() {
        long usedMb = SizeUnit.KILOBYTES.toMegabytes(this.volume.getUsedKb());
        if (UnknownValueUtil.isUnknownValue(usedMb)) {
            return RawDataConstants.ABSENT_LONG;
        }
        return this.getFactory().createLong(Long.valueOf(usedMb));
    }

    @Override
    @Generated
    public String toString() {
        return "AixVolume(super=" + super.toString() + ", volume=" + String.valueOf(this.volume) + ", validVolumePartitionNames=" + String.valueOf(this.validVolumePartitionNames) + ")";
    }
}

