/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.aix;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentFactory;
import com.appdynamics.sim.agent.extensions.servers.model.Cpu;
import com.appdynamics.sim.agent.extensions.servers.model.Cpus;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.aix.AixRawData;
import com.appdynamics.sim.agent.extensions.servers.model.filter.Filters;
import com.appdynamics.sim.agent.extensions.servers.model.transformer.Transformer;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public class AixCpus
extends Cpus<AixRawData> {
    private AixRawData.LparProperties lparProperties;
    private AixRawData.CpuPerf cpuPerf;

    @Inject
    protected AixCpus(@NonNull SimAgentRepetitiveLogger repetitiveLogger, @NonNull ComponentFactory<AixRawData, Cpu<AixRawData>> cpuFactory, @NonNull MetricsService metricsService, @NonNull MachineProperties machineProperties, @NonNull Filters<Cpu<AixRawData>> filters, @NonNull Set<Transformer<Cpu<AixRawData>>> metadataTransformers, @NonNull Predicate<ToggleableReporter<AixRawData>> isDisabledPredicate) {
        super(repetitiveLogger, cpuFactory, metricsService, machineProperties, filters, metadataTransformers, isDisabledPredicate);
        if (repetitiveLogger == null) {
            throw new NullPointerException("repetitiveLogger is marked non-null but is null");
        }
        if (cpuFactory == null) {
            throw new NullPointerException("cpuFactory is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (metadataTransformers == null) {
            throw new NullPointerException("metadataTransformers is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
    }

    @Override
    protected Set<String> extractIds(AixRawData rawData) {
        return Collections.unmodifiableSet(rawData.getCpus().keySet());
    }

    @Override
    protected void doAggregateUpdate(AixRawData rawData) {
        this.cpuPerf = rawData.getCpuPerfs().get("_Total");
        this.lparProperties = rawData.getLparProperties();
    }

    @Override
    protected long getPercentIdle() {
        return Math.round(this.cpuPerf.getIdlePct());
    }

    @Override
    protected long getPercentBusy() {
        return 100L - this.getPercentIdle();
    }

    @Override
    protected Optional<Long> getPercentStolen() {
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getPercentUser() {
        return Optional.of((Object)Math.round(this.cpuPerf.getUserPct()));
    }

    @Override
    protected Optional<Long> getPercentSystem() {
        return Optional.of((Object)Math.round(this.cpuPerf.getSystemPct()));
    }

    @Override
    protected Map<String, String> getOsSpecificProperties() {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"LPAR|Node Name", (Object)this.lparProperties.getNodeName());
        properties.put((Object)"LPAR|Partition Name", (Object)this.lparProperties.getPartitionName());
        properties.put((Object)"LPAR|Partition Number", (Object)this.lparProperties.getPartitionNumber());
        properties.put((Object)"LPAR|Type", (Object)this.lparProperties.getType());
        properties.put((Object)"LPAR|Mode", (Object)this.lparProperties.getMode());
        properties.put((Object)"LPAR|Entitled Capacity", (Object)this.lparProperties.getEntitledCapacity());
        properties.put((Object)"LPAR|Physical CPU Percentage", (Object)this.lparProperties.getPhysicalCpuPercentage());
        properties.put((Object)"LPAR|Power Saving Mode", (Object)this.lparProperties.getPowerSavingMode());
        properties.put((Object)"LPAR|Active Physical CPUs in System", (Object)String.valueOf(this.lparProperties.getActivePhysicalCpusInSystem()));
        properties.put((Object)"LPAR|Active CPUs in Pool", (Object)this.lparProperties.getActiveCpusInPool());
        return properties.build();
    }

    @Override
    protected Optional<Long> getPercentNice() {
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getPercentIRQ() {
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getPercentSoftIRQ() {
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getPercentIoWait() {
        return Optional.absent();
    }

    @Override
    @Generated
    public String toString() {
        return "AixCpus(super=" + super.toString() + ", lparProperties=" + String.valueOf(this.lparProperties) + ", cpuPerf=" + String.valueOf(this.cpuPerf) + ")";
    }
}

