/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataConstants;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItemUtil;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentFactory;
import com.appdynamics.sim.agent.extensions.servers.model.Components;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.Volume;
import com.appdynamics.sim.agent.extensions.servers.model.filter.Filters;
import com.appdynamics.sim.agent.extensions.servers.model.transformer.Transformer;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.google.common.base.Predicate;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public abstract class Volumes<T>
extends Components<T, Volume<T>> {
    private static final String NAME = "volumes";
    private final MetricsService metricsService;
    private final RawDataFactory factory;
    private final RawDataItemUtil dataItemUtil;
    private RawDataLong totalVolumeCount;

    protected Volumes(@Sim @NonNull MetricsService metricsService, @NonNull SimAgentRepetitiveLogger repetitiveLogger, @NonNull ComponentFactory<T, Volume<T>> volumeFactory, @NonNull Filters<Volume<T>> filters, @NonNull Set<Transformer<Volume<T>>> metadataTransformers, @NonNull Predicate<ToggleableReporter<T>> isDisabledPredicate, @NonNull RawDataFactory factory, @NonNull RawDataItemUtil dataItemUtil) {
        super(repetitiveLogger, volumeFactory, filters, metadataTransformers, isDisabledPredicate);
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (repetitiveLogger == null) {
            throw new NullPointerException("repetitiveLogger is marked non-null but is null");
        }
        if (volumeFactory == null) {
            throw new NullPointerException("volumeFactory is marked non-null but is null");
        }
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (metadataTransformers == null) {
            throw new NullPointerException("metadataTransformers is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (dataItemUtil == null) {
            throw new NullPointerException("dataItemUtil is marked non-null but is null");
        }
        this.metricsService = metricsService;
        this.factory = factory;
        this.dataItemUtil = dataItemUtil;
    }

    @Override
    protected void doAggregateReporting(T rawData, Map<String, ? extends Volume<T>> volumes, ReportMetricsConfig reportMetricsConfig) {
        RawDataLong totalMb = RawDataConstants.ZERO_LONG;
        RawDataLong usedMb = RawDataConstants.ZERO_LONG;
        for (Volume<T> volume : volumes.values()) {
            totalMb = this.dataItemUtil.aggregate(totalMb, volume.getSizeMb());
            usedMb = this.dataItemUtil.aggregate(usedMb, volume.getUsedMb());
        }
        if (reportMetricsConfig.isReportSimMetrics()) {
            this.metricsService.reportMetric("Hardware Resources|Volumes|Total (MB)", ExtensionMetricAggregatorType.AVERAGE, totalMb);
            this.metricsService.reportMetric("Hardware Resources|Volumes|Used (MB)", ExtensionMetricAggregatorType.AVERAGE, usedMb);
            this.metricsService.reportMetric("Hardware Resources|Volumes|Free (MB)", ExtensionMetricAggregatorType.AVERAGE, CalculationUtils.subtract(totalMb, usedMb, this.factory));
            this.metricsService.reportMetric("Hardware Resources|Volumes|Used (%)", ExtensionMetricAggregatorType.AVERAGE, CalculationUtils.calculatePercentage(usedMb, totalMb, this.factory));
            this.metricsService.reportMetric("Hardware Resources|Volumes|Count", ExtensionMetricAggregatorType.AVERAGE, this.totalVolumeCount);
        }
    }

    @Override
    public final String getName() {
        return NAME;
    }

    @Override
    protected void doAggregateUpdate(T rawData) {
        this.totalVolumeCount = this.factory.createLong(Long.valueOf(this.extractIds(rawData).size()));
    }

    @Override
    @Generated
    public String toString() {
        return "Volumes(super=" + super.toString() + ")";
    }
}

