/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItemUtil;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Component;
import com.appdynamics.sim.agent.extensions.servers.model.MetricNameUtil;
import com.appdynamics.sim.common.biz.shared.machines.SimMachineProperties;
import com.google.common.base.Optional;
import com.singularity.ee.controller.api.constants.HardwarePerformanceMetricsTemplates;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Volume<T>
implements Component<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Volume.class);
    private final String mountPoint;
    private final MetricsService metricsService;
    private final MachineProperties machineProperties;
    private final RawDataFactory factory;
    private final RawDataItemUtil dataItemUtil;
    private final String escMountPoint;
    private final String propertyNameMountPoint;
    private final String propertyNameSize;
    private final String propertyNamePartition;
    private final String propertyNameVolumeMetricName;
    private final String propertyNamePartitionMetricName;

    protected Volume(@NonNull String mountPoint, @Sim @NonNull MetricsService metricsService, @Sim @NonNull MachineProperties machineProperties, @NonNull RawDataFactory factory, RawDataItemUtil dataItemUtil) {
        if (mountPoint == null) {
            throw new NullPointerException("mountPoint is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        this.mountPoint = mountPoint;
        this.metricsService = metricsService;
        this.machineProperties = machineProperties;
        this.factory = factory;
        this.dataItemUtil = dataItemUtil;
        this.escMountPoint = MetricNameUtil.escapeMetricNameSegment(mountPoint);
        this.propertyNameMountPoint = SimMachineProperties.format((String)"Volume|{0}|MountPoint", (String)mountPoint);
        this.propertyNameSize = SimMachineProperties.format((String)"Volume|{0}|Size (MB)", (String)mountPoint);
        this.propertyNamePartition = SimMachineProperties.format((String)"Volume|{0}|Partition", (String)mountPoint);
        this.propertyNameVolumeMetricName = SimMachineProperties.format((String)"Volume|{0}|VolumeMetricName", (String)mountPoint);
        this.propertyNamePartitionMetricName = SimMachineProperties.format((String)"Volume|{0}|PartitionMetricName", (String)mountPoint);
    }

    @Override
    public final void report(T rawData, ReportMetricsConfig reportMetricsConfig) {
        this.doReporting(reportMetricsConfig);
    }

    public void doReporting(ReportMetricsConfig reportMetricsConfig) {
        RawDataLong totalMb = this.getSizeMb();
        RawDataLong usedMb = this.getUsedMb();
        if (reportMetricsConfig.isReportSimMetrics()) {
            this.metricsService.reportMetric(this.getTotalMbMetricName(), ExtensionMetricAggregatorType.AVERAGE, totalMb);
            this.metricsService.reportMetric(this.getUsedMbMetricName(), ExtensionMetricAggregatorType.AVERAGE, usedMb);
            this.metricsService.reportMetric(this.getFreeMbMetricName(), ExtensionMetricAggregatorType.AVERAGE, this.getFreeMb());
            this.metricsService.reportMetric(this.getUsedPctMetricName(), ExtensionMetricAggregatorType.AVERAGE, this.getUsedPctValue());
            this.machineProperties.updateProperty(this.propertyNameMountPoint, this.mountPoint);
            this.machineProperties.updateProperty(this.propertyNameSize, this.dataItemUtil.rawDataLongToRawDataString(totalMb), Optional.absent());
            this.machineProperties.updateProperty(this.propertyNameVolumeMetricName, this.escMountPoint);
            RawDataString partition = this.getPartition();
            RawDataString partitionDisplayName = this.getPartitionDisplayName();
            if (partition.isPresent() && partitionDisplayName.isPresent()) {
                this.machineProperties.updateProperty(this.propertyNamePartitionMetricName, MetricNameUtil.normalizeMetricName(partition.get()));
                this.machineProperties.updateProperty(this.propertyNamePartition, partitionDisplayName.get());
            } else {
                log.debug("No valid partition found for volume {}; skip reporting partition name and partition metric name.", (Object)this.mountPoint);
            }
        }
    }

    @Override
    public String getId() {
        return this.mountPoint;
    }

    private String getTotalMbMetricName() {
        return HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Volumes|{0}|Total (MB)", (String)this.escMountPoint);
    }

    private String getUsedMbMetricName() {
        return HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Volumes|{0}|Used (MB)", (String)this.escMountPoint);
    }

    private String getFreeMbMetricName() {
        return HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Volumes|{0}|Free (MB)", (String)this.escMountPoint);
    }

    private String getUsedPctMetricName() {
        return HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Volumes|{0}|Used (%)", (String)this.escMountPoint);
    }

    protected RawDataString getPartitionDisplayName() {
        return this.getPartition();
    }

    protected RawDataLong getUsedPctValue() {
        return this.dataItemUtil.calculatePercentage(this.getUsedMb(), this.getSizeMb());
    }

    protected RawDataLong getFreeMb() {
        return this.getSizeMb().subtract(this.getUsedMb());
    }

    protected abstract RawDataString getPartition();

    protected abstract RawDataLong getSizeMb();

    protected abstract RawDataLong getUsedMb();

    @Generated
    public String toString() {
        return "Volume(mountPoint=" + this.getMountPoint() + ")";
    }

    @Generated
    public String getMountPoint() {
        return this.mountPoint;
    }

    @Generated
    protected RawDataFactory getFactory() {
        return this.factory;
    }

    @Generated
    protected RawDataItemUtil getDataItemUtil() {
        return this.dataItemUtil;
    }
}

