/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model;

import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataBigInt;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;

public class SimObjectMapper
extends ObjectMapper {
    private static final String BLANK_VALUE_ERROR = "Collected value was blank";
    private static final String NOT_A_NUMBER_ERROR = "Expected collected value to be a number but it was not: ";
    private transient RawDataFactory rawDataFactory;

    @Inject
    public SimObjectMapper(RawDataFactory rawDataFactory) {
        this.rawDataFactory = rawDataFactory;
        this.registerModule((Module)this.getModuleWithDeserializers());
    }

    private SimpleModule getModuleWithDeserializers() {
        SimpleModule customModule = new SimpleModule();
        customModule.addDeserializer(String.class, (JsonDeserializer)new StdDeserializer<String>(String.class){

            public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String result = p.getValueAsString();
                if (StringUtils.isBlank((CharSequence)result)) {
                    return UnknownValueUtil.getUnknownValueStr();
                }
                return result;
            }
        });
        customModule.addDeserializer(Long.TYPE, (JsonDeserializer)new StdDeserializer<Long>(Long.class){

            public Long deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                if (StringUtils.isBlank((CharSequence)p.getValueAsString())) {
                    return UnknownValueUtil.getUnknownValue();
                }
                return Long.valueOf(p.getValueAsString());
            }
        });
        customModule.addDeserializer(Integer.TYPE, (JsonDeserializer)new StdDeserializer<Integer>(Integer.class){

            public Integer deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                if (StringUtils.isBlank((CharSequence)p.getValueAsString())) {
                    return (int)UnknownValueUtil.getUnknownValue();
                }
                return Integer.valueOf(p.getValueAsString());
            }
        });
        customModule.addDeserializer(BigInteger.class, (JsonDeserializer)new StdDeserializer<BigInteger>(BigInteger.class){

            public BigInteger deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                if (StringUtils.isBlank((CharSequence)p.getValueAsString())) {
                    return BigInteger.valueOf(UnknownValueUtil.getUnknownValue());
                }
                return new BigInteger(p.getValueAsString());
            }
        });
        customModule.addDeserializer(Double.TYPE, (JsonDeserializer)new StdDeserializer<Double>(Double.class){

            public Double deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String result = p.getValueAsString();
                if (StringUtils.isBlank((CharSequence)result)) {
                    return UnknownValueUtil.getUnknownValue();
                }
                return Double.valueOf(p.getValueAsString());
            }
        });
        customModule.addDeserializer(Float.TYPE, (JsonDeserializer)new StdDeserializer<Float>(Float.class){

            public Float deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                if (StringUtils.isBlank((CharSequence)p.getValueAsString())) {
                    return Float.valueOf(UnknownValueUtil.getUnknownValue());
                }
                return Float.valueOf(p.getValueAsString());
            }
        });
        customModule.addDeserializer(RawDataString.class, (JsonDeserializer)new StdDeserializer<RawDataString>(RawDataString.class){

            public RawDataString deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                if (StringUtils.isBlank((CharSequence)p.getValueAsString())) {
                    return SimObjectMapper.this.rawDataFactory.createString(Optional.absent(), SimObjectMapper.BLANK_VALUE_ERROR);
                }
                return SimObjectMapper.this.rawDataFactory.createString(Optional.of((Object)p.getValueAsString()));
            }
        });
        customModule.addDeserializer(RawDataLong.class, (JsonDeserializer)new StdDeserializer<RawDataLong>(RawDataLong.class){

            public RawDataLong deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String jsonValue = p.getValueAsString();
                if (StringUtils.isBlank((CharSequence)jsonValue)) {
                    return SimObjectMapper.this.rawDataFactory.createLong(SimObjectMapper.BLANK_VALUE_ERROR);
                }
                try {
                    long value = Long.parseLong(jsonValue);
                    return SimObjectMapper.this.rawDataFactory.createLong(Long.valueOf(value));
                }
                catch (NumberFormatException e) {
                    return SimObjectMapper.this.rawDataFactory.createLong(SimObjectMapper.NOT_A_NUMBER_ERROR + jsonValue);
                }
            }
        });
        customModule.addDeserializer(RawDataBigInt.class, (JsonDeserializer)new StdDeserializer<RawDataBigInt>(RawDataBigInt.class){

            public RawDataBigInt deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String jsonValue = p.getValueAsString();
                if (StringUtils.isBlank((CharSequence)jsonValue)) {
                    return SimObjectMapper.this.rawDataFactory.createBigInt(SimObjectMapper.BLANK_VALUE_ERROR);
                }
                try {
                    BigInteger value = new BigInteger(jsonValue);
                    return SimObjectMapper.this.rawDataFactory.createBigInt(value);
                }
                catch (NumberFormatException e) {
                    return SimObjectMapper.this.rawDataFactory.createBigInt(SimObjectMapper.NOT_A_NUMBER_ERROR + jsonValue);
                }
            }
        });
        return customModule;
    }
}

