/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Availability;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentName;
import com.appdynamics.sim.agent.extensions.servers.model.Cpus;
import com.appdynamics.sim.agent.extensions.servers.model.Load;
import com.appdynamics.sim.agent.extensions.servers.model.Memory;
import com.appdynamics.sim.agent.extensions.servers.model.MonitoredProcessClasses;
import com.appdynamics.sim.agent.extensions.servers.model.Networks;
import com.appdynamics.sim.agent.extensions.servers.model.OperatingSystem;
import com.appdynamics.sim.agent.extensions.servers.model.Partitions;
import com.appdynamics.sim.agent.extensions.servers.model.RawCollector;
import com.appdynamics.sim.agent.extensions.servers.model.Reporter;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.Volumes;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Server.class);
    private final Map<ComponentName, ToggleableReporter<T>> componentsByNameMap;
    private final RawCollector<T> rawCollector;
    private final SimAgentRepetitiveLogger repetitiveLogger;

    @Inject
    @VisibleForTesting
    Server(Volumes<T> volumes, Partitions<T> partitions, Cpus<T> cpus, Networks<T> networks, MonitoredProcessClasses<T> monitoredProcessClasses, OperatingSystem<T> operatingSystem, Availability<T> availability, Memory<T> memory, Load<T> load, RawCollector<T> rawCollector, SimAgentRepetitiveLogger repetitiveLogger) {
        this.componentsByNameMap = new HashMap<ComponentName, ToggleableReporter<T>>();
        this.componentsByNameMap.put(ComponentName.VOLUMES, volumes);
        this.componentsByNameMap.put(ComponentName.PARTITIONS, partitions);
        this.componentsByNameMap.put(ComponentName.CPUS, cpus);
        this.componentsByNameMap.put(ComponentName.NETWORKS, networks);
        this.componentsByNameMap.put(ComponentName.MONITORED_PROCESS_CLASSES, monitoredProcessClasses);
        this.componentsByNameMap.put(ComponentName.OPERATING_SYSTEM, operatingSystem);
        this.componentsByNameMap.put(ComponentName.AVAILABILITY, availability);
        this.componentsByNameMap.put(ComponentName.MEMORY, memory);
        this.componentsByNameMap.put(ComponentName.LOAD, load);
        this.componentsByNameMap.put(ComponentName.REMOTE_VOLUMES, volumes);
        this.rawCollector = rawCollector;
        this.repetitiveLogger = repetitiveLogger;
    }

    public void collectAndReport(Set<ComponentName> componentNames, ReportMetricsConfig reportMetricsConfig, long samplingIntervalMillis) {
        Set<String> componentsToCollect = this.getComponentsToCollect(componentNames);
        long maxCollectionTimeMillis = this.getMaxCollectionTimeFromSamplingInterval(samplingIntervalMillis);
        T rawData = this.rawCollector.collectRawData(componentsToCollect, maxCollectionTimeMillis);
        log.trace("#SIM000126 Collected and preprocessed raw data: {}", rawData);
        Set<ToggleableReporter<T>> componentsToReport = this.getComponentsToReport(componentNames);
        for (ToggleableReporter<T> components : componentsToReport) {
            if (components.isDisabled()) {
                this.repetitiveLogger.info(log, "Reporting has been disabled for " + components.getName(), new Object[0]);
                continue;
            }
            try {
                this.updateAndReportForComponent(components, rawData, reportMetricsConfig);
            }
            catch (Exception e) {
                this.repetitiveLogger.warn(log, "Caught exception when collecting and reporting for " + components.getClass().getCanonicalName() + ": {}", new Object[]{e.getMessage()});
            }
        }
    }

    @VisibleForTesting
    void updateAndReportForComponent(Reporter<T> components, T rawData, ReportMetricsConfig reportMetricsConfig) {
        components.update(rawData, reportMetricsConfig);
        components.report(rawData, reportMetricsConfig);
    }

    private Set<ToggleableReporter<T>> getComponentsToReport(Set<ComponentName> componentNames) {
        ImmutableSet.Builder componentsToReportSetBuilder = ImmutableSet.builder();
        for (ComponentName componentName : componentNames) {
            componentsToReportSetBuilder.add(this.componentsByNameMap.get((Object)componentName));
        }
        return componentsToReportSetBuilder.build();
    }

    private Set<String> getComponentsToCollect(Set<ComponentName> componentNames) {
        ImmutableSet.Builder componentsToCollectSetBuilder = ImmutableSet.builder();
        for (ComponentName componentName : componentNames) {
            if (componentName.equals((Object)ComponentName.AVAILABILITY)) continue;
            componentsToCollectSetBuilder.add((Object)componentName.toString());
        }
        return componentsToCollectSetBuilder.build();
    }

    private long getMaxCollectionTimeFromSamplingInterval(long samplingInterval) {
        return (long)((double)samplingInterval * 0.9);
    }

    @Generated
    public Server(Map<ComponentName, ToggleableReporter<T>> componentsByNameMap, RawCollector<T> rawCollector, SimAgentRepetitiveLogger repetitiveLogger) {
        this.componentsByNameMap = componentsByNameMap;
        this.rawCollector = rawCollector;
        this.repetitiveLogger = repetitiveLogger;
    }
}

