/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model;

import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfig;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessClassIdCreator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessClassIdCreator.class);
    private final Provider<ServersMonitorConfig> monitorConfigProvider;

    @Inject
    public ProcessClassIdCreator(Provider<ServersMonitorConfig> monitorConfigProvider) {
        this.monitorConfigProvider = monitorConfigProvider;
    }

    public ProcessClass extractClass(@NonNull String commandLine, @NonNull String processName) {
        if (commandLine == null) {
            throw new NullPointerException("commandLine is marked non-null but is null");
        }
        if (processName == null) {
            throw new NullPointerException("processName is marked non-null but is null");
        }
        int len = ((ServersMonitorConfig)this.monitorConfigProvider.get()).getProcessMonitorConfig().getMaxClassIdLength();
        Optional processClassId = this.searchForAndExtractUserDefinedClassId(commandLine, processName);
        if (!processClassId.isPresent()) {
            processClassId = this.extractProcessClassIdByDefaultSelector(commandLine);
        }
        if (!processClassId.isPresent()) {
            processClassId = Optional.of((Object)processName);
        }
        if (processClassId.isPresent() && ((String)processClassId.get()).length() > len) {
            processClassId = Optional.of((Object)((String)processClassId.get()).substring(0, len));
        }
        return new ProcessClass(processName, (String)processClassId.get());
    }

    private Optional<String> searchForAndExtractUserDefinedClassId(String commandLine, String processName) {
        Map<String, String> classRegex = ((ServersMonitorConfig)this.monitorConfigProvider.get()).getProcessMonitorConfig().getProcessClassSelectorRegexList();
        Optional<String> customClassName = this.extractUserDefinedClassId(commandLine, classRegex);
        if (!customClassName.isPresent()) {
            customClassName = this.extractUserDefinedClassId(processName, classRegex);
        }
        return customClassName;
    }

    private Optional<String> extractUserDefinedClassId(String subject, Map<String, String> regexList) {
        Optional processClassId = Optional.absent();
        for (Map.Entry<String, String> regexEntry : regexList.entrySet()) {
            if (!subject.matches(regexEntry.getValue())) continue;
            processClassId = Optional.of((Object)regexEntry.getKey());
            break;
        }
        return processClassId;
    }

    private Optional<String> extractProcessClassIdByDefaultSelector(String commandLine) {
        Matcher matcher;
        Optional classId = Optional.absent();
        Optional<Pattern> patternOptional = ((ServersMonitorConfig)this.monitorConfigProvider.get()).getProcessMonitorConfig().getDefaultProcessClassSelectorPattern();
        if (patternOptional.isPresent() && commandLine != null && (matcher = ((Pattern)patternOptional.get()).matcher(commandLine)).find()) {
            String extractedClass = matcher.group(1);
            classId = Optional.of((Object)extractedClass);
        }
        return classId;
    }

    public static class ProcessClass {
        private final String processClass;
        private final String processClassId;

        @Generated
        public ProcessClass(String processClass, String processClassId) {
            this.processClass = processClass;
            this.processClassId = processClassId;
        }

        @Generated
        public String getProcessClass() {
            return this.processClass;
        }

        @Generated
        public String getProcessClassId() {
            return this.processClassId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcessClass)) {
                return false;
            }
            ProcessClass other = (ProcessClass)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$processClass = this.getProcessClass();
            String other$processClass = other.getProcessClass();
            if (this$processClass == null ? other$processClass != null : !this$processClass.equals(other$processClass)) {
                return false;
            }
            String this$processClassId = this.getProcessClassId();
            String other$processClassId = other.getProcessClassId();
            return !(this$processClassId == null ? other$processClassId != null : !this$processClassId.equals(other$processClassId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ProcessClass;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $processClass = this.getProcessClass();
            result = result * 59 + ($processClass == null ? 43 : $processClass.hashCode());
            String $processClassId = this.getProcessClassId();
            result = result * 59 + ($processClassId == null ? 43 : $processClassId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ProcessClassIdCreator.ProcessClass(processClass=" + this.getProcessClass() + ", processClassId=" + this.getProcessClassId() + ")";
        }
    }
}

