/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataConstants;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItemUtil;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentFactory;
import com.appdynamics.sim.agent.extensions.servers.model.Components;
import com.appdynamics.sim.agent.extensions.servers.model.Partition;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.filter.Filters;
import com.appdynamics.sim.agent.extensions.servers.model.transformer.Transformer;
import com.google.common.base.Predicate;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public abstract class Partitions<T>
extends Components<T, Partition<T>> {
    private static final String NAME = "partitions";
    private final MetricsService metricsService;
    private final MachineProperties machineProperties;
    private final RawDataFactory factory;
    private final RawDataItemUtil dataItemUtil;
    private boolean firstTime;

    protected Partitions(@Sim @NonNull MetricsService metricsService, @Sim @NonNull MachineProperties machineProperties, @NonNull SimAgentRepetitiveLogger repetitiveLogger, @NonNull ComponentFactory<T, Partition<T>> partitionFactory, @NonNull Filters<Partition<T>> filters, @NonNull Set<Transformer<Partition<T>>> metadataTransformers, @NonNull Predicate<ToggleableReporter<T>> isDisabledPredicate, @NonNull RawDataFactory factory, @NonNull RawDataItemUtil dataItemUtil) {
        super(repetitiveLogger, partitionFactory, filters, metadataTransformers, isDisabledPredicate);
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (repetitiveLogger == null) {
            throw new NullPointerException("repetitiveLogger is marked non-null but is null");
        }
        if (partitionFactory == null) {
            throw new NullPointerException("partitionFactory is marked non-null but is null");
        }
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (metadataTransformers == null) {
            throw new NullPointerException("metadataTransformers is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (dataItemUtil == null) {
            throw new NullPointerException("dataItemUtil is marked non-null but is null");
        }
        this.metricsService = metricsService;
        this.machineProperties = machineProperties;
        this.factory = factory;
        this.firstTime = true;
        this.dataItemUtil = dataItemUtil;
    }

    @Override
    public final String getName() {
        return NAME;
    }

    @Override
    protected void doAggregateReporting(T rawData, Map<String, ? extends Partition<T>> partitions, ReportMetricsConfig reportMetricsConfig) {
        RawDataLong totalReadsPerSec = RawDataConstants.ZERO_LONG;
        RawDataLong totalReadKbPerSec = RawDataConstants.ZERO_LONG;
        RawDataLong totalWritesPerSec = RawDataConstants.ZERO_LONG;
        RawDataLong totalWriteKbPerSec = RawDataConstants.ZERO_LONG;
        RawDataLong utilization = RawDataConstants.ZERO_LONG;
        if (!partitions.isEmpty()) {
            for (Partition<T> partition : partitions.values()) {
                totalReadKbPerSec = this.dataItemUtil.aggregate(totalReadKbPerSec, partition.getReadKbPerSec());
                totalReadsPerSec = this.dataItemUtil.aggregate(totalReadsPerSec, partition.getReadCountPerSec());
                totalWriteKbPerSec = this.dataItemUtil.aggregate(totalWriteKbPerSec, partition.getWriteKbPerSec());
                totalWritesPerSec = this.dataItemUtil.aggregate(totalWritesPerSec, partition.getWriteCountPerSec());
                utilization = this.dataItemUtil.aggregate(utilization, partition.getUtilization());
            }
            RawDataLong partitionSize = this.factory.createLong(Long.valueOf(partitions.size()));
            totalReadsPerSec = totalReadsPerSec.divide(partitionSize);
            totalReadKbPerSec = totalReadKbPerSec.divide(partitionSize);
            totalWritesPerSec = totalWritesPerSec.divide(partitionSize);
            totalWriteKbPerSec = totalWriteKbPerSec.divide(partitionSize);
            utilization = utilization.divide(partitionSize);
        }
        if (!this.firstTime) {
            if (reportMetricsConfig.isReportBasicMetrics()) {
                this.reportAggregateMetric("Hardware Resources|Disks|Reads/sec", ExtensionMetricAggregatorType.AVERAGE, totalReadsPerSec);
                this.reportAggregateMetric("Hardware Resources|Disks|KB read/sec", ExtensionMetricAggregatorType.AVERAGE, totalReadKbPerSec);
                this.reportAggregateMetric("Hardware Resources|Disks|Writes/sec", ExtensionMetricAggregatorType.AVERAGE, totalWritesPerSec);
                this.reportAggregateMetric("Hardware Resources|Disks|KB written/sec", ExtensionMetricAggregatorType.AVERAGE, totalWriteKbPerSec);
            }
            if (reportMetricsConfig.isReportSimMetrics()) {
                this.reportAggregateMetric("Hardware Resources|Disks|Avg IO Utilization (%)", ExtensionMetricAggregatorType.AVERAGE, utilization);
            }
        }
        this.firstTime = false;
    }

    protected boolean shouldReportAggregateMetrics(String metricName) {
        return true;
    }

    private void reportAggregateMetric(String metricName, ExtensionMetricAggregatorType aggregatorType, RawDataLong value) {
        if (this.shouldReportAggregateMetrics(metricName)) {
            this.metricsService.reportMetric(metricName, aggregatorType, value);
        }
    }

    @Override
    @Generated
    public String toString() {
        return "Partitions(super=" + super.toString() + ")";
    }
}

