/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.util.ReportingUtil;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentFactory;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentName;
import com.appdynamics.sim.agent.extensions.servers.model.Components;
import com.appdynamics.sim.agent.extensions.servers.model.Network;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.filter.Filters;
import com.appdynamics.sim.agent.extensions.servers.model.transformer.Transformer;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public abstract class Networks<T>
extends Components<T, Network<T>> {
    private static final ComponentName COMPONENT_NAME = ComponentName.NETWORKS;
    private final MetricsService metricsService;
    private final MachineProperties machineProperties;
    private long totalInterfaceCount;
    private boolean firstTime;

    protected Networks(@Sim @NonNull MetricsService metricsService, @Sim @NonNull MachineProperties machineProperties, @NonNull SimAgentRepetitiveLogger repetitiveLogger, @NonNull ComponentFactory<T, Network<T>> networkFactory, @NonNull Filters<Network<T>> filters, @NonNull Set<Transformer<Network<T>>> metadataTransformers, @NonNull Predicate<ToggleableReporter<T>> isDisabledPredicate) {
        super(repetitiveLogger, networkFactory, filters, metadataTransformers, isDisabledPredicate);
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (repetitiveLogger == null) {
            throw new NullPointerException("repetitiveLogger is marked non-null but is null");
        }
        if (networkFactory == null) {
            throw new NullPointerException("networkFactory is marked non-null but is null");
        }
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (metadataTransformers == null) {
            throw new NullPointerException("metadataTransformers is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
        this.metricsService = metricsService;
        this.machineProperties = machineProperties;
        this.firstTime = true;
    }

    @Override
    protected void doAggregateReporting(T rawData, Map<String, ? extends Network<T>> networks, ReportMetricsConfig reportMetricsConfig) {
        long initialValue;
        long totalIncomingPackets = initialValue = networks.isEmpty() ? 0L : UnknownValueUtil.getUnknownValue();
        long totalOutgoingPackets = initialValue;
        long totalIncomingKb = initialValue;
        long totalOutgoingKb = initialValue;
        long totalIncomingPacketsPerSec = initialValue;
        long totalOutgoingPacketsPerSec = initialValue;
        long totalIncomingKbPerSec = initialValue;
        long totalOutgoingKbPerSec = initialValue;
        long totalIncomingPacketErrors = initialValue;
        long totalOutgoingPacketErrors = initialValue;
        long totalUtilizationPct = initialValue;
        if (!networks.isEmpty()) {
            for (Network<T> network : networks.values()) {
                totalIncomingPackets = CalculationUtils.aggregateComponentValue(totalIncomingPackets, network.getIncomingPackets());
                totalOutgoingPackets = CalculationUtils.aggregateComponentValue(totalOutgoingPackets, network.getOutgoingPackets());
                totalIncomingKb = CalculationUtils.aggregateComponentValue(totalIncomingKb, network.getIncomingKb());
                totalOutgoingKb = CalculationUtils.aggregateComponentValue(totalOutgoingKb, network.getOutgoingKb());
                totalIncomingPacketsPerSec = CalculationUtils.aggregateComponentValue(totalIncomingPacketsPerSec, network.getIncomingPacketsPerSec());
                totalOutgoingPacketsPerSec = CalculationUtils.aggregateComponentValue(totalOutgoingPacketsPerSec, network.getOutgoingPacketsPerSec());
                totalIncomingKbPerSec = CalculationUtils.aggregateComponentValue(totalIncomingKbPerSec, network.getIncomingKbPerSec());
                totalOutgoingKbPerSec = CalculationUtils.aggregateComponentValue(totalOutgoingKbPerSec, network.getOutgoingKbPerSec());
                totalIncomingPacketErrors = CalculationUtils.aggregateComponentValue(totalIncomingPacketErrors, network.getIncomingPacketErrors());
                totalOutgoingPacketErrors = CalculationUtils.aggregateComponentValue(totalOutgoingPacketErrors, network.getOutgoingPacketErrors());
                Optional<Long> utilizationPct = network.getUtilizationPct();
                if (!utilizationPct.isPresent()) continue;
                totalUtilizationPct = CalculationUtils.aggregateComponentValue(totalUtilizationPct, (Long)utilizationPct.get());
            }
            totalUtilizationPct = CalculationUtils.divide(totalUtilizationPct, networks.size());
        }
        if (!this.firstTime) {
            if (reportMetricsConfig.isReportBasicMetrics()) {
                ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Incoming KB", (long)totalIncomingKb);
                ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Outgoing KB", (long)totalOutgoingKb);
                ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Incoming packets", (long)totalIncomingPackets);
                ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Outgoing packets", (long)totalOutgoingPackets);
                ReportingUtil.reportPerSecondMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Incoming KB/sec", (long)totalIncomingKbPerSec);
                ReportingUtil.reportPerSecondMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Outgoing KB/sec", (long)totalOutgoingKbPerSec);
                ReportingUtil.reportPerSecondMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Incoming packets/sec", (long)totalIncomingPacketsPerSec);
                ReportingUtil.reportPerSecondMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Outgoing packets/sec", (long)totalOutgoingPacketsPerSec);
            }
            if (reportMetricsConfig.isReportSimMetrics()) {
                ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Incoming Errors/min", (long)totalIncomingPacketErrors);
                ReportingUtil.reportPerMinuteMetricSample((MetricsService)this.metricsService, (String)"Hardware Resources|Network|Outgoing Errors/min", (long)totalOutgoingPacketErrors);
                this.metricsService.reportMetric("Hardware Resources|Network|Avg Utilization (%)", ExtensionMetricAggregatorType.AVERAGE, totalUtilizationPct);
                this.metricsService.reportMetric("Hardware Resources|Network|Interface Count", ExtensionMetricAggregatorType.AVERAGE, this.totalInterfaceCount);
            }
        }
        this.firstTime = false;
    }

    @Override
    public final String getName() {
        return COMPONENT_NAME.toString();
    }

    @Override
    protected void doAggregateUpdate(T rawData) {
        this.totalInterfaceCount = this.extractIds(rawData).size();
    }

    @Override
    @Generated
    public String toString() {
        return "Networks(super=" + super.toString() + ")";
    }
}

