/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.ProcessProperties;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentFactory;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentName;
import com.appdynamics.sim.agent.extensions.servers.model.Components;
import com.appdynamics.sim.agent.extensions.servers.model.MonitoredProcessClass;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.filter.Filters;
import com.appdynamics.sim.agent.extensions.servers.model.transformer.Transformer;
import com.appdynamics.sim.processes.agent.rest.SimProcessesAgentService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MonitoredProcessClasses<RAWDATA>
extends Components<RAWDATA, MonitoredProcessClass<RAWDATA>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitoredProcessClasses.class);
    private static final ComponentName COMPONENT_NAME = ComponentName.MONITORED_PROCESS_CLASSES;
    private final MetricsService metricsService;
    private final SimProcessesAgentService processesAgentService;
    private final String hostId;
    private final ProcessProperties processProperties;
    private RawDataLong totalProcessCount;
    @VisibleForTesting
    private boolean firstTime;

    protected MonitoredProcessClasses(@NonNull String hostId, @NonNull SimProcessesAgentService processesAgentService, @NonNull SimAgentRepetitiveLogger repetitiveLogger, @NonNull ComponentFactory<RAWDATA, MonitoredProcessClass<RAWDATA>> componentFactory, @NonNull Filters<MonitoredProcessClass<RAWDATA>> filters, @NonNull Set<Transformer<MonitoredProcessClass<RAWDATA>>> metadataTransformers, @NonNull ProcessProperties processProperties, @Sim @NonNull MetricsService metricsService, @NonNull Predicate<ToggleableReporter<RAWDATA>> isDisabledPredicate) {
        super(repetitiveLogger, componentFactory, filters, metadataTransformers, isDisabledPredicate);
        if (hostId == null) {
            throw new NullPointerException("hostId is marked non-null but is null");
        }
        if (processesAgentService == null) {
            throw new NullPointerException("processesAgentService is marked non-null but is null");
        }
        if (repetitiveLogger == null) {
            throw new NullPointerException("repetitiveLogger is marked non-null but is null");
        }
        if (componentFactory == null) {
            throw new NullPointerException("componentFactory is marked non-null but is null");
        }
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (metadataTransformers == null) {
            throw new NullPointerException("metadataTransformers is marked non-null but is null");
        }
        if (processProperties == null) {
            throw new NullPointerException("processProperties is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
        this.metricsService = metricsService;
        this.hostId = hostId;
        this.processesAgentService = processesAgentService;
        this.firstTime = true;
        this.processProperties = processProperties;
    }

    @Override
    protected void doAggregateReporting(RAWDATA rawData, Map<String, ? extends MonitoredProcessClass<RAWDATA>> monitoredProcessClasses, ReportMetricsConfig reportMetricsConfig) {
        if (this.firstTime) {
            this.firstTime = false;
            return;
        }
        if (reportMetricsConfig.isReportSimMetrics()) {
            this.metricsService.reportMetric("Hardware Resources|Process|Total Process Count", ExtensionMetricAggregatorType.AVERAGE, this.totalProcessCount);
            this.processProperties.readyToReport();
        }
    }

    @Override
    public final String getName() {
        return COMPONENT_NAME.toString();
    }

    @Override
    protected void doAggregateUpdate(RAWDATA rawData) {
        this.totalProcessCount = this.getTotalProcessCount(rawData);
    }

    protected abstract RawDataLong getTotalProcessCount(RAWDATA var1);

    @Override
    @Generated
    public String toString() {
        return "MonitoredProcessClasses(super=" + super.toString() + ", metricsService=" + String.valueOf(this.metricsService) + ", processesAgentService=" + String.valueOf(this.processesAgentService) + ", hostId=" + this.hostId + ", processProperties=" + String.valueOf(this.processProperties) + ", totalProcessCount=" + String.valueOf(this.totalProcessCount) + ", firstTime=" + this.firstTime + ")";
    }

    @Generated
    void setFirstTime(boolean firstTime) {
        this.firstTime = firstTime;
    }
}

