/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Component;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentName;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.appdynamics.sim.common.biz.shared.machines.SimMachineProperties;
import com.google.common.base.Predicate;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Memory<T>
implements Component<T>,
ToggleableReporter<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Memory.class);
    private static final ComponentName COMPONENT_NAME = ComponentName.MEMORY;
    private static final long ONE_HUNDRED = 100L;
    private static final String PHYSICAL = "Physical";
    private static final String SWAP = "Swap";
    private final String memoryName;
    protected final MetricsService metricsService;
    private final MachineProperties machineProperties;
    private final Predicate<ToggleableReporter<T>> isDisabledPredicate;
    private final String propertyNamePhysicalMemory;
    private final String propertyNameSwapMemory;
    private final String propertyNamePhysicalSize;
    private final String propertyNameSwapSize;
    private final RawDataFactory rawDataFactory;

    protected Memory(@NonNull String memoryName, @Sim @NonNull MetricsService metricsService, @Sim @NonNull MachineProperties machineProperties, @NonNull Predicate<ToggleableReporter<T>> isDisabledPredicate, @NonNull RawDataFactory rawDataFactory) {
        if (memoryName == null) {
            throw new NullPointerException("memoryName is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
        if (rawDataFactory == null) {
            throw new NullPointerException("rawDataFactory is marked non-null but is null");
        }
        this.memoryName = memoryName;
        this.metricsService = metricsService;
        this.machineProperties = machineProperties;
        this.isDisabledPredicate = isDisabledPredicate;
        this.rawDataFactory = rawDataFactory;
        this.propertyNamePhysicalMemory = SimMachineProperties.format((String)"Memory|{0}|Type", (String)PHYSICAL);
        this.propertyNameSwapMemory = SimMachineProperties.format((String)"Memory|{0}|Type", (String)SWAP);
        this.propertyNamePhysicalSize = SimMachineProperties.format((String)"Memory|{0}|Size (MB)", (String)PHYSICAL);
        this.propertyNameSwapSize = SimMachineProperties.format((String)"Memory|{0}|Size (MB)", (String)SWAP);
    }

    @Override
    public void report(T rawData, ReportMetricsConfig reportMetricsConfig) {
        if (reportMetricsConfig.isReportBasicMetrics()) {
            this.metricsService.reportMetric("Hardware Resources|Memory|Total (MB)", ExtensionMetricAggregatorType.AVERAGE, this.getPhysicalTotalMb());
            this.metricsService.reportMetric("Hardware Resources|Memory|Used (MB)", ExtensionMetricAggregatorType.AVERAGE, this.getPhysicalUsedMb());
            this.metricsService.reportMetric("Hardware Resources|Memory|Free (MB)", ExtensionMetricAggregatorType.AVERAGE, this.getPhysicalFreeMb());
            this.metricsService.reportMetric("Hardware Resources|Memory|Used %", ExtensionMetricAggregatorType.AVERAGE, this.getPhysicalUsedPct());
            this.metricsService.reportMetric("Hardware Resources|Memory|Free %", ExtensionMetricAggregatorType.AVERAGE, this.getPhysicalFreePct());
        }
        if (reportMetricsConfig.isReportSimMetrics()) {
            this.metricsService.reportMetric("Hardware Resources|Memory|Swap Total (MB)", ExtensionMetricAggregatorType.AVERAGE, this.getSwapTotalMb());
            this.metricsService.reportMetric("Hardware Resources|Memory|Swap Used (MB)", ExtensionMetricAggregatorType.AVERAGE, this.getSwapUsedMb());
            this.metricsService.reportMetric("Hardware Resources|Memory|Swap Free (MB)", ExtensionMetricAggregatorType.AVERAGE, this.getSwapFreeMb());
            this.metricsService.reportMetric("Hardware Resources|Memory|Swap Used %", ExtensionMetricAggregatorType.AVERAGE, this.getSwapUsedPct());
            this.metricsService.reportMetric("Hardware Resources|Memory|Swap Free %", ExtensionMetricAggregatorType.AVERAGE, this.getSwapFreePct());
            RawDataLong physicalTotalMb = this.getPhysicalTotalMb();
            RawDataLong swapTotalMb = this.getSwapTotalMb();
            if (physicalTotalMb.isPresent()) {
                this.machineProperties.updateProperty(this.propertyNamePhysicalMemory, PHYSICAL);
                this.machineProperties.updateProperty(this.propertyNamePhysicalSize, String.valueOf(physicalTotalMb.get()));
            } else {
                log.debug("Could not report physical total memory property. Error: {}", (Object)physicalTotalMb.getError());
            }
            if (swapTotalMb.isPresent()) {
                this.machineProperties.updateProperty(this.propertyNameSwapMemory, SWAP);
                this.machineProperties.updateProperty(this.propertyNameSwapSize, String.valueOf(swapTotalMb.get()));
            } else {
                log.debug("Could not report swap total memory property. Error: {}", (Object)swapTotalMb.getError());
            }
        }
    }

    @Override
    public final String getName() {
        return COMPONENT_NAME.toString();
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabledPredicate.apply((Object)this);
    }

    @Override
    public String getId() {
        return this.memoryName;
    }

    protected abstract RawDataLong getSwapTotalMb();

    protected abstract RawDataLong getSwapFreeMb();

    protected abstract RawDataLong getPhysicalTotalMb();

    protected abstract RawDataLong getPhysicalFreeMb();

    protected RawDataLong getSwapUsedMb() {
        RawDataLong swapUsedMb = CalculationUtils.subtract(this.getSwapTotalMb(), this.getSwapFreeMb(), this.rawDataFactory);
        log.debug("getSwapUsedMb - {}", (Object)swapUsedMb);
        return swapUsedMb;
    }

    protected RawDataLong getPhysicalUsedMb() {
        RawDataLong physicalUsedMb = CalculationUtils.subtract(this.getPhysicalTotalMb(), this.getPhysicalFreeMb(), this.rawDataFactory);
        log.debug("getPhysicalUsedMb - {}", (Object)physicalUsedMb);
        return physicalUsedMb;
    }

    protected RawDataLong getSwapFreePct() {
        RawDataLong swapFreePct = CalculationUtils.calculatePercentage(this.getSwapFreeMb(), this.getSwapTotalMb(), this.rawDataFactory);
        log.debug("getSwapFreePct - {}", (Object)swapFreePct);
        return swapFreePct;
    }

    protected RawDataLong getPhysicalFreePct() {
        RawDataLong physicalFreePct = CalculationUtils.calculatePercentage(this.getPhysicalFreeMb(), this.getPhysicalTotalMb(), this.rawDataFactory);
        log.debug("getPhysicalFreePct - {}", (Object)physicalFreePct);
        return physicalFreePct;
    }

    protected RawDataLong getSwapUsedPct() {
        RawDataLong swapUsedPct = CalculationUtils.calculatePercentage(this.getSwapUsedMb(), this.getSwapTotalMb(), this.rawDataFactory);
        log.debug("getSwapUsedPct - {}", (Object)swapUsedPct);
        return swapUsedPct;
    }

    protected RawDataLong getPhysicalUsedPct() {
        RawDataLong oneHundred = this.rawDataFactory.createLong(Long.valueOf(100L));
        RawDataLong physicalUsedPct = CalculationUtils.subtract(oneHundred, this.getPhysicalFreePct(), this.rawDataFactory);
        log.debug("getPhysicalUsedPct - {}", (Object)physicalUsedPct);
        return physicalUsedPct;
    }

    @Generated
    protected String getMemoryName() {
        return this.memoryName;
    }
}

