/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItemUtil;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Component;
import com.appdynamics.sim.common.biz.shared.machines.SimMachineProperties;
import com.google.common.base.Optional;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public abstract class Cpu<T>
implements Component<T> {
    protected static final String UNKNOWN = "unknown";
    private final String cpuId;
    private final MachineProperties machineProperties;
    private final RawDataItemUtil rawDataItemUtil;
    private final String propertyNameCpuId;
    private final String propertyNameCoreCount;
    private final String propertyNameLogicalCount;
    private final String propertyNameVendor;
    private final String propertyNameModel;
    private final String propertyNameMaxSpeed;

    protected Cpu(@NonNull String cpuId, @Sim @NonNull MachineProperties machineProperties, @NonNull RawDataItemUtil rawDataItemUtil) {
        if (cpuId == null) {
            throw new NullPointerException("cpuId is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (rawDataItemUtil == null) {
            throw new NullPointerException("rawDataItemUtil is marked non-null but is null");
        }
        this.cpuId = cpuId;
        this.machineProperties = machineProperties;
        this.rawDataItemUtil = rawDataItemUtil;
        this.propertyNameCpuId = SimMachineProperties.format((String)"CPU|{0}|CPU ID", (String)cpuId);
        this.propertyNameCoreCount = SimMachineProperties.format((String)"CPU|{0}|Core Count", (String)cpuId);
        this.propertyNameLogicalCount = SimMachineProperties.format((String)"CPU|{0}|Logical Processor Count", (String)cpuId);
        this.propertyNameVendor = SimMachineProperties.format((String)"CPU|{0}|Vendor", (String)cpuId);
        this.propertyNameModel = SimMachineProperties.format((String)"CPU|{0}|Model Name", (String)cpuId);
        this.propertyNameMaxSpeed = SimMachineProperties.format((String)"CPU|{0}|Max Speed MHz", (String)cpuId);
    }

    @Override
    public void report(T rawData, ReportMetricsConfig reportMetricsConfig) {
        if (reportMetricsConfig.isReportSimMetrics()) {
            this.machineProperties.updateProperty(this.propertyNameCpuId, this.cpuId);
            this.machineProperties.updateProperty(this.propertyNameCoreCount, this.rawDataItemUtil.rawDataLongToRawDataString(this.getNumCores()), Optional.absent());
            this.machineProperties.updateProperty(this.propertyNameLogicalCount, this.rawDataItemUtil.rawDataLongToRawDataString(this.getNumLogicalProcessors()), Optional.absent());
            this.machineProperties.updateProperty(this.propertyNameVendor, this.getCpuVendor(), Optional.of((Object)UNKNOWN));
            this.machineProperties.updateProperty(this.propertyNameModel, this.getCpuModel(), Optional.of((Object)UNKNOWN));
            this.machineProperties.updateProperty(this.propertyNameMaxSpeed, this.getCpuMaxSpeedMhz(), Optional.of((Object)UNKNOWN));
            for (String property : this.getOsSpecificProperties().keySet()) {
                this.machineProperties.updateProperty(SimMachineProperties.format((String)property, (String)this.cpuId), this.getOsSpecificProperties().get(property), Optional.absent());
            }
        }
    }

    @Override
    public String getId() {
        return this.cpuId;
    }

    protected abstract RawDataLong getNumCores();

    protected abstract RawDataLong getNumLogicalProcessors();

    protected abstract RawDataString getCpuVendor();

    protected abstract RawDataString getCpuModel();

    protected abstract RawDataString getCpuMaxSpeedMhz();

    protected abstract RawDataString getCpuCurrentSpeedMhz();

    protected Map<String, RawDataString> getOsSpecificProperties() {
        return Collections.emptyMap();
    }

    @Generated
    public String toString() {
        return "Cpu(cpuId=" + this.getCpuId() + ")";
    }

    @Generated
    protected String getCpuId() {
        return this.cpuId;
    }
}

