/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.collector;

import com.appdynamics.agent.sim.encryption.DecryptionService;
import com.appdynamics.sim.agent.extensions.servers.collector.RawSimCollectorScriptPath;
import com.appdynamics.sim.agent.extensions.servers.model.RawCollector;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.InputStream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalSimCollectorScriptContentProvider
implements Provider<Optional<String>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalSimCollectorScriptContentProvider.class);
    private final String simCollectorScriptPath;
    private final Class<? extends RawCollector<?>> rawCollectorClass;
    private final DecryptionService decryptor;

    @Inject
    LocalSimCollectorScriptContentProvider(@RawSimCollectorScriptPath String simCollectorScriptPath, @NonNull Class<? extends RawCollector<?>> rawCollectorClass, @NonNull DecryptionService decryptor) {
        if (rawCollectorClass == null) {
            throw new NullPointerException("rawCollectorClass is marked non-null but is null");
        }
        if (decryptor == null) {
            throw new NullPointerException("decryptor is marked non-null but is null");
        }
        this.simCollectorScriptPath = simCollectorScriptPath;
        this.rawCollectorClass = rawCollectorClass;
        this.decryptor = decryptor;
    }

    public Optional<String> get() {
        InputStream stream = this.getInputStreamFromPath(this.rawCollectorClass, this.simCollectorScriptPath);
        Optional decryptedScriptContent = this.decryptor.decryptInputStream(stream);
        return decryptedScriptContent;
    }

    @VisibleForTesting
    InputStream getInputStreamFromPath(Class<?> rawCollectorClass, String simCollectorScriptPath) {
        return rawCollectorClass.getResourceAsStream(simCollectorScriptPath);
    }
}

