/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimPropertiesService
implements MachineProperties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimPropertiesService.class);
    private final MachineProperties machineProperties;

    @Inject
    SimPropertiesService(MachineProperties machineProperties) {
        this.machineProperties = machineProperties;
    }

    public void updateProperty(String name, String value) {
        if (!UnknownValueUtil.isUnknownValue(value)) {
            this.machineProperties.updateProperty(name, value);
        } else {
            log.debug("Not reporting property with name {}, its value is unknown.", (Object)name);
        }
    }

    public void updateProperty(String name, RawDataString rawValue, Optional<String> defaultValue) {
        if (!rawValue.isPresent()) {
            log.debug("Error getting property for {}: {}", (Object)name, (Object)rawValue.getError());
            if (defaultValue.isPresent()) {
                this.updateProperty(name, (String)defaultValue.get());
            }
        } else {
            this.updateProperty(name, rawValue.get());
        }
    }

    public Map<String, String> toMap() {
        return this.machineProperties.toMap();
    }
}

