/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers;

import com.appdynamics.agent.sim.tags.MachineTagMapName;
import com.appdynamics.agent.sim.tags.MachineTags;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.tags.AwsTagsScheduledRunner;
import com.appdynamics.sim.agent.extensions.servers.tags.AzureTagsScheduledRunner;
import com.appdynamics.sim.agent.extensions.servers.tags.K8sNodeTagsScheduledRunner;
import com.appdynamics.sim.agent.extensions.servers.tags.K8sTagsScheduledRunner;
import com.appdynamics.sim.agent.extensions.servers.tags.ServiceNowTagsScheduledRunner;
import com.appdynamics.sim.agent.extensions.servers.tags.SmartAgentTagsScheduledRunner;
import com.appdynamics.sim.agent.extensions.servers.tags.UrlMonitoringScheduledRunner;
import com.appdynamics.voltron.configuration.ConfigurationListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServersMonitorConfigListener
implements ConfigurationListener<ServersMonitorConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServersMonitorConfigListener.class);
    private final MachineTags machineTags;
    private Optional<ServersMonitorConfig> monitorConfig = Optional.absent();
    private AwsTagsScheduledRunner awsTagsScheduledRunner;
    private K8sTagsScheduledRunner k8sTagsScheduledRunner;
    private AzureTagsScheduledRunner azureTagsScheduledRunner;
    private ServiceNowTagsScheduledRunner serviceNowTagsScheduledRunner;
    private K8sNodeTagsScheduledRunner k8sNodeTagsScheduledRunner;
    private SmartAgentTagsScheduledRunner smartAgentTagsScheduledRunner;
    private UrlMonitoringScheduledRunner urlMonitoringScheduledRunner;

    @Inject
    ServersMonitorConfigListener(MachineTags machineTags, AwsTagsScheduledRunner awsTagsScheduledRunner, K8sTagsScheduledRunner k8sTagsScheduledRunner, AzureTagsScheduledRunner azureTagsScheduledRunner, ServiceNowTagsScheduledRunner serviceNowTagsScheduledRunner, K8sNodeTagsScheduledRunner k8sNodeTagsScheduledRunner, SmartAgentTagsScheduledRunner smartAgentTagsScheduledRunner, UrlMonitoringScheduledRunner urlMonitoringScheduledRunner) {
        this.machineTags = machineTags;
        this.awsTagsScheduledRunner = awsTagsScheduledRunner;
        this.k8sTagsScheduledRunner = k8sTagsScheduledRunner;
        this.azureTagsScheduledRunner = azureTagsScheduledRunner;
        this.k8sNodeTagsScheduledRunner = k8sNodeTagsScheduledRunner;
        this.smartAgentTagsScheduledRunner = smartAgentTagsScheduledRunner;
        this.serviceNowTagsScheduledRunner = serviceNowTagsScheduledRunner;
        this.urlMonitoringScheduledRunner = urlMonitoringScheduledRunner;
    }

    public void apply(String configName, ServersMonitorConfig configuration) {
        boolean changed;
        if (configuration == null) {
            log.warn("Received null Monitor Config.");
            changed = false;
        } else {
            boolean bl = changed = !this.monitorConfig.isPresent() || !((ServersMonitorConfig)this.monitorConfig.get()).equals(configuration);
        }
        if (changed) {
            this.monitorConfig = Optional.of((Object)configuration);
            this.resolveAwsConfiguration(configuration);
            this.resolveAzureConfiguration(configuration);
            this.resolveK8sConfiguration(configuration);
            this.resolveK8sNodeConfiguration(configuration);
            this.resolveServiceNowConfiguration(configuration);
            this.resolveSmartAgentConfiguration(configuration);
            this.resolveUrlMonitoringConfiguration(configuration);
            this.machineTags.updateTagMap(MachineTagMapName.SERVER_MONITOR_CONFIG_TAG_MAP, configuration.getTags());
        }
    }

    @VisibleForTesting
    void resolveAwsConfiguration(ServersMonitorConfig configuration) {
        if (configuration.getAwsTagsConfig().getEnabled().booleanValue()) {
            this.awsTagsScheduledRunner.tryStart();
        } else {
            this.awsTagsScheduledRunner.tryStop();
        }
    }

    @VisibleForTesting
    void resolveAzureConfiguration(ServersMonitorConfig configuration) {
        if (configuration.getAzureTagsConfig().getEnabled().booleanValue()) {
            this.azureTagsScheduledRunner.tryStart();
        } else {
            this.azureTagsScheduledRunner.tryStop();
        }
    }

    @VisibleForTesting
    void resolveK8sConfiguration(ServersMonitorConfig configuration) {
        if (configuration.getK8sTagsConfig().getEnabled().booleanValue()) {
            this.k8sTagsScheduledRunner.tryStart();
        } else {
            this.k8sTagsScheduledRunner.tryStop();
        }
    }

    @VisibleForTesting
    void resolveK8sNodeConfiguration(ServersMonitorConfig configuration) {
        if (configuration.getK8sNodeTagsConfig().getEnabled().booleanValue()) {
            this.k8sNodeTagsScheduledRunner.tryStart();
        } else {
            this.k8sNodeTagsScheduledRunner.tryStop();
        }
    }

    @VisibleForTesting
    void resolveSmartAgentConfiguration(ServersMonitorConfig configuration) {
        if (configuration.getSmartAgentTagsConfig().getEnabled().booleanValue()) {
            this.smartAgentTagsScheduledRunner.tryStart();
        } else {
            this.smartAgentTagsScheduledRunner.tryStop();
        }
    }

    @VisibleForTesting
    void resolveServiceNowConfiguration(ServersMonitorConfig configuration) {
        if (configuration.getServiceNowTagsConfig().getEnabled().booleanValue()) {
            this.serviceNowTagsScheduledRunner.tryStart();
        } else {
            this.serviceNowTagsScheduledRunner.tryStop();
        }
    }

    void resolveUrlMonitoringConfiguration(ServersMonitorConfig configuration) {
        if (configuration.getUrlMonitoringConfig().getEnabled().booleanValue()) {
            this.urlMonitoringScheduledRunner.tryStart();
        } else {
            this.urlMonitoringScheduledRunner.tryStop();
        }
    }
}

