/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers;

import com.appdynamics.agent.sim.encryption.DecryptIvString;
import com.appdynamics.agent.sim.encryption.DecryptKeyString;
import com.appdynamics.agent.sim.encryption.DecryptMessageDigestAlgo;
import com.appdynamics.agent.sim.encryption.DecryptionService;
import com.appdynamics.agent.sim.encryption.MessageDigestDecryptionService;
import com.appdynamics.sim.agent.extensions.api.client.ExtensionRestServicesModule;
import com.appdynamics.sim.agent.extensions.servers.AgentMonitorConfigListener;
import com.appdynamics.sim.agent.extensions.servers.DataCollectorFactory;
import com.appdynamics.sim.agent.extensions.servers.DoubleBufferedProcessProperties;
import com.appdynamics.sim.agent.extensions.servers.IServersDataCollector;
import com.appdynamics.sim.agent.extensions.servers.ProcessMonitor;
import com.appdynamics.sim.agent.extensions.servers.ProcessProperties;
import com.appdynamics.sim.agent.extensions.servers.ReportMetricsConfigSupplier;
import com.appdynamics.sim.agent.extensions.servers.ServersDataCollector;
import com.appdynamics.sim.agent.extensions.servers.ServersDataCollectorManager;
import com.appdynamics.sim.agent.extensions.servers.ServersMonitorConfigListener;
import com.appdynamics.sim.agent.extensions.servers.collector.ContentRawCollectorModule;
import com.appdynamics.sim.agent.extensions.servers.collector.PathRawCollectorModule;
import com.appdynamics.sim.agent.extensions.servers.collector.RawCollectorUtil;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfigBusinessValidator;
import com.appdynamics.sim.agent.extensions.servers.model.DependentMetricValueSupplier;
import com.appdynamics.sim.agent.extensions.servers.model.aix.AixServerMonitoringModule;
import com.appdynamics.sim.agent.extensions.servers.model.hpux.HpUxServerMonitoringModule;
import com.appdynamics.sim.agent.extensions.servers.model.newlinux.NewLinuxServerMonitoringModule;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarServerMonitoringModule;
import com.appdynamics.sim.agent.extensions.servers.model.solaris.SolarisServerMonitoringModule;
import com.appdynamics.sim.agent.extensions.servers.model.windows.WindowsServerMonitoringModule;
import com.appdynamics.sim.agent.extensions.servers.tags.AwsTagsConfigsDecider;
import com.appdynamics.sim.agent.extensions.servers.tags.AwsTagsScheduledRunner;
import com.appdynamics.sim.agent.extensions.servers.tags.AwsTagsSupplier;
import com.appdynamics.sim.agent.extensions.servers.tags.AzureTagsConfigsDecider;
import com.appdynamics.sim.agent.extensions.servers.tags.AzureTagsScheduledRunner;
import com.appdynamics.sim.agent.extensions.servers.tags.AzureTagsSupplier;
import com.appdynamics.sim.agent.extensions.servers.tags.K8sNodeTagsConfigsDecider;
import com.appdynamics.sim.agent.extensions.servers.tags.K8sNodeTagsScheduledRunner;
import com.appdynamics.sim.agent.extensions.servers.tags.K8sNodeTagsSupplier;
import com.appdynamics.sim.agent.extensions.servers.tags.K8sTagsConfigsDecider;
import com.appdynamics.sim.agent.extensions.servers.tags.K8sTagsScheduledRunner;
import com.appdynamics.sim.agent.extensions.servers.tags.K8sTagsSupplier;
import com.appdynamics.sim.agent.extensions.servers.tags.ServiceNowTagsConfigDecider;
import com.appdynamics.sim.agent.extensions.servers.tags.ServiceNowTagsScheduledRunner;
import com.appdynamics.sim.agent.extensions.servers.tags.ServiceNowTagsSupplier;
import com.appdynamics.sim.agent.extensions.servers.tags.SmartAgentTagsConfigsDecider;
import com.appdynamics.sim.agent.extensions.servers.tags.SmartAgentTagsScheduledRunner;
import com.appdynamics.sim.agent.extensions.servers.tags.SmartAgentTagsSupplier;
import com.appdynamics.sim.agent.extensions.servers.tags.UrlMonitoringConfigsDecider;
import com.appdynamics.sim.agent.extensions.servers.tags.UrlMonitoringScheduledRunner;
import com.appdynamics.sim.agent.extensions.servers.tags.UrlMonitoringSupplier;
import com.appdynamics.sim.common.biz.shared.machines.AgentMonitorConfig;
import com.appdynamics.sim.common.biz.shared.machines.Features;
import com.appdynamics.sim.processes.agent.rest.SimProcessesAgentService;
import com.appdynamics.voltron.configuration.ConfigurationClientModule;
import com.appdynamics.voltron.configuration.DynamicConfigurationClientModule;
import com.appdynamics.voltron.extensions.api.ExtensionModule;
import com.appdynamics.voltron.utils.PlatformOperatingSystem;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.singularity.ee.util.system.SystemUtilsTranslateable;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtensionModule
public class ServersExtensionModule
extends AbstractModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServersExtensionModule.class);
    private static final boolean SIGAR_COLLECTOR_ENABLED_DEFAULT = false;
    private static final String MESSAGE_DIGEST_ALGO = "AES";
    private static final String KEY_STRING = "190z!gP>aygoU0HeWb^rE].9{>?G@fFF";
    private static final String IV_STRING = "IUk`90q9B45LU3,H";
    private PlatformOperatingSystem platformOperatingSystem;

    @VisibleForTesting
    ServersExtensionModule(Optional<PlatformOperatingSystem> platformOperatingSystem) {
        if (platformOperatingSystem.isPresent()) {
            this.platformOperatingSystem = (PlatformOperatingSystem)platformOperatingSystem.get();
        } else {
            this.useLocalOperatingSystem();
        }
    }

    public ServersExtensionModule() {
        this((Optional<PlatformOperatingSystem>)Optional.absent());
    }

    private void useLocalOperatingSystem() {
        this.platformOperatingSystem = SystemUtils.IS_OS_WINDOWS ? PlatformOperatingSystem.WINDOWS : (SystemUtils.IS_OS_LINUX ? PlatformOperatingSystem.LINUX : (SystemUtils.IS_OS_SOLARIS || SystemUtils.IS_OS_SUN_OS ? PlatformOperatingSystem.SOLARIS : (SystemUtils.IS_OS_AIX ? PlatformOperatingSystem.AIX : (SystemUtils.IS_OS_HP_UX ? PlatformOperatingSystem.HP_UX : PlatformOperatingSystem.NON_SUPPORTED))));
    }

    protected void configure() {
        this.install((Module)new ServerMonRestApis());
        this.installDecryptionService();
        boolean isSigarCollectorEnabled = SystemUtilsTranslateable.getBooleanProperty((String)"appdynamics.machine.agent.extensions.sim.sigarCollectorEnabled", (boolean)false);
        log.info("OS is {}", (Object)this.platformOperatingSystem);
        log.debug("Sigar collector is {}", (Object)isSigarCollectorEnabled);
        log.debug("Pipe Collector Script Enabled is set to {}", (Object)this.getPipeCollectorScriptEnabled());
        if (isSigarCollectorEnabled) {
            this.installStandardConfiguration();
            this.install((Module)new SigarServerMonitoringModule());
        } else if (this.platformOperatingSystem.equals((Object)PlatformOperatingSystem.WINDOWS)) {
            this.installStandardConfiguration();
            this.install((Module)new WindowsServerMonitoringModule());
        } else if (this.platformOperatingSystem.equals((Object)PlatformOperatingSystem.LINUX)) {
            this.installStandardConfiguration();
            this.install((Module)new NewLinuxServerMonitoringModule());
        } else if (this.platformOperatingSystem.equals((Object)PlatformOperatingSystem.SOLARIS)) {
            this.installStandardConfiguration();
            this.install((Module)new SolarisServerMonitoringModule());
        } else if (this.platformOperatingSystem.equals((Object)PlatformOperatingSystem.AIX)) {
            this.installStandardConfiguration();
            this.install((Module)new AixServerMonitoringModule());
        } else if (this.platformOperatingSystem.equals((Object)PlatformOperatingSystem.HP_UX)) {
            log.debug("ServersExtensionModule PlatformOperatingSystem : {}", (Object)this.platformOperatingSystem);
            this.installStandardConfiguration();
            this.install((Module)new HpUxServerMonitoringModule());
            log.debug("ServersExtensionModule PlatformOperatingSystem : {} complete", (Object)this.platformOperatingSystem);
        } else {
            log.warn("OS {} is not supported.", (Object)SystemUtils.OS_NAME);
        }
        if (!isSigarCollectorEnabled) {
            if (this.getPipeCollectorScriptEnabled()) {
                this.install((Module)new ContentRawCollectorModule());
            } else {
                this.install((Module)new PathRawCollectorModule());
            }
        }
    }

    private void installDecryptionService() {
        this.bind(DecryptionService.class).to(MessageDigestDecryptionService.class);
        this.bindConstant().annotatedWith(DecryptKeyString.class).to(KEY_STRING);
        this.bindConstant().annotatedWith(DecryptMessageDigestAlgo.class).to(MESSAGE_DIGEST_ALGO);
        this.bindConstant().annotatedWith(DecryptIvString.class).to(IV_STRING);
    }

    private void installStandardConfiguration() {
        this.bind(ServersDataCollectorManager.class).asEagerSingleton();
        this.bind(ProcessMonitor.class).asEagerSingleton();
        this.bind((TypeLiteral)new TypeLiteral<Supplier<ReportMetricsConfig>>(){}).to(ReportMetricsConfigSupplier.class);
        this.install(new FactoryModuleBuilder().implement(IServersDataCollector.class, ServersDataCollector.class).build(DataCollectorFactory.class));
        this.install((Module)new ConfigurationClientModule(){

            protected void configureListenersAndValidators() {
                this.bindInjectableConfig("ServerMonitoring", ServersMonitorConfig.class, new ServersMonitorConfig(), true);
                this.bindConfigListener("ServerMonitoring", ServersMonitorConfig.class).to(ServersMonitorConfigListener.class);
                this.bindCustomValidator(ServersMonitorConfig.class).to(ServersMonitorConfigBusinessValidator.class);
                this.bindInjectableConfig("_features", Features.class, Features.DISABLED, true);
                this.bind(ProcessProperties.class).to(DoubleBufferedProcessProperties.class).in(Scopes.SINGLETON);
            }
        });
        this.install((Module)new DynamicConfigurationClientModule(){

            protected void configureListenersAndValidators() {
                this.bindInjectableConfig("_agentMonitoringConfig", AgentMonitorConfig.class, new AgentMonitorConfig(), true);
                this.bindConfigListener("_agentMonitoringConfig", AgentMonitorConfig.class).to(AgentMonitorConfigListener.class);
            }
        });
        this.bind(RawCollectorUtil.class);
        this.installServerTagsService();
        this.bind(DependentMetricValueSupplier.class).in(Scopes.SINGLETON);
    }

    private boolean getPipeCollectorScriptEnabled() {
        if (this.platformOperatingSystem.equals((Object)PlatformOperatingSystem.WINDOWS)) {
            return false;
        }
        String isPipeCollectorScriptEnabled = System.getProperty("appdynamics.machine.agent.collectorScript.pipingEnabled", "true");
        return Boolean.parseBoolean(isPipeCollectorScriptEnabled);
    }

    private void installServerTagsService() {
        this.bind(AwsTagsSupplier.class).asEagerSingleton();
        this.bind(AwsTagsConfigsDecider.class).asEagerSingleton();
        this.bind(AwsTagsScheduledRunner.class).asEagerSingleton();
        this.bind(AzureTagsSupplier.class).asEagerSingleton();
        this.bind(AzureTagsConfigsDecider.class).asEagerSingleton();
        this.bind(AzureTagsScheduledRunner.class).asEagerSingleton();
        this.bind(K8sTagsSupplier.class).asEagerSingleton();
        this.bind(K8sTagsConfigsDecider.class).asEagerSingleton();
        this.bind(K8sTagsScheduledRunner.class).asEagerSingleton();
        this.bind(K8sNodeTagsSupplier.class).asEagerSingleton();
        this.bind(K8sNodeTagsConfigsDecider.class).asEagerSingleton();
        this.bind(K8sNodeTagsScheduledRunner.class).asEagerSingleton();
        this.bind(SmartAgentTagsSupplier.class).asEagerSingleton();
        this.bind(SmartAgentTagsConfigsDecider.class).asEagerSingleton();
        this.bind(SmartAgentTagsScheduledRunner.class).asEagerSingleton();
        this.bind(ServiceNowTagsSupplier.class).asEagerSingleton();
        this.bind(ServiceNowTagsConfigDecider.class).asEagerSingleton();
        this.bind(ServiceNowTagsScheduledRunner.class).asEagerSingleton();
        this.bind(UrlMonitoringSupplier.class).asEagerSingleton();
        this.bind(UrlMonitoringConfigsDecider.class).asEagerSingleton();
        this.bind(UrlMonitoringScheduledRunner.class).asEagerSingleton();
    }

    private static class ServerMonRestApis
    extends ExtensionRestServicesModule {
        private ServerMonRestApis() {
        }

        protected void configureServices() {
            this.serve(SimProcessesAgentService.class).fromPath("/sim");
        }
    }
}

