/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.appdynamics.sim.agent.extensions.servers.DataCollectorConfig;
import com.appdynamics.sim.agent.extensions.servers.IServersDataCollector;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentName;
import com.appdynamics.sim.agent.extensions.servers.model.Server;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServersDataCollector
implements IServersDataCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServersDataCollector.class);
    @Generated
    private final Object $lock = new Object[0];
    private final Scheduler scheduler;
    private final Server<?> server;
    @VisibleForTesting
    private final ImmutableSet<ComponentName> componentNames;
    private final Supplier<ReportMetricsConfig> reportMetricsConfigSupplier;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final DataCollectorConfig dataCollectorConfig;
    private volatile ScheduledFuture<?> future;
    @VisibleForTesting
    private volatile long scheduledInterval;

    @Inject
    private ServersDataCollector(@Assisted DataCollectorConfig dataCollectorConfig, Supplier<ReportMetricsConfig> reportMetricsConfigSupplier, Scheduler scheduler, Server<?> server, SimAgentRepetitiveLogger repetitiveLogger) {
        this.scheduler = scheduler;
        this.server = server;
        this.dataCollectorConfig = dataCollectorConfig;
        this.componentNames = dataCollectorConfig.getComponentNames();
        this.reportMetricsConfigSupplier = reportMetricsConfigSupplier;
        this.repetitiveLogger = repetitiveLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("Start ServersDataCollector dataCollectorConfig - {}, future - {}", (Object)this.dataCollectorConfig, this.future);
            this.scheduledInterval = this.dataCollectorConfig.getSamplingInterval();
            if (this.future == null) {
                log.debug("Start ServersDataCollector scheduledInterval - {}", (Object)this.scheduledInterval);
                this.future = this.scheduler.scheduleAtFixedRate((Runnable)this, 0L, this.scheduledInterval, TimeUnit.MILLISECONDS);
                log.info("Started servers data collector - {}.", (Object)this.dataCollectorConfig);
            }
            log.debug("Start ServersDataCollector complete, future = {}", this.future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreDestroy
    public void stop() {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("stop ServersDataCollector future - {}", this.future);
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
                log.info("Stopped servers data collector - {}.", (Object)this.dataCollectorConfig);
            }
            log.debug("stop ServersDataCollector complete, future = {}", this.future);
        }
    }

    @Override
    public void run() {
        log.debug("Run ServersDataCollector");
        ReportMetricsConfig reportMetricsConfig = (ReportMetricsConfig)this.reportMetricsConfigSupplier.get();
        log.debug("run ServersDataCollector, reportMetricsConfig = {}", (Object)reportMetricsConfig);
        if (reportMetricsConfig.isReportBasicMetrics() || reportMetricsConfig.isReportSimMetrics()) {
            log.trace("Collecting and reporting - {} with metric collection configuration - {}.", (Object)this.dataCollectorConfig, (Object)reportMetricsConfig);
            this.repetitiveLogger.debug(log, "Collecting and reporting - " + String.valueOf(this.dataCollectorConfig) + " with metric collection configuration - " + String.valueOf(reportMetricsConfig), new Object[0]);
            try {
                this.server.collectAndReport((Set<ComponentName>)this.componentNames, reportMetricsConfig, this.scheduledInterval);
            }
            catch (RuntimeException e) {
                this.repetitiveLogger.warn(log, "Error while collection and reporting data for {} with the following error ", new Object[]{this.componentNames, e});
            }
        } else {
            this.repetitiveLogger.debug(log, "Not collecting data for components - {}, with collection configuration - {} because all metric collection configurations are disabled. Please update ServerMonitoring.yml file and enable metric collection.", new Object[]{this.componentNames, reportMetricsConfig});
        }
        log.debug("Run ServersDataCollector complete");
    }

    @Generated
    ImmutableSet<ComponentName> getComponentNames() {
        return this.componentNames;
    }

    @Generated
    void setScheduledInterval(long scheduledInterval) {
        this.scheduledInterval = scheduledInterval;
    }
}

