/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfigResolver;
import com.appdynamics.sim.common.biz.shared.machines.Features;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import com.google.inject.Provider;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportMetricsConfigSupplier
implements Supplier<ReportMetricsConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportMetricsConfigSupplier.class);
    private Provider<ServersMonitorConfig> monitorConfig;
    private Provider<Features> features;
    private boolean isLogWarnForSimDisabled = false;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final ServersMonitorConfigResolver serversMonitorConfigResolver;
    @VisibleForTesting
    private final BootstrapConfiguration bootstrapConfiguration;

    @Inject
    ReportMetricsConfigSupplier(BootstrapConfiguration bootstrapConfiguration, Provider<ServersMonitorConfig> monitorConfig, Provider<Features> features, ServersMonitorConfigResolver serversMonitorConfigResolver, SimAgentRepetitiveLogger repetitiveLogger) {
        this.monitorConfig = monitorConfig;
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.serversMonitorConfigResolver = serversMonitorConfigResolver;
        this.repetitiveLogger = repetitiveLogger;
        this.features = features;
    }

    public ReportMetricsConfig get() {
        boolean reportBasicMetrics = false;
        boolean reportSimMetrics = false;
        log.debug("get ReportMetricsConfigSupplier, monitorConfig = {}, features = {}", this.monitorConfig, this.features);
        if (this.monitorConfig != null) {
            reportBasicMetrics = ((ServersMonitorConfig)this.monitorConfig.get()).getBasicEnabled();
        }
        if (this.features != null) {
            reportSimMetrics = ((Features)this.features.get()).has("sim");
        }
        log.debug("get ReportMetricsConfigSupplier, reportBasicMetrics = {}, reportSimMetrics = {}", (Object)reportBasicMetrics, (Object)reportSimMetrics);
        boolean reportPercentileMetrics = this.isPercentileEnabled(reportSimMetrics);
        if (!reportBasicMetrics && this.bootstrapConfiguration.getSimUserEnabled().booleanValue()) {
            reportBasicMetrics = true;
            this.repetitiveLogger.info(log, "Basic metrics will be collected and reported through the SIM extension because SIM is enabled.", new Object[0]);
        }
        log.debug("Basic metrics enabled: " + reportBasicMetrics);
        log.debug("Sim metrics enabled: " + reportSimMetrics);
        log.debug("Percentile metrics enabled: " + reportPercentileMetrics);
        ReportMetricsConfig reportMetricConfig = ReportMetricsConfig.builder().reportBasicMetrics(reportBasicMetrics).reportSimMetrics(reportSimMetrics).reportPercentileMetrics(reportPercentileMetrics).build();
        return reportMetricConfig;
    }

    private boolean isPercentileEnabled(boolean isSimEnabled) {
        boolean reportPercentileMetrics = this.serversMonitorConfigResolver.isPercentileMonitoringEnabled();
        if (reportPercentileMetrics) {
            if (!SystemUtils.IS_OS_LINUX) {
                this.repetitiveLogger.warn(log, "Percentile metrics will not be reported as the feature is currently supported only on linux, Detected operating system - {}.", new Object[]{SystemUtils.OS_NAME});
                return false;
            }
            if (!isSimEnabled) {
                if (!this.isLogWarnForSimDisabled) {
                    log.warn("Percentile metrics will not be reported as SIM is disabled.");
                    this.isLogWarnForSimDisabled = true;
                }
                return false;
            }
            this.isLogWarnForSimDisabled = false;
            return true;
        }
        return false;
    }

    @Generated
    BootstrapConfiguration getBootstrapConfiguration() {
        return this.bootstrapConfiguration;
    }
}

