/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers;

import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.appdynamics.sim.agent.extensions.servers.ProcessProperties;
import com.appdynamics.sim.common.biz.shared.machines.Features;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessMonitor
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessMonitor.class);
    @Generated
    private final Object $lock = new Object[0];
    @VisibleForTesting
    private static final int PROCESS_METADATA_REPORTING_INTERVAL = 60000;
    private static final int PROCESS_MONITOR_INITIAL_DELAY = 1000;
    private final Scheduler scheduler;
    private final Provider<Features> features;
    private final ProcessProperties processProperties;
    private volatile ScheduledFuture<?> future;

    @Inject
    private ProcessMonitor(Scheduler scheduler, Provider<Features> features, @NonNull ProcessProperties processProperties) {
        if (processProperties == null) {
            throw new NullPointerException("processProperties is marked non-null but is null");
        }
        this.scheduler = scheduler;
        this.features = features;
        this.processProperties = processProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    private void startMonitor() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.future == null) {
                this.future = this.scheduler.scheduleAtFixedRate((Runnable)this, 1000L, 60000L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    private void stopMonitor() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }
    }

    @Override
    public void run() {
        boolean reportSimMetrics = ((Features)this.features.get()).has("sim");
        log.debug("ProcessMonitor:Sim metrics enabled: " + reportSimMetrics);
        if (reportSimMetrics) {
            try {
                this.processProperties.reportProcesses();
            }
            catch (Throwable e) {
                log.warn("ProcessMonitor::Caught exception during collection and reporting.", e);
            }
        }
    }

    @Generated
    static int getPROCESS_METADATA_REPORTING_INTERVAL() {
        return 60000;
    }
}

