/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers;

import com.appdynamics.sim.agent.extensions.api.HostId;
import com.appdynamics.sim.agent.extensions.servers.ProcessProperties;
import com.appdynamics.sim.processes.agent.rest.SimProcessesAgentService;
import com.appdynamics.sim.processes.common.rest.SimProcessObservationDto;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

public class DoubleBufferedProcessProperties
implements ProcessProperties {
    private final String hostId;
    private final SimProcessesAgentService processesAgentService;
    @VisibleForTesting
    private volatile Optional<List<SimProcessObservationDto>> currentProcessObservations;
    @VisibleForTesting
    private volatile ImmutableList.Builder<SimProcessObservationDto> nextProcessObservationsBuilder;

    @Inject
    public DoubleBufferedProcessProperties(@HostId @NonNull String hostId, @NonNull SimProcessesAgentService processesAgentService) {
        if (hostId == null) {
            throw new NullPointerException("hostId is marked non-null but is null");
        }
        if (processesAgentService == null) {
            throw new NullPointerException("processesAgentService is marked non-null but is null");
        }
        this.hostId = hostId;
        this.processesAgentService = processesAgentService;
        this.currentProcessObservations = Optional.absent();
        this.nextProcessObservationsBuilder = ImmutableList.builder();
    }

    @Override
    public void addProcessObservations(@NonNull List<SimProcessObservationDto> processes) {
        if (processes == null) {
            throw new NullPointerException("processes is marked non-null but is null");
        }
        this.nextProcessObservationsBuilder.addAll(processes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readyToReport() {
        DoubleBufferedProcessProperties doubleBufferedProcessProperties = this;
        synchronized (doubleBufferedProcessProperties) {
            this.currentProcessObservations = Optional.of((Object)this.nextProcessObservationsBuilder.build());
            this.nextProcessObservationsBuilder = ImmutableList.builder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportProcesses() {
        Optional<List<SimProcessObservationDto>> currentProcessObservationsToReport;
        DoubleBufferedProcessProperties doubleBufferedProcessProperties = this;
        synchronized (doubleBufferedProcessProperties) {
            currentProcessObservationsToReport = this.currentProcessObservations;
            this.currentProcessObservations = Optional.absent();
        }
        if (currentProcessObservationsToReport.isPresent() && !((List)currentProcessObservationsToReport.get()).isEmpty()) {
            this.processesAgentService.updateProcessMetadata(this.hostId, (List)currentProcessObservationsToReport.get());
        }
    }

    @Generated
    Optional<List<SimProcessObservationDto>> getCurrentProcessObservations() {
        return this.currentProcessObservations;
    }

    @Generated
    ImmutableList.Builder<SimProcessObservationDto> getNextProcessObservationsBuilder() {
        return this.nextProcessObservationsBuilder;
    }
}

