/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.servers.DataCollectorConfig;
import com.appdynamics.sim.agent.extensions.servers.config.ComponentConfigMapBuilder;
import com.appdynamics.sim.agent.extensions.servers.config.ComponentMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentName;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataCollectorConfigurationsSupplier
implements Supplier<Optional<ImmutableSet<DataCollectorConfig>>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDataCollectorConfigurationsSupplier.class);
    private final Provider<ServersMonitorConfig> monitorConfig;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final Map<ComponentName, Set<ComponentName>> componentDependencyMap;

    @Inject
    DefaultDataCollectorConfigurationsSupplier(Provider<ServersMonitorConfig> monitorConfig, SimAgentRepetitiveLogger repetitiveLogger, Map<ComponentName, Set<ComponentName>> componentDependencyMap) {
        this.monitorConfig = monitorConfig;
        this.repetitiveLogger = repetitiveLogger;
        this.componentDependencyMap = componentDependencyMap;
    }

    public Optional<ImmutableSet<DataCollectorConfig>> get() {
        ImmutableSet.Builder dataCollectorConfigSetBuilder = ImmutableSet.builder();
        Map<ComponentName, ComponentMonitorConfig> componentMonitorConfigMap = ComponentConfigMapBuilder.buildComponentConfigMap((ServersMonitorConfig)this.monitorConfig.get());
        Map<Long, Set<ComponentName>> samplingIntervalComponentsMap = this.buildSamplingIntervalComponentsMap(componentMonitorConfigMap);
        for (Map.Entry<Long, Set<ComponentName>> entry : samplingIntervalComponentsMap.entrySet()) {
            dataCollectorConfigSetBuilder.add((Object)DataCollectorConfig.builder().samplingInterval(entry.getKey()).componentNames((ImmutableSet<ComponentName>)ImmutableSet.copyOf((Collection)entry.getValue())).build());
        }
        ImmutableSet dataCollectorConfigSet = dataCollectorConfigSetBuilder.build();
        return Optional.of((Object)dataCollectorConfigSet);
    }

    private Map<Long, Set<ComponentName>> buildSamplingIntervalComponentsMap(Map<ComponentName, ComponentMonitorConfig> componentNameToConfig) {
        HashMap<Long, Set<ComponentName>> samplingIntervalComponentsMap = new HashMap<Long, Set<ComponentName>>();
        for (Map.Entry<ComponentName, ComponentMonitorConfig> entry : componentNameToConfig.entrySet()) {
            ComponentMonitorConfig componentMonitorConfig = entry.getValue();
            ComponentName componentName = entry.getKey();
            if (componentMonitorConfig.getEnabled().booleanValue()) {
                Optional<Long> componentSamplingInterval = componentMonitorConfig.getSamplingInterval();
                Long samplingInterval = componentSamplingInterval.isPresent() ? (Long)componentSamplingInterval.get() : Long.valueOf(((ServersMonitorConfig)this.monitorConfig.get()).getSamplingInterval());
                HashSet<ComponentName> componentNames = (HashSet<ComponentName>)samplingIntervalComponentsMap.get(samplingInterval);
                if (componentNames == null) {
                    componentNames = new HashSet<ComponentName>();
                    samplingIntervalComponentsMap.put(samplingInterval, componentNames);
                }
                componentNames.add(componentName);
                continue;
            }
            this.repetitiveLogger.debug(log, "Component not enabled - {}", new Object[]{componentName});
        }
        for (Map.Entry<ComponentName, Object> entry : this.componentDependencyMap.entrySet()) {
            ComponentName componentName = entry.getKey();
            Set dependentComponents = (Set)entry.getValue();
            ComponentMonitorConfig componentMonitorConfig = componentNameToConfig.get((Object)componentName);
            if (componentMonitorConfig == null) continue;
            if (componentMonitorConfig.getEnabled().booleanValue()) {
                Optional<Long> componentSamplingIntervalOpt = componentMonitorConfig.getSamplingInterval();
                long samplingInterval = componentSamplingIntervalOpt.isPresent() ? ((Long)componentSamplingIntervalOpt.get()).longValue() : ((ServersMonitorConfig)this.monitorConfig.get()).getSamplingInterval();
                HashSet existingComponentsForInterval = (HashSet)samplingIntervalComponentsMap.get(samplingInterval);
                if (existingComponentsForInterval == null) {
                    existingComponentsForInterval = new HashSet();
                    samplingIntervalComponentsMap.put(samplingInterval, existingComponentsForInterval);
                }
                existingComponentsForInterval.addAll(dependentComponents);
                continue;
            }
            this.repetitiveLogger.debug(log, "Component not enabled - {}", new Object[]{componentName});
        }
        return samplingIntervalComponentsMap;
    }
}

