/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers;

import com.appdynamics.sim.agent.extensions.servers.tags.AwsTagsScheduledRunner;
import com.appdynamics.sim.agent.extensions.servers.tags.AzureTagsScheduledRunner;
import com.appdynamics.sim.agent.extensions.servers.tags.K8sTagsScheduledRunner;
import com.appdynamics.sim.common.biz.shared.machines.AgentMonitorConfig;
import com.appdynamics.voltron.configuration.ConfigurationListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentMonitorConfigListener
implements ConfigurationListener<AgentMonitorConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgentMonitorConfigListener.class);
    private final AwsTagsScheduledRunner awsTagsScheduledRunner;
    private final AzureTagsScheduledRunner azureTagsScheduledRunner;
    private final K8sTagsScheduledRunner k8sTagsScheduledRunner;
    private Optional<AgentMonitorConfig> agentMonitoringConfig = Optional.absent();

    @Inject
    public AgentMonitorConfigListener(AwsTagsScheduledRunner awsTagsScheduledRunner, AzureTagsScheduledRunner azureTagsScheduledRunner, K8sTagsScheduledRunner k8sTagsScheduledRunner) {
        this.awsTagsScheduledRunner = awsTagsScheduledRunner;
        this.azureTagsScheduledRunner = azureTagsScheduledRunner;
        this.k8sTagsScheduledRunner = k8sTagsScheduledRunner;
    }

    public void apply(String configName, AgentMonitorConfig configuration) {
        if (configuration == null) {
            log.warn("Received null configuration from controller");
            return;
        }
        if (!this.isAgentMonitoringConfigSame(configuration)) {
            this.agentMonitoringConfig = Optional.of((Object)configuration);
        }
    }

    @VisibleForTesting
    boolean isAgentMonitoringConfigSame(AgentMonitorConfig newValue) {
        if (this.agentMonitoringConfig.isPresent()) {
            AgentMonitorConfig prevValue = (AgentMonitorConfig)this.agentMonitoringConfig.get();
            return prevValue.equals((Object)newValue);
        }
        return false;
    }

    @VisibleForTesting
    void resolveAwsConfiguration(AgentMonitorConfig configuration) {
        if (configuration.isTagsEnabled() && configuration.isAwsTagsEnabled()) {
            this.awsTagsScheduledRunner.tryStart();
        } else {
            this.awsTagsScheduledRunner.tryStop();
        }
    }

    @VisibleForTesting
    void resolveAzureConfiguration(AgentMonitorConfig configuration) {
        if (configuration.isTagsEnabled() && configuration.isAzureTagsEnabled()) {
            this.azureTagsScheduledRunner.tryStart();
        } else {
            this.azureTagsScheduledRunner.tryStop();
        }
    }

    @VisibleForTesting
    void resolveK8sConfiguration(AgentMonitorConfig configuration) {
        if (configuration.isTagsEnabled() && configuration.isK8sTagsEnabled()) {
            this.k8sTagsScheduledRunner.tryStart();
        } else {
            this.k8sTagsScheduledRunner.tryStop();
        }
    }
}

