/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.crashguard;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.legacy.AccountKey;
import com.appdynamics.sim.agent.extensions.api.events.EventsService;
import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.appdynamics.sim.agent.extensions.crashguard.CrashGuardConfiguration;
import com.appdynamics.sim.agent.extensions.crashguard.SigarAppAgentMonitor;
import com.appdynamics.voltron.configuration.ConfigurationListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import lombok.Generated;
import lombok.NonNull;
import org.hyperic.sigar.Sigar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrashGuardRunner
implements ConfigurationListener<CrashGuardConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CrashGuardRunner.class);
    @Generated
    private final Object $lock = new Object[0];
    private final Sigar sigar;
    private final EventsService eventsService;
    private final Scheduler scheduler;
    private final BootstrapConfiguration bootstrapConfiguration;
    private final Provider<Optional<String>> accountKeyProvider;
    private volatile Optional<SigarAppAgentMonitor> monitor;
    private CrashGuardConfiguration prevConfig;
    private volatile ScheduledFuture<?> future;

    @Inject
    public CrashGuardRunner(@NonNull Sigar sigar, @NonNull EventsService eventsService, @NonNull Scheduler scheduler, @NonNull BootstrapConfiguration bootstrapConfiguration, @AccountKey @NonNull Provider<Optional<String>> accountKeyProvider) {
        if (sigar == null) {
            throw new NullPointerException("sigar is marked non-null but is null");
        }
        if (eventsService == null) {
            throw new NullPointerException("eventsService is marked non-null but is null");
        }
        if (scheduler == null) {
            throw new NullPointerException("scheduler is marked non-null but is null");
        }
        if (bootstrapConfiguration == null) {
            throw new NullPointerException("bootstrapConfiguration is marked non-null but is null");
        }
        if (accountKeyProvider == null) {
            throw new NullPointerException("accountKeyProvider is marked non-null but is null");
        }
        this.sigar = sigar;
        this.eventsService = eventsService;
        this.scheduler = scheduler;
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.accountKeyProvider = accountKeyProvider;
        this.monitor = Optional.absent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(String configName, CrashGuardConfiguration configuration) {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("Applying configuration {}", (Object)configuration);
            if (configuration != null && !configuration.equals(this.prevConfig)) {
                try {
                    this.stopMonitor();
                    this.startMonitor(configuration);
                }
                catch (Exception exception) {
                    log.warn("Could not restart the crash guard monitor to apply configuration change.", (Throwable)exception);
                }
                this.prevConfig = new CrashGuardConfiguration(configuration.getEnabled(), configuration.getExecutingIntervalInMillis());
            }
        }
    }

    @VisibleForTesting
    void startMonitor(CrashGuardConfiguration configuration) {
        if (this.future == null) {
            if (configuration.getEnabled().booleanValue()) {
                try {
                    this.monitor = Optional.of((Object)SigarAppAgentMonitor.reserveAndCreateInstance(this.sigar, this.eventsService, this.bootstrapConfiguration, this.accountKeyProvider));
                }
                catch (Exception e) {
                    log.warn("Could not create crash guard monitor.", (Throwable)e);
                }
                long scheduledInterval = configuration.getExecutingIntervalInMillis();
                this.future = this.scheduler.scheduleAtFixedRate((Runnable)this.monitor.get(), 0L, scheduledInterval, TimeUnit.MILLISECONDS);
            } else {
                log.info("Not starting crash guard extension because it is disabled.To enable, please update the configuration enabled in CrashGuardConfig.yml.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    private void stopMonitor() throws Exception {
        Object object = this.$lock;
        synchronized (object) {
            SigarAppAgentMonitor.releaseReservation();
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
                this.monitor = Optional.absent();
                log.debug("Crash guard extension is stopped.");
            }
        }
    }

    @Generated
    public CrashGuardConfiguration getPrevConfig() {
        return this.prevConfig;
    }

    @Generated
    public void setPrevConfig(CrashGuardConfiguration prevConfig) {
        this.prevConfig = prevConfig;
    }
}

