/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgentVersion {
    private static final CharSequence COMPATIBLE_WITH = "compatible with";
    private static final Pattern pattern = Pattern.compile("(?:.*compatible with |^|(?<=[v#]))([0-9]+)[.-]([0-9]+)[.-]([0-9]+)(?:[.-]([0-9]+))?(?![\\.])");
    private static final Pattern realAgentPattern = Pattern.compile("(?:^|(?<=[v#]))([0-9]+)[.-]([0-9]+)[.-]([0-9]+)(?:[.-]([0-9]+))?(?![\\.])");
    private final int majorRelease;
    private final int minorRelease;
    private final int pointRelease;
    private final int agentPointRelease;
    private final String agentReportedString;
    private final AgentVersion realAgentVersion;

    public AgentVersion() {
        this(0, 0, 0, 0);
    }

    public AgentVersion(int major, int minor, int point, int agentPoint) {
        this.majorRelease = major;
        this.minorRelease = minor;
        this.pointRelease = point;
        this.agentPointRelease = agentPoint;
        this.agentReportedString = major + "." + minor + "." + point + "." + agentPoint;
        this.realAgentVersion = this;
    }

    public AgentVersion(String agentVersion) {
        if (agentVersion != null) {
            Matcher matcher = pattern.matcher(agentVersion);
            if (matcher.find()) {
                this.majorRelease = Integer.parseInt(matcher.group(1));
                this.minorRelease = Integer.parseInt(matcher.group(2));
                this.pointRelease = Integer.parseInt(matcher.group(3));
                this.agentPointRelease = matcher.group(4) != null ? Integer.parseInt(matcher.group(4)) : 0;
            } else {
                this.majorRelease = 0;
                this.minorRelease = 0;
                this.pointRelease = 0;
                this.agentPointRelease = 0;
            }
            this.realAgentVersion = agentVersion.contains(COMPATIBLE_WITH) ? this.parseRealAgentVersion(agentVersion) : this;
        } else {
            this.majorRelease = 0;
            this.minorRelease = 0;
            this.pointRelease = 0;
            this.agentPointRelease = 0;
            this.realAgentVersion = this;
        }
        this.agentReportedString = agentVersion;
    }

    public int getMajorRelease() {
        return this.majorRelease;
    }

    public int getMinorRelease() {
        return this.minorRelease;
    }

    public int getPointRelease() {
        return this.pointRelease;
    }

    public int getAgentPointRelease() {
        return this.agentPointRelease;
    }

    public AgentVersion getRealAgentVersion() {
        return this.realAgentVersion;
    }

    private AgentVersion parseRealAgentVersion(String agentVersion) {
        AgentVersion realAgentVersion;
        Matcher matcher = realAgentPattern.matcher(agentVersion);
        try {
            if (matcher.find()) {
                int agentPoint = 0;
                if (matcher.group(4) != null) {
                    agentPoint = Integer.parseInt(matcher.group(4));
                }
                realAgentVersion = new AgentVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), agentPoint);
            } else {
                realAgentVersion = this;
            }
        }
        catch (NumberFormatException e) {
            realAgentVersion = this;
        }
        return realAgentVersion;
    }

    public int compareTo(AgentVersion version) {
        if (this.majorRelease > version.majorRelease) {
            return 1;
        }
        if (this.majorRelease == version.majorRelease) {
            if (this.minorRelease > version.minorRelease) {
                return 1;
            }
            if (this.minorRelease == version.minorRelease) {
                if (this.pointRelease > version.pointRelease) {
                    return 1;
                }
                if (this.pointRelease == version.pointRelease) {
                    if (this.agentPointRelease > version.agentPointRelease) {
                        return 1;
                    }
                    if (this.agentPointRelease == version.agentPointRelease) {
                        return 0;
                    }
                    return -1;
                }
                return -1;
            }
            return -1;
        }
        return -1;
    }

    public boolean greaterOrEqualsTo(AgentVersion version) {
        return this.compareTo(version) >= 0;
    }

    public String toString() {
        return this.agentReportedString;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.majorRelease;
        result = 37 * result + this.minorRelease;
        result = 37 * result + this.pointRelease;
        result = 37 * result + this.agentPointRelease;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof AgentVersion) {
            AgentVersion version = (AgentVersion)obj;
            return version.majorRelease == this.majorRelease && version.minorRelease == this.minorRelease && version.pointRelease == this.pointRelease && version.agentPointRelease == this.agentPointRelease;
        }
        return false;
    }
}

