/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.uuid;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.UUID;

public class UUIDUtils {
    private static volatile SecureRandom numberGenerator;
    private static final String SHA1_PRNG_ALGORITHM_NAME = "SHA1PRNG";

    public static String getRandomUUID() {
        return UUIDUtils.generateRandomUUID().toString();
    }

    private static UUID generateRandomUUID() {
        byte[] randomBytes = new byte[16];
        numberGenerator.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        return UUIDUtils.getUUIDfromByteArray(randomBytes);
    }

    private static UUID getUUIDfromByteArray(byte[] input) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        if (input.length != 16) {
            return null;
        }
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(input[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(input[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    public static void setGeneratorSeed(byte[] seed) {
        numberGenerator.setSeed(seed);
    }

    public static void setNewAlgorithm(String algorithmName) throws NoSuchAlgorithmException {
        SecureRandom localSecureRandom;
        numberGenerator = localSecureRandom = SecureRandom.getInstance(algorithmName);
    }

    static {
        try {
            numberGenerator = SecureRandom.getInstance(SHA1_PRNG_ALGORITHM_NAME);
        }
        catch (NoSuchAlgorithmException e) {
            numberGenerator = new SecureRandom();
        }
    }
}

