/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.string;

import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.reflect.ReflectionUtilityCommon;
import com.singularity.ee.util.spi.IStringTokenizer;
import com.singularity.ee.util.string.StringOperationsHelper;
import com.singularity.ee.util.string.StringRegexOperations;
import com.singularity.ee.util.string.StringTokenizerImpl;
import com.singularity.ee.util.system.SystemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class StringOperations {
    public static final int INVALID_OR_NULL_INPUT = -1;
    public static final String CLASS_NAME_SEPARATOR = ".";
    public static final String PACKAGE_END = "*";
    public static final String EMPTY_STRING = "";
    public static final String TAB = "\t";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final String rubyJITCodePrefix = "ruby.jit.";

    public static boolean eqIgnoresCase(String str1, String str2) {
        return StringOperationsHelper.eqIgnoreCase(str1, str2);
    }

    public static boolean eqOrNull(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static boolean startsWith(String str, String prefix) {
        if (str == null) {
            return false;
        }
        return str.startsWith(prefix);
    }

    public static IStringTokenizer createStringTokenizer(String metricString, String separator) {
        return new StringTokenizerImpl(metricString, separator);
    }

    public static String getGUIDFromCorrelationHeader(String corHeader) {
        char[] chars = corHeader.toCharArray();
        int guidStartIndex = -1;
        int guidEndIndex = -1;
        for (int i = 0; i < chars.length - 6; ++i) {
            if (chars[i] == 'g' && chars[i + 1] == 'u' && chars[i + 2] == 'i' && chars[i + 3] == 'd' && chars[i + 4] == '=' && (i == 0 || chars[i - 1] == '*')) {
                guidStartIndex = i + 5;
            }
            if (guidStartIndex < 0 || chars[i] != '*') continue;
            guidEndIndex = i;
            break;
        }
        if (guidStartIndex >= 0 && guidEndIndex < 0) {
            guidEndIndex = chars.length;
        }
        if (guidStartIndex < 0) {
            return null;
        }
        String s = corHeader.substring(guidStartIndex, guidEndIndex);
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    public static String getPackageName(String className) {
        int inx = className.lastIndexOf(46);
        if (inx != -1) {
            return className.substring(0, inx);
        }
        return className;
    }

    public static int nthIndexOf(String s, char c, int startPos, int n) {
        return StringOperations.nthIndexOf(s.toCharArray(), c, startPos, n);
    }

    public static int nthIndexOf(char[] s, char c, int startPos, int n) {
        int cnt = 0;
        for (int i = startPos; i < s.length; ++i) {
            if (s[i] != c || ++cnt != n) continue;
            return i;
        }
        return -1;
    }

    public static int nthLastIndexOf(String s, char c, int lastPos, int n) {
        return StringOperations.nthLastIndexOf(s.toCharArray(), c, lastPos, n);
    }

    public static int nthLastIndexOf(char[] s, char c, int lastPos, int n) {
        int cnt = 0;
        for (int i = lastPos; i >= 0; --i) {
            if (s[i] != c || ++cnt != n) continue;
            return i;
        }
        return -1;
    }

    public static String formatInput(long input) {
        if (input < 1000L) {
            return Long.toString(input);
        }
        StringBuilder sbIn = StringOperationsHelper.reverse(new StringBuilder(Long.toString(input)));
        StringBuilder sbOut = new StringBuilder(sbIn.length() + 3);
        char[] chars = sbIn.toString().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            boolean addSeparator = i != 0 && i % 3 == 0;
            if (addSeparator) {
                sbOut.append(',');
            }
            sbOut.append(aChar);
        }
        return StringOperationsHelper.reverse(sbOut).toString();
    }

    public static String indent(int level) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            result.append("    ");
        }
        return result.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isEmptyAfterTrim(String str) {
        return str == null || str.length() == 0 || str.trim().length() == 0;
    }

    public static String defaultIfEmpty(String str, String defaultStr) {
        return StringOperations.isEmpty(str) ? defaultStr : str;
    }

    public static boolean safeParseBoolean(String str, boolean defaultBool) {
        return StringOperationsHelper.safeParseBoolean(str, defaultBool);
    }

    public static int safeParseInteger(String str) {
        return StringOperations.safeParseInteger(str, -1);
    }

    public static int safeParseInteger(String str, int defaultInt) {
        return StringOperationsHelper.safeParseInteger(str, defaultInt);
    }

    public static long safeParseLong(String str) {
        return StringOperations.safeParseLong(str, -1L);
    }

    public static long safeParseLong(String str, long defaultLong) {
        return StringOperationsHelper.safeParseLong(str, defaultLong);
    }

    public static boolean safeContains(String str, CharSequence searchFor) {
        return !StringOperations.isEmpty(str) && str.contains(searchFor);
    }

    public static String ordinalize(int number) {
        int[] _11through13;
        for (int n : _11through13 = new int[]{11, 12, 13}) {
            int m100 = number % 100;
            if (!Integer.toString(m100).endsWith(Integer.toString(n))) continue;
            return number + "th";
        }
        int m = number % 10;
        switch (m) {
            case 1: {
                return number + "st";
            }
            case 2: {
                return number + "nd";
            }
            case 3: {
                return number + "rd";
            }
        }
        return number + "th";
    }

    public static String[] parseCommaSeparatedStringToArray(String str) {
        return StringOperations.parseSeparatedStringToArray(str, ",");
    }

    public static List<String> parseCommaSeparatedString(String str) {
        return StringOperations.parseSeparatedString(str, ",");
    }

    public static String[] parseSeparatedStringToArray(String str, String separator) {
        List<String> list = StringOperations.parseSeparatedString(str, separator);
        return CollectionHelper.collectionToArray(list, new String[list.size()]);
    }

    public static List<String> parseSeparatedString(String str, String separator) {
        if (StringOperations.isEmpty(str)) {
            return CollectionHelper.emptySerializableList();
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizerImpl tokenizer = new StringTokenizerImpl(str, separator);
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken().trim();
            result.add(name);
        }
        return result;
    }

    public static Set<String> parseCommaSeparatedStringAsSet(String str) {
        return StringOperations.parseCommaSeparatedStringAsSet(str, CaseConvert.none);
    }

    public static int compareToIgnoreCase(String s1, String s2) {
        return StringOperationsHelper.compareToIgnoreCase(s1, s2);
    }

    private static Set<String> parseCommaSeparatedStringAsSet(String str, CaseConvert caseConvert) {
        if (StringOperations.isEmpty(str)) {
            return CollectionHelper.emptySerializableSet();
        }
        HashSet<String> result = new HashSet<String>();
        StringTokenizerImpl tokenizer = new StringTokenizerImpl(str, ",");
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken().trim();
            switch (caseConvert) {
                case upper: {
                    name = name.toUpperCase();
                    break;
                }
                case lower: {
                    name = name.toLowerCase();
                }
            }
            result.add(name);
        }
        return result;
    }

    public static int[] parseCommaSeparatedStringAsIntArray(String str) {
        return StringOperations.parseCommaSeparatedStringAsIntArray(str, ",");
    }

    public static int[] parseCommaSeparatedStringAsIntArray(String str, String delimiter) {
        if (StringOperations.isEmpty(str)) {
            return new int[0];
        }
        StringTokenizerImpl tokenizer = new StringTokenizerImpl(str, delimiter);
        int[] result = new int[tokenizer.countTokens()];
        int count = 0;
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken().trim();
            result[count++] = Integer.parseInt(name);
        }
        return result;
    }

    public static List<Integer> parseStringAsIntegerList(String str, String delimiter) {
        if (StringOperations.isEmpty(str)) {
            return new ArrayList<Integer>(0);
        }
        StringTokenizerImpl tokenizer = new StringTokenizerImpl(str, delimiter);
        ArrayList<Integer> result = new ArrayList<Integer>(tokenizer.countTokens());
        boolean count = false;
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken().trim();
            result.add(Integer.parseInt(name));
        }
        return result;
    }

    public static String convertToCommaSeparateString(long[] c) {
        if (c == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < c.length; ++i) {
            sb.append(c[i]);
            if (i == c.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static String convertToCommaSeparateString(int[] c) {
        if (c == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < c.length; ++i) {
            sb.append(c[i]);
            if (i == c.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static String convertToCommaSeparateString(String[] strings) {
        return StringOperations.convertToDelimiterSeparateString(strings, ",");
    }

    public static String convertToDelimiterSeparateString(String[] strings, String delim) {
        if (strings == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            builder.append(strings[i]);
            if (i == strings.length - 1) continue;
            builder.append(delim);
        }
        return builder.toString();
    }

    public static String convertToCommaSeparateString(Collection<String> c) {
        return StringOperations.convertToDelimiterSeparatedString(c, ",");
    }

    public static String convertToDelimiterSeparatedString(Collection<String> c, String delimiter) {
        if (c == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : c) {
            if (!first) {
                sb.append(delimiter);
            }
            sb.append(s.trim());
            first = false;
        }
        return sb.toString();
    }

    public static String convertToCommaSeparateString(Enumeration<String> enumeration) {
        if (enumeration == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (enumeration.hasMoreElements()) {
            sb.append(enumeration.nextElement());
            sb.append(",");
        }
        return sb.toString();
    }

    public static ArrayList<String> convertToList(String delimitedString, String delimiter) {
        StringTokenizerImpl st = new StringTokenizerImpl(delimitedString, delimiter);
        ArrayList<String> tokens = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken().trim());
        }
        return tokens;
    }

    public static String stripPackageWildCard(String str) {
        if (str.endsWith(PACKAGE_END)) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String getShortenedPackageName(String className) {
        StringTokenizerImpl st = new StringTokenizerImpl(className, CLASS_NAME_SEPARATOR);
        int tokens = st.countTokens();
        if (tokens == 1) {
            return className;
        }
        StringBuilder sb = new StringBuilder();
        if (tokens == 2) {
            sb.append(st.nextToken()).append(CLASS_NAME_SEPARATOR).append(PACKAGE_END);
            return sb.toString();
        }
        if (tokens == 3) {
            sb.append(st.nextToken()).append(CLASS_NAME_SEPARATOR).append(st.nextToken()).append(CLASS_NAME_SEPARATOR).append(PACKAGE_END);
            return sb.toString();
        }
        sb.append(st.nextToken()).append(CLASS_NAME_SEPARATOR).append(st.nextToken()).append(CLASS_NAME_SEPARATOR).append(st.nextToken()).append(CLASS_NAME_SEPARATOR).append(PACKAGE_END);
        return sb.toString();
    }

    public static String builderSubstr(StringBuilder sb, int length) {
        return StringOperationsHelper.builderSubstr(sb, length);
    }

    public static int builderIndexOf(StringBuilder sb, String str) {
        return StringOperationsHelper.builderIndexOf(sb, str);
    }

    public static int capacity(StringBuilder sb) {
        return StringOperationsHelper.capacity(sb);
    }

    public static void setLength(StringBuilder sb, int len) {
        StringOperationsHelper.setLength(sb, len);
    }

    public static void trimToSize(StringBuilder sb) {
        StringOperationsHelper.trimToSize(sb);
    }

    public static String trimString(StringBuilder sb, int len) {
        String summary = sb.length() > len ? StringOperationsHelper.builderSubstr(sb, len) : sb.toString();
        return summary;
    }

    public static String toStrArray(String[] arr) {
        if (arr == null) {
            return null;
        }
        if (arr.length == 0) {
            return EMPTY_STRING;
        }
        if (arr.length == 1) {
            return arr[0];
        }
        return StringOperationsHelper.stringArrayToString(arr);
    }

    public static String toStrArray(List<String> arr) {
        return StringOperations.toStrArray(CollectionHelper.collectionToArray(arr, new String[arr.size()]));
    }

    public static String toStrArray(Collection<String> arr) {
        return StringOperations.toStrArray(CollectionHelper.collectionToArray(arr, new String[arr.size()]));
    }

    public static String resolveSystemPropertiesIfAny(String input) {
        return StringOperations.resolvePropertiesIfAny(input, SystemUtils.getSystemProperties());
    }

    public static String resolvePropertiesIfAny(String input, Properties properties) {
        if (StringOperations.isEmpty(input)) {
            return input;
        }
        StringBuilder output = new StringBuilder();
        char[] c = input.toCharArray();
        int startBrace = 0;
        int endBrace = 0;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '$' && i < c.length && c[i + 1] == '{') {
                startBrace = i + 2;
            } else if (startBrace > 0 && c[i] == '}') {
                endBrace = i;
            }
            if (startBrace > 0 && endBrace > 0) {
                String propName = input.substring(startBrace, endBrace);
                if (!StringOperations.isEmpty(propName)) {
                    output.append(properties.getProperty(propName, "NULL"));
                }
                startBrace = 0;
                endBrace = 0;
                continue;
            }
            if (startBrace != 0 || endBrace != 0) continue;
            output.append(c[i]);
        }
        return output.toString();
    }

    public static void resetLength(StringBuilder sb) {
        StringOperationsHelper.resetLengthHelper(sb);
    }

    public static String getFirstNSegmentName(String uri, int noOfSegments) {
        return StringOperations.getFirstNSegmentName(uri, noOfSegments, '/');
    }

    public static String getFirstNSegmentName(String inputString, int noOfSegments, char segmentDelimiter) {
        int index;
        char[] c = inputString.toCharArray();
        int startpos = 0;
        int endPos = c.length;
        if (c[0] == segmentDelimiter) {
            ++startpos;
        }
        if ((index = StringOperations.nthIndexOf(c, segmentDelimiter, startpos, noOfSegments)) != -1) {
            endPos = index;
        }
        return inputString.substring(0, endPos);
    }

    public static String getLastNSegmentName(String uri, int noOfSegments) {
        return StringOperations.getLastNSegmentName(uri, noOfSegments, '/');
    }

    public static String getLastNSegmentName(String uri, int noOfSegments, char segmentDelimiter) {
        int index;
        char[] c = uri.toCharArray();
        int length = c.length;
        int endpos = length - 1;
        int startPos = 0;
        if (c[length - 1] == segmentDelimiter) {
            --endpos;
        }
        if ((index = StringOperations.nthLastIndexOf(c, segmentDelimiter, endpos, noOfSegments)) != -1) {
            startPos = index;
        }
        return uri.substring(startPos, endpos + 1);
    }

    public static String resolveJRubyScriptMethodName(String traceElementClassName, ILogger logger) {
        if (!traceElementClassName.startsWith(rubyJITCodePrefix)) {
            return null;
        }
        try {
            String[] s1 = StringRegexOperations.jRubyRegexSplit(traceElementClassName);
            if (s1.length != 2) {
                return null;
            }
            return s1[1].substring(0, s1[1].lastIndexOf(95));
        }
        catch (Exception e) {
            logger.warn("Error in parsing ruby input [" + traceElementClassName + "], " + e);
            return null;
        }
    }

    public static boolean parseBooleanStr(String str) {
        return StringOperationsHelper.parseBoolean(str);
    }

    public static boolean getBooleanStr(String str) {
        return StringOperationsHelper.getBoolean(str);
    }

    public static String classArrayToString(Class[] paramClassList) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; paramClassList != null && i < paramClassList.length; ++i) {
            builder.append(ReflectionUtilityCommon.getName(paramClassList[i]));
            if (i == paramClassList.length - 1) continue;
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    public static String objectArrayToString(Object[] paramObjectList) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; i < paramObjectList.length; ++i) {
            builder.append("{ ");
            builder.append("type <");
            builder.append(paramObjectList[i] != null ? ReflectionUtilityCommon.getName(paramObjectList[i].getClass()) : "NULL");
            builder.append(">, value <");
            builder.append(String.valueOf(paramObjectList[i]));
            builder.append("> }");
            if (i == paramObjectList.length - 1) continue;
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    public static String fixNameForMetric(String name, char replaceChar) {
        if (StringOperations.isEmpty(name)) {
            return name;
        }
        return name.replace(':', replaceChar).replace('|', replaceChar);
    }

    public static String cropString(String str, int length) {
        if (str.length() > length) {
            return str.substring(0, length);
        }
        return str;
    }

    public static String convertToCommaSeparateString(Object[] rules) {
        StringBuilder builder = new StringBuilder();
        if (rules != null) {
            for (Object rule : rules) {
                builder.append("[");
                builder.append(String.valueOf(rule));
                builder.append("],");
            }
        } else {
            builder.append("[NULL]");
        }
        return builder.toString();
    }

    public static String toUppercaseEnglishLocale(String s) {
        return StringOperationsHelper.toUppercaseEnglishLocale(s);
    }

    public static String join(List items, String separator) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < items.size(); ++i) {
            buffer.append(items.get(i).toString());
            if (i >= items.size() - 1) continue;
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public static double[] toDoubleArray(float[] floatArray) {
        double[] doubleArray = new double[floatArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = floatArray[i];
        }
        return doubleArray;
    }

    public static String numberToInvariantString(Object o) {
        return StringOperationsHelper.numberToInvariantString(o);
    }

    public static boolean isNullOrWhiteSpace(String s) {
        return StringOperationsHelper.isNullOrWhiteSpace(s);
    }

    public static String[] splitWrapper(String str, String regex, int numberOfSplits) {
        return StringOperationsHelper.split(str, regex, numberOfSplits);
    }

    public static enum CaseConvert {
        none,
        upper,
        lower;

    }
}

