/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.loader;

import com.singularity.ee.util.io.FileUtil;
import com.singularity.ee.util.loader.IResourceFinder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DirResourceFinder
implements IResourceFinder {
    private Set<String> dirClassPath = new HashSet<String>();

    public void addDirectoryToSearchPath(String path) {
        this.dirClassPath.add(path);
    }

    @Override
    public Set<String> getSearchPath() {
        return this.dirClassPath;
    }

    @Override
    public InputStream findResourceAsStream(String resourceName) throws IOException {
        for (String dir : this.dirClassPath) {
            File resourceOnDisk = new File(dir + File.separator + resourceName);
            if (!resourceOnDisk.exists()) continue;
            return new FileInputStream(resourceOnDisk);
        }
        return null;
    }

    @Override
    public URL findResource(String resourceName) throws IOException {
        for (String dir : this.dirClassPath) {
            File resourceOnDisk = new File(dir + File.separator + resourceName);
            if (!resourceOnDisk.exists()) continue;
            return resourceOnDisk.getAbsoluteFile().toURI().toURL();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] findClassfromPath(String className) throws IOException {
        FileInputStream fis = null;
        try {
            for (String dir : this.dirClassPath) {
                File classOnDisk = new File(dir + File.separator + className.replace(".", "/") + ".class");
                if (!classOnDisk.exists()) continue;
                fis = new FileInputStream(classOnDisk);
                byte[] byArray = FileUtil.inputStreamToByteArray(fis);
                return byArray;
            }
            Iterator<String> iterator = null;
            return iterator;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

