/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.javaspecific.scheduler;

import com.singularity.ee.util.collections.bounded.BoundsPolicy;
import com.singularity.ee.util.collections.bounded.safety.ICustomAction;
import com.singularity.ee.util.javaspecific.scheduler.ADScheduledThreadPoolExecutor;
import com.singularity.ee.util.javaspecific.scheduler.AgentScheduledThreadPoolExecutorImpl;
import com.singularity.ee.util.javaspecific.scheduler.ExecutionTracker;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IAgentScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class ExecutorFactory {
    private static volatile int pauseExecutions = 0;

    private ExecutorFactory() {
    }

    public static IAgentScheduledThreadPoolExecutor newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory, ILogger logger) {
        return ExecutorFactory.toIAgentScheduledThreadPoolExecutor(ExecutorFactory.createADScheduledThreadPoolExecutor(corePoolSize, threadFactory), logger);
    }

    public static IAgentScheduledThreadPoolExecutor newScheduledThreadPool(int corePoolSize, ILogger logger) {
        return ExecutorFactory.toIAgentScheduledThreadPoolExecutor(ExecutorFactory.createADScheduledThreadPoolExecutor(corePoolSize), logger);
    }

    public static IAgentScheduledThreadPoolExecutor newScheduledThreadPool(int corePoolSize, int maxTasksAllowed, BoundsPolicy policy, ICustomAction customAction, ThreadFactory threadFactory, ILogger logger) {
        return ExecutorFactory.toIAgentScheduledThreadPoolExecutor(ExecutorFactory.createADScheduledThreadPoolExecutor(corePoolSize, maxTasksAllowed, policy, customAction, threadFactory), logger);
    }

    public static IAgentScheduledThreadPoolExecutor newScheduledThreadPool(int coreSize) {
        ILogger logger = null;
        return ExecutorFactory.newScheduledThreadPool(coreSize, logger);
    }

    public static IAgentScheduledThreadPoolExecutor newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory) {
        ILogger logger = null;
        return ExecutorFactory.newScheduledThreadPool(corePoolSize, threadFactory, logger);
    }

    public static void pauseExecutions(int delayWait) {
        pauseExecutions = delayWait;
    }

    public static void resumeExecutions() {
        pauseExecutions = 0;
    }

    private static ADScheduledThreadPoolExecutor createADScheduledThreadPoolExecutor(int corePoolSize) {
        return new PausedExecutionScheduledThreadPoolExecutor(corePoolSize);
    }

    private static ADScheduledThreadPoolExecutor createADScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        return new PausedExecutionScheduledThreadPoolExecutor(corePoolSize, threadFactory);
    }

    private static ADScheduledThreadPoolExecutor createADScheduledThreadPoolExecutor(int corePoolSize, int maxTasksAllowed, BoundsPolicy policy, ICustomAction customAction, ThreadFactory threadFactory) {
        return new PausedExecutionScheduledThreadPoolExecutor(corePoolSize, maxTasksAllowed, policy, customAction, threadFactory);
    }

    private static IAgentScheduledThreadPoolExecutor toIAgentScheduledThreadPoolExecutor(ADScheduledThreadPoolExecutor executor, ILogger logger) {
        return new AgentScheduledThreadPoolExecutorImpl(executor, logger);
    }

    private static class PausedExecutionScheduledThreadPoolExecutor
    extends ADScheduledThreadPoolExecutor {
        public PausedExecutionScheduledThreadPoolExecutor(int corePoolSize) {
            super(corePoolSize);
        }

        public PausedExecutionScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, threadFactory);
        }

        public PausedExecutionScheduledThreadPoolExecutor(int corePoolSize, int maxTasksAllowed, BoundsPolicy policy, ICustomAction customAction, ThreadFactory threadFactory) {
            super(corePoolSize, maxTasksAllowed, policy, customAction, threadFactory);
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            while (pauseExecutions > 0) {
                try {
                    Thread.sleep(pauseExecutions);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (ExecutionTracker.ENABLED) {
                ExecutionTracker.track(r);
            }
            super.beforeExecute(t, r);
        }
    }
}

