/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.util.javaspecific.scheduler;

import com.singularity.ee.util.javaspecific.scheduler.ADScheduledThreadPoolExecutor;
import com.singularity.ee.util.javaspecific.scheduler.AgentScheduledExecutorServiceImpl;
import com.singularity.ee.util.javaspecific.scheduler.IAgentRunnableMeasurer;
import com.singularity.ee.util.javaspecific.scheduler.IAgentSchedulerMeasurerProvider;
import com.singularity.ee.util.javaspecific.scheduler.SchedulerMonitor;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IAgentScheduledThreadPoolExecutor;

class AgentScheduledThreadPoolExecutorImpl
extends AgentScheduledExecutorServiceImpl
implements IAgentScheduledThreadPoolExecutor {
    private ADScheduledThreadPoolExecutor executor;
    private SchedulerMonitor monitor;
    private volatile IAgentSchedulerMeasurerProvider agentSchedulerMeasurerProvider;

    AgentScheduledThreadPoolExecutorImpl(ADScheduledThreadPoolExecutor executor, ILogger logger) {
        super(executor, logger);
        this.executor = executor;
        this.executor.setLogger(logger);
    }

    @Override
    public boolean remove(IAgentRunnable task) {
        return this.executor.remove(task);
    }

    @Override
    public synchronized void setLogger(ILogger logger) {
        if (this.logger != logger) {
            this.logger = logger;
            if (this.logger != null) {
                if (this.monitor == null) {
                    this.monitor = new SchedulerMonitor(this, logger);
                }
            } else if (this.monitor != null) {
                this.monitor.stopMonitoring();
                this.monitor = null;
            }
            if (this.executor != null) {
                this.executor.setLogger(logger);
            }
        }
    }

    @Override
    public void look() {
        if (this.logger != null) {
            try {
                if (this.scheduledExecutorService instanceof ADScheduledThreadPoolExecutor) {
                    ADScheduledThreadPoolExecutor adExecutor = this.scheduledExecutorService;
                    this.logger.info(String.format("Looking at %s", this.toString()));
                    adExecutor.log(this.logger);
                }
            }
            catch (Throwable t) {
                this.logger.error(t.toString(), t);
            }
        }
    }

    public ADScheduledThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public void setLimit(int limit) {
        if (this.executor != null) {
            this.executor.setQueueLimit(limit);
        }
    }

    @Override
    public void setGuardAgainstNanoTimeInconsistencies() {
        if (this.executor != null) {
            this.executor.setGuardAgainstNanoTimeInconsistencies();
        }
    }

    @Override
    public void setAgentSchedulerMeasurerProvider(IAgentSchedulerMeasurerProvider agentSchedulerMeasurerProvider) {
        this.agentSchedulerMeasurerProvider = agentSchedulerMeasurerProvider;
    }

    @Override
    protected IAgentRunnableMeasurer getMeasurer() {
        if (this.agentSchedulerMeasurerProvider != null) {
            return this.agentSchedulerMeasurerProvider.getAgentRunnableMeasurer();
        }
        return null;
    }
}

